/*
 * Decompiled with CFR 0.152.
 */
package com.github.phylogeny.boundtotems.client.jei;

import com.github.phylogeny.boundtotems.client.jei.InWorldRecipe;
import com.github.phylogeny.boundtotems.util.LangUtil;
import com.mojang.blaze3d.systems.RenderSystem;
import java.util.Collections;
import java.util.List;
import mezz.jei.api.gui.IRecipeLayout;
import mezz.jei.api.gui.drawable.IDrawable;
import mezz.jei.api.gui.ingredient.IGuiItemStackGroup;
import mezz.jei.api.helpers.IGuiHelper;
import mezz.jei.api.ingredients.IIngredients;
import mezz.jei.api.recipe.category.IRecipeCategory;
import net.minecraft.block.Blocks;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.FontRenderer;
import net.minecraft.client.renderer.BufferBuilder;
import net.minecraft.client.renderer.Matrix4f;
import net.minecraft.client.renderer.Tessellator;
import net.minecraft.client.renderer.TransformationMatrix;
import net.minecraft.client.renderer.WorldVertexBufferUploader;
import net.minecraft.client.renderer.vertex.DefaultVertexFormats;
import net.minecraft.client.resources.I18n;
import net.minecraft.item.ItemStack;
import net.minecraft.util.IItemProvider;
import net.minecraft.util.ResourceLocation;
import net.minecraftforge.fml.client.gui.GuiUtils;

public class InWorldRecipeCategory
implements IRecipeCategory<InWorldRecipe> {
    public static final String NAME = "in_world_crafting";
    public static final String LANG_KEY_PREFIX = LangUtil.getKey("jei", "in_world_crafting");
    private static final String LANG_KEY = LANG_KEY_PREFIX + ".category";
    public static final ResourceLocation UID = new ResourceLocation("boundtotems", "in_world_crafting");
    private static final ResourceLocation TEXTURE_GUI = new ResourceLocation("boundtotems", "textures/jei/in_world_crafting_gui.png");
    private final IDrawable background;
    private final IDrawable backgroundSlot;
    private final IDrawable arrow;
    private final IGuiHelper guiHelper;

    public InWorldRecipeCategory(IGuiHelper guiHelper) {
        this.guiHelper = guiHelper;
        this.backgroundSlot = guiHelper.createDrawable(new ResourceLocation("minecraft:textures/gui/container/furnace.png"), 111, 30, 26, 26);
        this.arrow = guiHelper.createDrawable(TEXTURE_GUI, 32, 0, 22, 15);
        this.background = guiHelper.createBlankDrawable(160, 125);
    }

    public ResourceLocation getUid() {
        return UID;
    }

    public Class<? extends InWorldRecipe> getRecipeClass() {
        return InWorldRecipe.class;
    }

    public String getTitle() {
        return I18n.func_135052_a((String)LANG_KEY, (Object[])new Object[0]);
    }

    public IDrawable getBackground() {
        return this.background;
    }

    public IDrawable getIcon() {
        return this.guiHelper.createDrawableIngredient((Object)new ItemStack((IItemProvider)Blocks.field_196658_i));
    }

    public void setIngredients(InWorldRecipe recipe, IIngredients ingredients) {
        recipe.setIngredients(ingredients);
    }

    public void setRecipe(IRecipeLayout recipeLayout, InWorldRecipe recipe, IIngredients ingredients) {
        IGuiItemStackGroup guiItemStacks = recipeLayout.getItemStacks();
        guiItemStacks.init(0, false, 132, 10);
        guiItemStacks.init(1, true, 117, 75);
        guiItemStacks.set(ingredients);
    }

    public void draw(InWorldRecipe recipe, double mouseX, double mouseY) {
        this.drawTexture(recipe.getCurrentSlide(), 0.0f, 0.0f, 90.0f, 125.0f);
        int offsetX = 100;
        int offsetY = 6;
        this.backgroundSlot.draw(offsetX + 28, offsetY);
        this.arrow.draw(offsetX - 2, offsetY + 5);
        FontRenderer fr = Minecraft.func_71410_x().field_71466_p;
        String tool = I18n.func_135052_a((String)(LANG_KEY + ".tool"), (Object[])new Object[0]);
        fr.func_211126_b(tool, (float)((offsetX += 12) + 14) - (float)fr.func_78256_a(tool) / 2.0f, (float)(offsetY += 54), 0);
        GuiUtils.drawContinuousTexturedBox((ResourceLocation)TEXTURE_GUI, (int)offsetX, (int)(offsetY + 10), (int)0, (int)0, (int)28, (int)28, (int)32, (int)16, (int)2, (float)0.0f);
    }

    private void drawTexture(ResourceLocation texture, float x, float y, float width, float height) {
        Minecraft.func_71410_x().func_110434_K().func_110577_a(texture);
        Matrix4f matrix = TransformationMatrix.func_227983_a_().func_227988_c_();
        BufferBuilder buffer = Tessellator.func_178181_a().func_178180_c();
        RenderSystem.defaultBlendFunc();
        buffer.func_181668_a(7, DefaultVertexFormats.field_181707_g);
        buffer.func_227888_a_(matrix, x, y + height, 0.0f).func_225583_a_(0.0f, 1.0f).func_181675_d();
        buffer.func_227888_a_(matrix, x + width, y + height, 0.0f).func_225583_a_(1.0f, 1.0f).func_181675_d();
        buffer.func_227888_a_(matrix, x + width, y, 0.0f).func_225583_a_(1.0f, 0.0f).func_181675_d();
        buffer.func_227888_a_(matrix, x, y, 0.0f).func_225583_a_(0.0f, 0.0f).func_181675_d();
        buffer.func_178977_d();
        RenderSystem.enableAlphaTest();
        WorldVertexBufferUploader.func_181679_a((BufferBuilder)buffer);
    }

    public List<String> getTooltipStrings(InWorldRecipe recipe, double mouseX, double mouseY) {
        return mouseX < 90.0 ? recipe.getTooltip() : Collections.emptyList();
    }
}

