/*
 * Decompiled with CFR 0.152.
 */
package com.github.phylogeny.boundtotems.client.jei;

import com.github.phylogeny.boundtotems.Config;
import com.github.phylogeny.boundtotems.client.jei.InWorldRecipe;
import com.github.phylogeny.boundtotems.client.jei.InWorldRecipeCategory;
import com.github.phylogeny.boundtotems.init.ItemsMod;
import com.github.phylogeny.boundtotems.item.ItemTotemShelf;
import com.github.phylogeny.boundtotems.util.LangUtil;
import com.github.phylogeny.boundtotems.util.NBTUtil;
import java.util.ArrayList;
import mezz.jei.api.IModPlugin;
import mezz.jei.api.JeiPlugin;
import mezz.jei.api.constants.VanillaTypes;
import mezz.jei.api.helpers.IGuiHelper;
import mezz.jei.api.recipe.category.IRecipeCategory;
import mezz.jei.api.registration.IRecipeCatalystRegistration;
import mezz.jei.api.registration.IRecipeCategoryRegistration;
import mezz.jei.api.registration.IRecipeRegistration;
import net.minecraft.block.Blocks;
import net.minecraft.client.resources.I18n;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.item.Items;
import net.minecraft.nbt.CompoundNBT;
import net.minecraft.util.IItemProvider;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.math.MathHelper;
import net.minecraftforge.fml.RegistryObject;

@JeiPlugin
public class JustEnoughItemsPlugin
implements IModPlugin {
    private static final String ITEM_INFO_LANG_KEY = LangUtil.getKey("jei", "item_info");

    public ResourceLocation getPluginUid() {
        return new ResourceLocation("boundtotems", "jei");
    }

    public void registerRecipes(IRecipeRegistration registration) {
        ItemStack stackBloodyKnife = new ItemStack((IItemProvider)ItemsMod.RITUAL_DAGGER.get());
        NBTUtil.setBoundEntity(stackBloodyKnife, MathHelper.func_188210_a(), I18n.func_135052_a((String)LangUtil.join(InWorldRecipeCategory.LANG_KEY_PREFIX, "entity_name"), (Object[])new Object[0]));
        CompoundNBT nbtBloody = stackBloodyKnife.func_77978_p();
        assert (nbtBloody != null);
        CompoundNBT nbtBound = nbtBloody.func_74737_b();
        NBTUtil.bindKnife(nbtBound);
        ItemStack stackBoundKnife = stackBloodyKnife.func_77946_l();
        stackBloodyKnife.func_77982_d(nbtBloody);
        stackBoundKnife.func_77982_d(nbtBound);
        ItemStack stackTotemBound = new ItemStack((IItemProvider)ItemsMod.BOUND_TOTEM.get());
        ItemStack stackTotemBoundTeleporting = new ItemStack((IItemProvider)ItemsMod.BOUND_TOTEM_TELEPORTING.get());
        stackTotemBound.func_77982_d(nbtBloody);
        stackTotemBoundTeleporting.func_77982_d(nbtBloody);
        ItemStack stackPlanks = new ItemStack((IItemProvider)ItemsMod.PLANK.get(), 4);
        IGuiHelper guiHelper = registration.getJeiHelpers().getGuiHelper();
        ArrayList<InWorldRecipe> recipes = new ArrayList<InWorldRecipe>();
        ItemTotemShelf shelf = (ItemTotemShelf)ItemsMod.TOTEM_SHELF_ITEM.get();
        recipes.add(new InWorldRecipe("bloody_dagger", guiHelper, 1, (IItemProvider)ItemsMod.RITUAL_DAGGER.get()).setOutputs(stackBloodyKnife));
        recipes.add(new InWorldRecipe("bind_totem", guiHelper, 2, stackBloodyKnife, stackBoundKnife).setAdditionalInputs(new IItemProvider[]{Items.field_190929_cY}).setOutputs(stackTotemBound));
        recipes.add(new InWorldRecipe("totem_shelf_frame", guiHelper, 9, (IItemProvider)ItemsMod.CARVING_KNIFE.get()).setAdditionalInputs(new IItemProvider[]{Blocks.field_196617_K, Blocks.field_203204_R}).setOutputs(stackPlanks));
        recipes.add(new InWorldRecipe("totem_shelf", guiHelper, 5, stackPlanks).setAdditionalInputs(new IItemProvider[]{shelf}).setOutputs(new IItemProvider[]{shelf}));
        recipes.add(new InWorldRecipe("bind_shelf", guiHelper, 4, stackBloodyKnife, stackBoundKnife).setAdditionalInputs(new IItemProvider[]{shelf}).setOutputs(stackBoundKnife).setLangParameters(Config.SERVER.maxDistanceToShelf.get(), Config.SERVER.maxBoundShelves.get()));
        recipes.add(new InWorldRecipe("shelf_put_take_totems", guiHelper, 6, stackTotemBound, stackTotemBoundTeleporting).setAdditionalInputs(new IItemProvider[]{shelf}).setOutputs(stackTotemBound, stackTotemBoundTeleporting));
        registration.addRecipes(recipes, InWorldRecipeCategory.UID);
        String allowedTotemLocations = I18n.func_135052_a((String)LangUtil.join(ITEM_INFO_LANG_KEY, ((Config.Server.InventorySearch)((Object)Config.SERVER.inventorySearch.get())).name().toLowerCase()), (Object[])new Object[0]);
        JustEnoughItemsPlugin.addItemInfo(registration, ItemsMod.RITUAL_DAGGER, new Object[0]);
        JustEnoughItemsPlugin.addItemInfo(registration, ItemsMod.BOUND_TOTEM, allowedTotemLocations);
        JustEnoughItemsPlugin.addItemInfo(registration, ItemsMod.BOUND_TOTEM_TELEPORTING, new Object[0]);
        JustEnoughItemsPlugin.addItemInfo(registration, ItemsMod.CARVING_KNIFE, new Object[0]);
        JustEnoughItemsPlugin.addItemInfo(registration, ItemsMod.PLANK, new Object[0]);
        JustEnoughItemsPlugin.addItemInfo(registration, ItemsMod.TOTEM_SHELF_ITEM, allowedTotemLocations);
    }

    private static <I extends Item> void addItemInfo(IRecipeRegistration registration, RegistryObject<I> item, Object ... parameters) {
        registration.addIngredientInfo((Object)new ItemStack((IItemProvider)item.get()), VanillaTypes.ITEM, new String[]{I18n.func_135052_a((String)LangUtil.join(ITEM_INFO_LANG_KEY, ((Item)item.get()).getRegistryName().func_110623_a()), (Object[])parameters)});
    }

    public void registerRecipeCatalysts(IRecipeCatalystRegistration registration) {
        registration.addRecipeCatalyst((Object)new ItemStack((IItemProvider)Blocks.field_150462_ai), new ResourceLocation[]{InWorldRecipeCategory.UID});
    }

    public void registerCategories(IRecipeCategoryRegistration registration) {
        registration.addRecipeCategories(new IRecipeCategory[]{new InWorldRecipeCategory(registration.getJeiHelpers().getGuiHelper())});
    }
}

