/*
 * Decompiled with CFR 0.152.
 */
package com.github.phylogeny.boundtotems.client.renderer;

import com.github.phylogeny.boundtotems.block.BlockTotemShelf;
import com.github.phylogeny.boundtotems.client.BufferBuilderTransparent;
import com.github.phylogeny.boundtotems.init.BlocksMod;
import com.github.phylogeny.boundtotems.init.ItemsMod;
import com.github.phylogeny.boundtotems.tileentity.TileEntityTotemShelf;
import com.github.phylogeny.boundtotems.tileentity.TileEntityTotemShelfBinding;
import com.github.phylogeny.boundtotems.util.CapabilityUtil;
import com.google.common.base.Suppliers;
import com.mojang.blaze3d.matrix.MatrixStack;
import java.util.function.Supplier;
import net.minecraft.client.Minecraft;
import net.minecraft.client.renderer.IRenderTypeBuffer;
import net.minecraft.client.renderer.ItemRenderer;
import net.minecraft.client.renderer.Vector3f;
import net.minecraft.client.renderer.model.IBakedModel;
import net.minecraft.client.renderer.model.ItemCameraTransforms;
import net.minecraft.client.renderer.tileentity.TileEntityRenderer;
import net.minecraft.client.renderer.tileentity.TileEntityRendererDispatcher;
import net.minecraft.item.ItemStack;
import net.minecraft.state.IProperty;
import net.minecraft.util.Direction;
import net.minecraft.util.IItemProvider;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.Vec3d;
import net.minecraftforge.items.IItemHandler;

public class RendererTileEntityTotemShelf
extends TileEntityRenderer<TileEntityTotemShelf> {
    private final Supplier<ItemStack> daggerStack = Suppliers.memoize(() -> new ItemStack((IItemProvider)ItemsMod.RITUAL_DAGGER.get()));
    private final Supplier<ItemStack> totemShelfStack = Suppliers.memoize(() -> new ItemStack((IItemProvider)BlocksMod.TOTEM_SHELF.get()));

    public RendererTileEntityTotemShelf(TileEntityRendererDispatcher rendererDispatcher) {
        super(rendererDispatcher);
    }

    public void render(TileEntityTotemShelf totemShelf, float partialTicks, MatrixStack matrixStack, IRenderTypeBuffer buffer, int combinedLight, int combinedOverlay) {
        matrixStack.func_227860_a_();
        BlockPos pos = totemShelf.func_174877_v();
        Integer alpha = null;
        IRenderTypeBuffer.Impl typeBuffer = BufferBuilderTransparent.getRenderTypeBuffer();
        matrixStack.func_227860_a_();
        matrixStack.func_227861_a_(0.50002, -0.496875, 0.50002);
        Direction facing = (Direction)totemShelf.func_195044_w().func_177229_b((IProperty)BlockTotemShelf.FACING);
        if (facing.func_176740_k() == Direction.Axis.X) {
            facing = facing.func_176734_d();
        }
        matrixStack.func_227863_a_(Vector3f.field_229181_d_.func_229193_c_((float)Math.toRadians(facing.func_185119_l())));
        if (totemShelf instanceof TileEntityTotemShelfBinding) {
            alpha = (int)(255.0f * ((TileEntityTotemShelfBinding)totemShelf).getBindingPercentage());
            this.renderItemGlowing(this.totemShelfStack.get(), ItemCameraTransforms.TransformType.NONE, matrixStack, typeBuffer, combinedOverlay, alpha);
        }
        IItemHandler inventory = CapabilityUtil.getInventory(totemShelf);
        int size = inventory.getSlots();
        matrixStack.func_227861_a_(-0.18, 0.96875, -0.3);
        float scaleTotems = 0.7f;
        matrixStack.func_227862_a_(scaleTotems, scaleTotems, scaleTotems);
        for (int i = 0; i < size; ++i) {
            ItemStack stack = inventory.getStackInSlot(i);
            if (stack.func_190926_b()) continue;
            matrixStack.func_227860_a_();
            matrixStack.func_227861_a_((double)(i % 2) * 0.5, (double)(-(i / 2)) * (0.625 / (double)scaleTotems), 0.0);
            this.renderItem(stack, matrixStack, buffer, combinedLight, combinedOverlay);
            matrixStack.func_227865_b_();
        }
        matrixStack.func_227865_b_();
        Vec3d knifePos = totemShelf.getKnifePos();
        if (knifePos != null) {
            matrixStack.func_227861_a_(knifePos.field_72450_a - (double)pos.func_177958_n(), knifePos.field_72448_b - (double)pos.func_177956_o(), knifePos.field_72449_c - (double)pos.func_177952_p());
            matrixStack.func_227863_a_(Vector3f.field_229181_d_.func_229193_c_((float)Math.toRadians(-90.0)));
            Vec3d dir = totemShelf.getKnifeDirection();
            assert (dir != null);
            matrixStack.func_227863_a_(Vector3f.field_229181_d_.func_229193_c_((float)Math.atan2(dir.field_72450_a, dir.field_72449_c)));
            matrixStack.func_227863_a_(Vector3f.field_229183_f_.func_229193_c_((float)Math.toRadians(-45.0)));
            matrixStack.func_227863_a_(Vector3f.field_229183_f_.func_229193_c_((float)Math.asin(dir.field_72448_b)));
            matrixStack.func_227861_a_(0.0, -0.15, 0.0);
            BufferBuilderTransparent.alpha = 255;
            this.renderItem(totemShelf.getKnife(), matrixStack, (IRenderTypeBuffer)(alpha != null ? typeBuffer : buffer), combinedLight, combinedOverlay);
            if (alpha != null) {
                this.renderItemGlowing(totemShelf.getKnife().func_77946_l(), ItemCameraTransforms.TransformType.GROUND, matrixStack, typeBuffer, combinedOverlay, alpha);
            }
        }
        matrixStack.func_227865_b_();
    }

    public void renderItem(ItemStack stack, MatrixStack matrixStack, IRenderTypeBuffer buffer, int combinedLight, int combinedOverlay) {
        IBakedModel model = Minecraft.func_71410_x().func_175599_af().func_184393_a(stack, this.field_228858_b_.field_147550_f, null);
        Minecraft.func_71410_x().func_175599_af().func_229111_a_(stack, ItemCameraTransforms.TransformType.GROUND, false, matrixStack, buffer, combinedLight, combinedOverlay, model);
    }

    public void renderItemGlowing(ItemStack stack, ItemCameraTransforms.TransformType transformType, MatrixStack matrixStack, IRenderTypeBuffer.Impl typeBuffer, int combinedOverlay, Integer alpha) {
        ItemRenderer itemRenderer = Minecraft.func_71410_x().func_175599_af();
        stack.func_196082_o().func_74774_a("glowing", (byte)0);
        IBakedModel model = itemRenderer.func_184393_a(stack, this.field_228858_b_.field_147550_f, null);
        BufferBuilderTransparent.alpha = alpha;
        itemRenderer.func_229111_a_(this.daggerStack.get(), transformType, false, matrixStack, (IRenderTypeBuffer)typeBuffer, 0xF000F0, combinedOverlay, model);
        typeBuffer.func_228461_a_();
    }
}

