/*
 * Decompiled with CFR 0.152.
 */
package com.github.phylogeny.boundtotems.item;

import com.github.phylogeny.boundtotems.init.ItemsMod;
import com.github.phylogeny.boundtotems.network.PacketNetwork;
import com.github.phylogeny.boundtotems.network.packet.PacketAddGhost;
import com.github.phylogeny.boundtotems.util.EntityUtil;
import com.github.phylogeny.boundtotems.util.NBTUtil;
import com.google.common.collect.Multimap;
import java.util.List;
import javax.annotation.Nullable;
import net.minecraft.block.BlockState;
import net.minecraft.block.CauldronBlock;
import net.minecraft.client.util.ITooltipFlag;
import net.minecraft.entity.Entity;
import net.minecraft.entity.LivingEntity;
import net.minecraft.entity.SharedMonsterAttributes;
import net.minecraft.entity.ai.attributes.AttributeModifier;
import net.minecraft.entity.item.ItemEntity;
import net.minecraft.entity.player.PlayerEntity;
import net.minecraft.entity.player.ServerPlayerEntity;
import net.minecraft.inventory.EquipmentSlotType;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.item.ItemUseContext;
import net.minecraft.item.Items;
import net.minecraft.state.IProperty;
import net.minecraft.util.ActionResult;
import net.minecraft.util.ActionResultType;
import net.minecraft.util.Hand;
import net.minecraft.util.IItemProvider;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.SoundCategory;
import net.minecraft.util.SoundEvents;
import net.minecraft.util.text.ITextComponent;
import net.minecraft.world.World;

public class ItemRitualDagger
extends Item {
    public static final String NAME = "ritual_dagger";

    public ItemRitualDagger(Item.Properties properties) {
        super(properties.func_200917_a(1));
        this.func_185043_a(new ResourceLocation("state"), (stack, world, entity) -> stack.func_77942_o() && stack.func_77978_p().func_74764_b("glowing") ? 3.0f : (float)State.get(stack).ordinal());
    }

    public Multimap<String, AttributeModifier> getAttributeModifiers(EquipmentSlotType slot, ItemStack stack) {
        Multimap map = super.getAttributeModifiers(slot, stack);
        if (slot == EquipmentSlotType.MAINHAND && State.get(stack) == State.BOUND) {
            map.put((Object)SharedMonsterAttributes.field_111264_e.func_111108_a(), (Object)new AttributeModifier(field_111210_e, "Weapon modifier", 5.0, AttributeModifier.Operation.ADDITION));
        }
        return map;
    }

    public String func_77667_c(ItemStack stack) {
        return State.get(stack).getLangKey();
    }

    public void func_77624_a(ItemStack stack, @Nullable World world, List<ITextComponent> tooltip, ITooltipFlag flag) {
        NBTUtil.addBoundEntityInformation(stack, tooltip);
    }

    public ActionResult<ItemStack> func_77659_a(World world, PlayerEntity player, Hand hand) {
        ItemEntity entityTotem;
        ActionResultType result = ActionResultType.PASS;
        ItemStack stack = player.func_184586_b(hand);
        if (player.func_225608_bj_()) {
            this.setBoundEntity(stack, player, (Entity)player, true);
            result = ActionResultType.SUCCESS;
        } else if (NBTUtil.hasBoundEntity(stack) && (entityTotem = EntityUtil.rayTraceEntities(world, player, ItemEntity.class, box -> box.func_72321_a(0.0, 0.25, 0.0))) != null && entityTotem.func_92059_d().func_77973_b() == Items.field_190929_cY) {
            if (!world.field_72995_K) {
                entityTotem.func_92058_a(NBTUtil.copyBoundEntity(stack, new ItemStack((IItemProvider)ItemsMod.BOUND_TOTEM.get())));
                this.sendGhostPacket(player, (Entity)entityTotem);
            }
            result = ActionResultType.SUCCESS;
            player.func_184609_a(hand);
        }
        return new ActionResult(result, (Object)stack);
    }

    private boolean setBoundEntity(ItemStack stack, PlayerEntity player, Entity entity, boolean attackSelf) {
        if (!(player instanceof ServerPlayerEntity) || !(entity instanceof LivingEntity)) {
            return false;
        }
        if (attackSelf) {
            player.func_71059_n((Entity)player);
            player.func_184821_cY();
            return true;
        }
        return NBTUtil.setBoundEntity(stack, (LivingEntity)entity);
    }

    public boolean onLeftClickEntity(ItemStack stack, PlayerEntity player, Entity entity) {
        if (this.setBoundEntity(stack, player, entity, false)) {
            this.sendGhostPacket(player, entity);
        }
        return false;
    }

    private void sendGhostPacket(PlayerEntity player, Entity entity) {
        PacketNetwork.sendToAllTrackingAndSelf(new PacketAddGhost(entity, 0.1f, 40, null, (Entity)player), entity);
    }

    public ActionResultType func_195939_a(ItemUseContext context) {
        int level;
        BlockState state;
        if (State.get(context.func_195996_i()) == State.BLOODY && NBTUtil.hasBoundEntity(context.func_195996_i()) && (state = context.func_195991_k().func_180495_p(context.func_195995_a())).func_177230_c() instanceof CauldronBlock && (level = ((Integer)state.func_177229_b((IProperty)CauldronBlock.field_176591_a)).intValue()) > 0) {
            ((CauldronBlock)state.func_177230_c()).func_176590_a(context.func_195991_k(), context.func_195995_a(), state, level - 1);
            context.func_195996_i().func_196082_o().func_82580_o("bound_entity");
            context.func_195991_k().func_184133_a(null, context.func_195995_a(), SoundEvents.field_193779_I, SoundCategory.BLOCKS, 1.0f, 1.0f);
            return ActionResultType.SUCCESS;
        }
        return ActionResultType.PASS;
    }

    public static enum State {
        BASE,
        BLOODY,
        BOUND;

        private final String langKey = String.join((CharSequence)".", "item", "boundtotems", "ritual_dagger", this.name().toLowerCase());

        public String getLangKey() {
            return this.langKey;
        }

        public static State get(ItemStack stack) {
            if (!NBTUtil.hasBoundEntity(stack.func_77978_p())) {
                return BASE;
            }
            return NBTUtil.isKnifeBound(stack.func_77978_p()) ? BOUND : BLOODY;
        }
    }
}

