/*
 * Decompiled with CFR 0.152.
 */
package com.github.phylogeny.boundtotems.network.packet;

import com.github.phylogeny.boundtotems.client.ClientEvents;
import com.github.phylogeny.boundtotems.init.SoundsMod;
import com.github.phylogeny.boundtotems.util.PacketBufferUtil;
import java.util.function.Supplier;
import javax.annotation.Nullable;
import net.minecraft.entity.Entity;
import net.minecraft.network.PacketBuffer;
import net.minecraft.util.SoundEvent;
import net.minecraft.util.math.Vec3d;
import net.minecraft.world.World;
import net.minecraftforge.fml.network.NetworkEvent;

public class PacketAddGhost {
    private int entityId;
    private int maxLife;
    private float velocity;
    private Vec3d targetPos;
    private Integer targetEntityId;

    public PacketAddGhost() {
    }

    public PacketAddGhost(Entity entity, float velocity, int maxLife, @Nullable Vec3d targetPos, @Nullable Entity targetEntity) {
        this(entity.func_145782_y(), velocity, maxLife, targetPos, targetEntity == null ? null : Integer.valueOf(targetEntity.func_145782_y()));
    }

    public PacketAddGhost(int entityId, float velocity, int maxLife, @Nullable Vec3d targetPos, @Nullable Integer targetEntityId) {
        this.entityId = entityId;
        this.velocity = velocity;
        this.maxLife = maxLife;
        this.targetPos = targetPos;
        this.targetEntityId = targetEntityId;
    }

    public static void encode(PacketAddGhost msg, PacketBuffer buf) {
        buf.writeInt(msg.entityId);
        buf.writeFloat(msg.velocity);
        buf.writeInt(msg.maxLife);
        PacketBufferUtil.writeNullableObject(buf, msg.targetPos, () -> PacketBufferUtil.writeVec(buf, msg.targetPos));
        PacketBufferUtil.writeNullableObject(buf, msg.targetEntityId, () -> buf.writeInt(msg.targetEntityId.intValue()));
    }

    public static PacketAddGhost decode(PacketBuffer buf) {
        return new PacketAddGhost(buf.readInt(), buf.readFloat(), buf.readInt(), PacketBufferUtil.readNullableObject(buf, () -> PacketBufferUtil.readVec(buf)), PacketBufferUtil.readNullableObject(buf, () -> ((PacketBuffer)buf).readInt()));
    }

    public static class Handler {
        public static void handle(PacketAddGhost msg, Supplier<NetworkEvent.Context> ctx) {
            ctx.get().enqueueWork(() -> {
                World world = ClientEvents.getWorld();
                Entity entity = world.func_73045_a(msg.entityId);
                if (entity == null) {
                    return;
                }
                ClientEvents.playSoundAtEntity(entity, (SoundEvent)SoundsMod.EXHALE.get(), 1.4f - world.field_73012_v.nextFloat() * 0.8f);
                ClientEvents.addGhost(world, entity, msg.velocity, msg.maxLife, msg.targetPos, msg.targetEntityId == null ? null : world.func_73045_a(msg.targetEntityId.intValue()));
            });
            ctx.get().setPacketHandled(true);
        }
    }
}

