/*
 * Decompiled with CFR 0.152.
 */
package com.github.phylogeny.boundtotems.network.packet;

import com.github.phylogeny.boundtotems.block.BlockTotemShelf;
import com.github.phylogeny.boundtotems.client.ClientEvents;
import com.github.phylogeny.boundtotems.tileentity.TileEntityTotemShelf;
import com.github.phylogeny.boundtotems.util.PacketBufferUtil;
import java.util.function.Supplier;
import net.minecraft.block.BlockState;
import net.minecraft.entity.player.PlayerEntity;
import net.minecraft.item.ItemStack;
import net.minecraft.network.PacketBuffer;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.Vec3d;
import net.minecraftforge.fml.network.NetworkDirection;
import net.minecraftforge.fml.network.NetworkEvent;

public class PacketAddOrRemoveKnife {
    private BlockPos pos;
    private ItemStack knifeStack = ItemStack.field_190927_a;
    private Vec3d knifePos;
    private Vec3d knifeDirection;

    public PacketAddOrRemoveKnife() {
    }

    public PacketAddOrRemoveKnife(BlockPos pos, Vec3d knifePos, ItemStack knifeStack) {
        this(pos, knifePos, knifeStack, null);
    }

    public PacketAddOrRemoveKnife(BlockPos pos, Vec3d knifePos, ItemStack knifeStack, Vec3d knifeDirection) {
        this.pos = pos;
        this.knifePos = knifePos;
        this.knifeStack = knifeStack;
        this.knifeDirection = knifeDirection;
    }

    public static void encode(PacketAddOrRemoveKnife msg, PacketBuffer buf) {
        buf.func_179255_a(msg.pos);
        PacketBufferUtil.writeVec(buf, msg.knifePos);
        buf.func_150788_a(msg.knifeStack);
        PacketBufferUtil.writeNullableObject(buf, msg.knifeDirection, () -> PacketBufferUtil.writeVec(buf, msg.knifeDirection));
    }

    public static PacketAddOrRemoveKnife decode(PacketBuffer buf) {
        return new PacketAddOrRemoveKnife(buf.func_179259_c(), PacketBufferUtil.readVec(buf), buf.func_150791_c(), PacketBufferUtil.readNullableObject(buf, () -> PacketBufferUtil.readVec(buf)));
    }

    public static class Handler {
        public static void handle(PacketAddOrRemoveKnife msg, Supplier<NetworkEvent.Context> ctx) {
            ctx.get().enqueueWork(() -> {
                BlockState state;
                PlayerEntity player;
                Object object = player = ((NetworkEvent.Context)ctx.get()).getDirection() == NetworkDirection.PLAY_TO_SERVER ? ((NetworkEvent.Context)ctx.get()).getSender() : ClientEvents.getPlayer();
                if (player == null) {
                    return;
                }
                TileEntity te = player.field_70170_p.func_175625_s(msg.pos);
                if (te instanceof TileEntityTotemShelf && (state = player.field_70170_p.func_180495_p(msg.pos)).func_177230_c() instanceof BlockTotemShelf) {
                    if (msg.knifeDirection != null) {
                        ((TileEntityTotemShelf)te).addKnife(msg.knifePos, msg.knifeDirection, msg.knifeStack);
                    } else {
                        ClientEvents.addKnifeRemovalEffects(msg.knifePos, state);
                        ((TileEntityTotemShelf)te).removeKnife();
                    }
                }
            });
            ctx.get().setPacketHandled(true);
        }
    }
}

