/*
 * Decompiled with CFR 0.152.
 */
package com.github.phylogeny.boundtotems.network.packet;

import com.github.phylogeny.boundtotems.client.ClientEvents;
import com.github.phylogeny.boundtotems.network.PacketNetwork;
import java.util.function.Supplier;
import net.minecraft.network.PacketBuffer;
import net.minecraft.util.Direction;
import net.minecraft.util.math.BlockPos;
import net.minecraftforge.fml.network.NetworkDirection;
import net.minecraftforge.fml.network.NetworkEvent;

public class PacketTotemShelfCarveEffects {
    private int stageNext;
    private BlockPos pos;
    private Direction facing;

    public PacketTotemShelfCarveEffects() {
    }

    public PacketTotemShelfCarveEffects(int stageNext, BlockPos pos, Direction facing) {
        this.stageNext = stageNext;
        this.pos = pos;
        this.facing = facing;
    }

    public static void encode(PacketTotemShelfCarveEffects msg, PacketBuffer buf) {
        buf.writeInt(msg.stageNext);
        buf.func_179255_a(msg.pos);
        buf.writeInt(msg.facing.func_176745_a());
    }

    public static PacketTotemShelfCarveEffects decode(PacketBuffer buf) {
        return new PacketTotemShelfCarveEffects(buf.readInt(), buf.func_179259_c(), Direction.func_82600_a((int)buf.readInt()));
    }

    public static class Handler {
        public static void handle(PacketTotemShelfCarveEffects msg, Supplier<NetworkEvent.Context> ctx) {
            ctx.get().enqueueWork(() -> {
                if (((NetworkEvent.Context)ctx.get()).getDirection() == NetworkDirection.PLAY_TO_CLIENT) {
                    ClientEvents.addTotemShelfCarveEffects(msg.pos, msg.stageNext, msg.facing);
                    PacketNetwork.sendToServer(new PacketTotemShelfCarveEffects(msg.stageNext, msg.pos, msg.facing));
                }
            });
            ctx.get().setPacketHandled(true);
        }
    }
}

