/*
 * Decompiled with CFR 0.152.
 */
package com.github.phylogeny.boundtotems.tileentity;

import com.github.phylogeny.boundtotems.BoundTotems;
import com.github.phylogeny.boundtotems.Config;
import com.github.phylogeny.boundtotems.block.BlockTotemShelf;
import com.github.phylogeny.boundtotems.block.PositionsTotemShelf;
import com.github.phylogeny.boundtotems.block.ShelfDropRemovalModifier;
import com.github.phylogeny.boundtotems.init.SoundsMod;
import com.github.phylogeny.boundtotems.init.TileEntitiesMod;
import com.github.phylogeny.boundtotems.item.ItemBoundTotem;
import com.github.phylogeny.boundtotems.item.ItemRitualDagger;
import com.github.phylogeny.boundtotems.network.PacketNetwork;
import com.github.phylogeny.boundtotems.network.packet.PacketAddOrRemoveKnife;
import com.github.phylogeny.boundtotems.tileentity.TileEntityTotemShelfBinding;
import com.github.phylogeny.boundtotems.util.CapabilityUtil;
import com.github.phylogeny.boundtotems.util.EntityUtil;
import com.github.phylogeny.boundtotems.util.NBTUtil;
import java.util.HashSet;
import java.util.Hashtable;
import java.util.Iterator;
import java.util.Set;
import java.util.UUID;
import java.util.concurrent.atomic.AtomicInteger;
import java.util.function.BiFunction;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import net.minecraft.block.Block;
import net.minecraft.block.BlockState;
import net.minecraft.block.Blocks;
import net.minecraft.block.SoundType;
import net.minecraft.client.Minecraft;
import net.minecraft.entity.LivingEntity;
import net.minecraft.entity.player.PlayerEntity;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.CompoundNBT;
import net.minecraft.nbt.INBT;
import net.minecraft.network.NetworkManager;
import net.minecraft.network.play.server.SUpdateTileEntityPacket;
import net.minecraft.server.MinecraftServer;
import net.minecraft.state.IProperty;
import net.minecraft.state.properties.DoubleBlockHalf;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.tileentity.TileEntityType;
import net.minecraft.util.Direction;
import net.minecraft.util.Hand;
import net.minecraft.util.SoundCategory;
import net.minecraft.util.SoundEvent;
import net.minecraft.util.SoundEvents;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.BlockRayTraceResult;
import net.minecraft.util.math.Vec3d;
import net.minecraft.util.math.shapes.VoxelShape;
import net.minecraft.world.IWorld;
import net.minecraft.world.World;
import net.minecraft.world.dimension.DimensionType;
import net.minecraft.world.server.ServerWorld;
import net.minecraftforge.common.capabilities.Capability;
import net.minecraftforge.common.util.LazyOptional;
import net.minecraftforge.items.CapabilityItemHandler;
import net.minecraftforge.items.ItemStackHandler;

public class TileEntityTotemShelf
extends TileEntity {
    public static final int SIZE_INVENTORY = 6;
    private final LazyOptional<ItemStackHandler> inventory = LazyOptional.of(this::createInventory);
    protected ItemStack knife = ItemStack.field_190927_a;
    private Vec3d knifePos;
    private Vec3d knifeDirection;
    private UUID boundEntityID;

    public TileEntityTotemShelf() {
        super((TileEntityType)TileEntitiesMod.TOTEM_SHELF.get());
    }

    public TileEntityTotemShelf(TileEntityType<?> tileEntityType) {
        super(tileEntityType);
    }

    public ItemStack getKnife() {
        return this.knife;
    }

    @Nullable
    public UUID getBoundEntityID() {
        return this.boundEntityID;
    }

    @Nullable
    public Vec3d getKnifePos() {
        return this.knifePos == null ? null : this.knifePos.func_178787_e(this.knifeDirection.func_186678_a(-0.15));
    }

    @Nullable
    public Vec3d getKnifeDirection() {
        return this.knifeDirection;
    }

    public CompoundNBT func_189515_b(CompoundNBT nbt) {
        super.func_189515_b(nbt);
        NBTUtil.writeObjectToSubTag(nbt, "knife", nbtSub -> this.knife.func_77955_b(nbtSub));
        this.writeVec(nbt, this.knifePos, "pos");
        this.writeVec(nbt, this.knifeDirection, "dir");
        NBTUtil.writeNullableObject(this.boundEntityID, () -> nbt.func_218657_a("bound_entity_id", (INBT)NBTUtil.writeUniqueId(this.boundEntityID)));
        nbt.func_218657_a("items", (INBT)this.getInventory().serializeNBT());
        return nbt;
    }

    private void writeVec(CompoundNBT nbt, Vec3d vec, String key) {
        NBTUtil.writeNullableObject(vec, () -> NBTUtil.writeObjectToSubTag(nbt, key, nbtSub -> {
            nbtSub.func_74780_a("x", vec.field_72450_a);
            nbtSub.func_74780_a("y", vec.field_72448_b);
            nbtSub.func_74780_a("z", vec.field_72449_c);
        }));
    }

    public void func_145839_a(CompoundNBT nbt) {
        super.func_145839_a(nbt);
        this.knife = NBTUtil.readObjectFromSubTag(nbt, "knife", ItemStack::func_199557_a);
        this.knifePos = this.readVec(nbt, "pos");
        this.knifeDirection = this.readVec(nbt, "dir");
        this.boundEntityID = NBTUtil.readUniqueId(nbt.func_74775_l("bound_entity_id"));
        if (nbt.func_74764_b("items")) {
            this.getInventory().deserializeNBT((CompoundNBT)nbt.func_74781_a("items"));
        }
    }

    private Vec3d readVec(CompoundNBT nbt, String key) {
        return NBTUtil.readNullableObject(nbt, key, () -> NBTUtil.readObjectFromSubTag(nbt, key, nbtSub -> new Vec3d(nbtSub.func_74769_h("x"), nbtSub.func_74769_h("y"), nbtSub.func_74769_h("z"))));
    }

    private boolean isInterior(@Nullable Vec3d hit) {
        return hit != null && (double)((int)hit.field_72450_a) != hit.field_72450_a && (double)((int)hit.field_72448_b) != hit.field_72448_b && (double)((int)hit.field_72449_c) != hit.field_72449_c;
    }

    @Nonnull
    public <T> LazyOptional<T> getCapability(@Nonnull Capability<T> cap, @Nullable Direction side) {
        return cap == CapabilityItemHandler.ITEM_HANDLER_CAPABILITY ? this.inventory.cast() : super.getCapability(cap, side);
    }

    public ItemStackHandler getInventory() {
        return (ItemStackHandler)this.inventory.orElseThrow(BoundTotems.EMPTY_OPTIONAL_EXP);
    }

    private ItemStackHandler createInventory() {
        return new ItemStackHandler(6){

            protected void onContentsChanged(int slot) {
                Block block = TileEntityTotemShelf.this.func_195044_w().func_177230_c();
                if (TileEntityTotemShelf.this.field_145850_b != null) {
                    TileEntityTotemShelf.this.field_145850_b.func_175641_c(TileEntityTotemShelf.this.field_174879_c, block, 1, 0);
                    TileEntityTotemShelf.this.field_145850_b.func_195593_d(TileEntityTotemShelf.this.field_174879_c, block);
                    TileEntityTotemShelf.this.field_145850_b.func_184138_a(TileEntityTotemShelf.this.field_174879_c, TileEntityTotemShelf.this.func_195044_w(), TileEntityTotemShelf.this.func_195044_w(), 3);
                }
                TileEntityTotemShelf.this.func_70296_d();
            }

            public boolean isItemValid(int slot, @Nonnull ItemStack stack) {
                return stack.func_190926_b() || TileEntityTotemShelf.this.knifePos == null && TileEntityTotemShelf.this.boundEntityID != null && stack.func_77973_b() instanceof ItemBoundTotem && TileEntityTotemShelf.this.boundEntityID.equals(NBTUtil.getBoundEntityId(stack)) && (Boolean)TileEntityTotemShelf.this.field_145850_b.func_180495_p(TileEntityTotemShelf.this.field_174879_c).func_177229_b((IProperty)BlockTotemShelf.CHARRED) == false;
            }
        };
    }

    public boolean giveOrTakeKnife(BlockState state, World world, BlockPos pos, PlayerEntity player, Hand hand, ItemStack stack, BlockRayTraceResult result) {
        if (result != null) {
            if (state.func_177229_b(BlockTotemShelf.BINDING_STATE) == BlockTotemShelf.BindingState.NOT_BOUND && this.knife.func_190926_b() && stack.func_77973_b() instanceof ItemRitualDagger && NBTUtil.hasBoundEntity(stack) && this.isInterior(result.func_216347_e())) {
                if (!world.field_72995_K) {
                    this.addKnife(result.func_216347_e(), player.func_70040_Z(), stack);
                    player.func_184611_a(hand, ItemStack.field_190927_a);
                    world.func_184133_a(null, pos, SoundType.field_185848_a.func_185841_e(), SoundCategory.MASTER, 1.0f, 1.0f);
                    PacketNetwork.sendToAllAround(new PacketAddOrRemoveKnife(pos, this.knifePos, this.knife, this.knifeDirection), world, player.func_70040_Z());
                    this.setBindingState(state, BlockTotemShelf.BindingState.HEATING, 3);
                }
                return true;
            }
            if (state.func_177229_b(BlockTotemShelf.BINDING_STATE) == BlockTotemShelf.BindingState.BOUND && !this.knife.func_190926_b() && stack.func_190926_b() && TileEntityTotemShelf.getObservedKnifeShape(pos, result, this.getKnifePos()) != null) {
                if (!world.field_72995_K) {
                    player.func_184611_a(hand, this.knife);
                    world.func_184133_a(null, pos, SoundType.field_185848_a.func_185841_e(), SoundCategory.MASTER, 0.5f, 2.0f);
                    world.func_184133_a(null, pos, SoundEvents.field_187733_dX, SoundCategory.MASTER, 0.25f, 2.0f);
                    Vec3d vec = this.knifePos.func_178787_e(this.knifeDirection.func_186678_a(-0.05));
                    this.removeKnife();
                    PacketNetwork.sendToAllAround(new PacketAddOrRemoveKnife(pos, vec, this.knife), world, vec);
                }
                return true;
            }
        }
        return false;
    }

    public void addKnife(Vec3d knifePos, Vec3d knifeDirection, ItemStack knifeStack) {
        this.knifePos = knifePos;
        this.knifeDirection = knifeDirection;
        this.knife = knifeStack;
    }

    public void removeKnife() {
        this.knife = ItemStack.field_190927_a;
        this.knifeDirection = null;
        this.knifePos = null;
    }

    @Nullable
    public static VoxelShape getObservedKnifeShape(BlockPos pos, BlockRayTraceResult target, Vec3d knifePos) {
        return knifePos == null ? null : TileEntityTotemShelf.getHitShape(BlockTotemShelf.SHAPE_KNIFE.func_197751_a(knifePos.field_72450_a - (double)pos.func_177958_n(), knifePos.field_72448_b - (double)pos.func_177956_o(), knifePos.field_72449_c - (double)pos.func_177952_p()), pos, target);
    }

    @Nullable
    public static VoxelShape getHitShape(VoxelShape shape, BlockPos pos, BlockRayTraceResult target) {
        return shape.func_197752_a().func_72314_b(0.001, 0.001, 0.001).func_72318_a(target.func_216347_e().func_178786_a((double)pos.func_177958_n(), (double)pos.func_177956_o(), (double)pos.func_177952_p())) ? shape : null;
    }

    public void setBindingState(BlockState state, BlockTotemShelf.BindingState bindingState, int flags) {
        if (this.field_145850_b == null) {
            return;
        }
        CompoundNBT nbt = this.func_189517_E_();
        this.field_145850_b.func_175713_t(this.field_174879_c);
        this.field_145850_b.func_180501_a(this.field_174879_c, (BlockState)state.func_206870_a(BlockTotemShelf.BINDING_STATE, (Comparable)((Object)bindingState)), flags);
        TileEntity te = this.field_145850_b.func_175625_s(this.field_174879_c);
        if (te instanceof TileEntityTotemShelf) {
            te.func_145839_a(nbt);
            this.func_70296_d();
            this.field_145850_b.func_184138_a(this.field_174879_c, state, state, 3);
            if (!this.field_145850_b.field_72995_K && bindingState.hasNext()) {
                this.field_145850_b.func_205220_G_().func_205360_a(this.field_174879_c, (Object)state.func_177230_c(), 80);
            }
            if (bindingState == BlockTotemShelf.BindingState.COOLING) {
                ((TileEntityTotemShelf)te).bindKnifeAndShelf(state);
            }
        }
        if (this.field_145850_b.field_72995_K) {
            return;
        }
        if (bindingState == BlockTotemShelf.BindingState.HEATING) {
            this.field_145850_b.func_184133_a(null, this.field_174879_c, (SoundEvent)SoundsMod.BIND_SHELF.get(), SoundCategory.MASTER, 1.0f, 1.0f);
        }
    }

    private void bindKnifeAndShelf(BlockState state) {
        if (!(this.field_145850_b instanceof ServerWorld)) {
            return;
        }
        LivingEntity entity = NBTUtil.getBoundEntity(this.knife, (ServerWorld)this.field_145850_b);
        if (entity == null || entity.func_70092_e((double)this.field_174879_c.func_177958_n(), (double)this.field_174879_c.func_177956_o(), (double)this.field_174879_c.func_177952_p()) > Math.pow((Double)Config.SERVER.maxDistanceToShelf.get(), 2.0)) {
            ShelfDropRemovalModifier.setRemoval(true);
            this.field_145850_b.func_175656_a(this.field_174879_c, Blocks.field_150350_a.func_176223_P());
            ShelfDropRemovalModifier.setRemoval(false);
            BlockTotemShelf.addShelfBreakingEffects(this.field_145850_b, this.field_174879_c, state, false);
            return;
        }
        AtomicInteger count = new AtomicInteger();
        TileEntityTotemShelf.visitTotemShelves(entity, (world, shelf) -> {
            count.incrementAndGet();
            return new ShelfVisitationResult(false, true);
        });
        while (count.get() >= (Integer)Config.SERVER.maxBoundShelves.get()) {
            int burnIndex = this.field_145850_b.field_73012_v.nextInt(count.get()) + 1;
            AtomicInteger countBurn = new AtomicInteger();
            TileEntityTotemShelf.visitTotemShelves(entity, (world, shelf) -> {
                boolean forceRemoval;
                boolean bl = forceRemoval = countBurn.incrementAndGet() == burnIndex;
                if (forceRemoval) {
                    BlockState statePrimary = world.func_180495_p(shelf.field_174879_c);
                    PositionsTotemShelf positions = BlockTotemShelf.getTotemShelfPositions(statePrimary, (IWorld)world, shelf.field_174879_c);
                    world.func_175656_a(shelf.field_174879_c, (BlockState)statePrimary.func_206870_a((IProperty)BlockTotemShelf.CHARRED, (Comparable)Boolean.valueOf(true)));
                    if (positions != null) {
                        BlockPos posSecondary = positions.getPosOffset();
                        world.func_175656_a(posSecondary, (BlockState)world.func_180495_p(posSecondary).func_206870_a((IProperty)BlockTotemShelf.CHARRED, (Comparable)Boolean.valueOf(true)));
                    }
                    EntityUtil.spawnLightning(statePrimary, world, shelf.field_174879_c);
                    BlockTotemShelf.addShelfBreakingEffects((World)world, shelf.field_174879_c, statePrimary, true);
                    count.decrementAndGet();
                }
                return new ShelfVisitationResult(forceRemoval, !forceRemoval);
            });
        }
        NBTUtil.bindKnife(this.knife.func_196082_o());
        this.boundEntityID = entity.func_110124_au();
        DimensionType dimension = this.field_145850_b.func_201675_m().func_186058_p();
        Hashtable<DimensionType, Set<BlockPos>> positionTable = CapabilityUtil.getShelfPositions(entity).getPositions();
        Set<BlockPos> positions = positionTable.get(dimension);
        if (positions == null) {
            positions = new HashSet<BlockPos>();
        }
        positions.add(this.field_174879_c);
        positionTable.put(dimension, positions);
    }

    public static void visitTotemShelves(LivingEntity entity, BiFunction<ServerWorld, TileEntityTotemShelf, ShelfVisitationResult> action) {
        MinecraftServer server = entity.field_70170_p.func_73046_m();
        if (server == null) {
            return;
        }
        Hashtable<DimensionType, Set<BlockPos>> positionTable = CapabilityUtil.getShelfPositions(entity).getPositions();
        Set<DimensionType> dimensions = positionTable.keySet();
        Iterator<DimensionType> iteratorDim = dimensions.iterator();
        while (iteratorDim.hasNext()) {
            DimensionType dimension = iteratorDim.next();
            ServerWorld world = server.func_71218_a(dimension);
            if (world == null) continue;
            Set<BlockPos> positions = positionTable.get(dimension);
            if (positions == null) {
                iteratorDim.remove();
                continue;
            }
            Iterator<BlockPos> iteratorPos = positions.iterator();
            while (iteratorPos.hasNext()) {
                BlockPos pos = iteratorPos.next();
                TileEntity te = world.func_175625_s(pos);
                boolean foundShelf = false;
                if (te instanceof TileEntityTotemShelf) {
                    TileEntityTotemShelf totemShelf = (TileEntityTotemShelf)te;
                    if (entity.func_110124_au().equals(totemShelf.getBoundEntityID()) && !((Boolean)world.func_180495_p(pos).func_177229_b((IProperty)BlockTotemShelf.CHARRED)).booleanValue()) {
                        ShelfVisitationResult result = action.apply(world, totemShelf);
                        boolean bl = foundShelf = !result.forceRemoval();
                        if (!result.continueVisiting()) {
                            return;
                        }
                    }
                }
                if (foundShelf) continue;
                iteratorPos.remove();
            }
            if (!positions.isEmpty()) continue;
            iteratorDim.remove();
        }
    }

    public void onDataPacket(NetworkManager net, SUpdateTileEntityPacket pkt) {
        this.func_145839_a(pkt.func_148857_g());
        if (this.field_145850_b == null || !this.field_145850_b.field_72995_K) {
            return;
        }
        Minecraft.func_71410_x().execute(() -> {
            BlockState state = this.func_195044_w();
            if (state.func_177229_b(BlockTotemShelf.HALF) != DoubleBlockHalf.UPPER) {
                return;
            }
            BlockTotemShelf.BindingState bindingState = (BlockTotemShelf.BindingState)((Object)((Object)state.func_177229_b(BlockTotemShelf.BINDING_STATE)));
            if (bindingState == BlockTotemShelf.BindingState.HEATING != this instanceof TileEntityTotemShelfBinding) {
                this.setBindingState(state, bindingState, 3);
            }
        });
    }

    @Nullable
    public SUpdateTileEntityPacket func_189518_D_() {
        return new SUpdateTileEntityPacket(this.field_174879_c, 0, this.func_189517_E_());
    }

    public CompoundNBT func_189517_E_() {
        return this.func_189515_b(new CompoundNBT());
    }

    public static class ShelfVisitationResult {
        private boolean forceRemoval;
        private boolean continueVisiting;

        public ShelfVisitationResult(boolean forceRemoval, boolean continueVisiting) {
            this.forceRemoval = forceRemoval;
            this.continueVisiting = continueVisiting;
        }

        public boolean forceRemoval() {
            return this.forceRemoval;
        }

        public boolean continueVisiting() {
            return this.continueVisiting;
        }
    }
}

