/*
 * Decompiled with CFR 0.152.
 */
package com.github.phylogeny.boundtotems.util;

import com.github.phylogeny.boundtotems.block.BlockTotemShelf;
import java.util.Optional;
import java.util.function.Function;
import java.util.function.UnaryOperator;
import javax.annotation.Nullable;
import net.minecraft.block.BlockState;
import net.minecraft.entity.Entity;
import net.minecraft.entity.effect.LightningBoltEntity;
import net.minecraft.entity.player.PlayerEntity;
import net.minecraft.entity.player.ServerPlayerEntity;
import net.minecraft.state.IProperty;
import net.minecraft.util.Direction;
import net.minecraft.util.math.AxisAlignedBB;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.BlockRayTraceResult;
import net.minecraft.util.math.RayTraceContext;
import net.minecraft.util.math.Vec3d;
import net.minecraft.util.math.Vec3i;
import net.minecraft.world.World;
import net.minecraft.world.dimension.DimensionType;
import net.minecraft.world.server.ServerWorld;
import net.minecraftforge.common.util.ITeleporter;

public class EntityUtil {
    public static void spawnLightning(BlockState state, ServerWorld world, BlockPos pos) {
        Vec3i offset = ((Direction)state.func_177229_b((IProperty)BlockTotemShelf.FACING)).func_176730_m();
        LightningBoltEntity bolt = new LightningBoltEntity((World)world, (double)pos.func_177958_n() + 0.5 - (double)offset.func_177958_n() * 0.34375, (double)pos.func_177984_a().func_177956_o(), (double)pos.func_177952_p() + 0.5 - (double)offset.func_177952_p() * 0.34375, true);
        world.func_217468_a(bolt);
    }

    public static double getReach(PlayerEntity player) {
        return player.func_110148_a(PlayerEntity.REACH_DISTANCE).func_111126_e() + 1.0;
    }

    public static BlockRayTraceResult rayTraceBlocks(PlayerEntity player) {
        Vec3d startPos = player.func_174824_e(1.0f);
        return player.field_70170_p.func_217299_a(new RayTraceContext(startPos, startPos.func_178787_e(player.func_70040_Z().func_186678_a(EntityUtil.getReach(player))), RayTraceContext.BlockMode.COLLIDER, RayTraceContext.FluidMode.NONE, (Entity)player));
    }

    @Nullable
    public static <T extends Entity> T rayTraceEntities(World world, PlayerEntity player, Class<? extends T> classEntity) {
        return EntityUtil.rayTraceEntities(world, player, classEntity, box -> box);
    }

    @Nullable
    public static <T extends Entity> T rayTraceEntities(World world, PlayerEntity player, Class<? extends T> classEntity, UnaryOperator<AxisAlignedBB> boxOperator) {
        double reach = EntityUtil.getReach(player);
        Vec3d eyes = player.func_174824_e(1.0f);
        Vec3d look = eyes.func_178787_e(player.func_70040_Z().func_186678_a(reach));
        double distShortest = Double.POSITIVE_INFINITY;
        Entity entityHit = null;
        for (Entity entity : world.func_217357_a(classEntity, player.func_174813_aQ().func_186662_g(reach))) {
            double dist;
            Optional hit = ((AxisAlignedBB)boxOperator.apply(entity.func_174813_aQ())).func_216365_b(eyes, look);
            if (!hit.isPresent() || !((dist = eyes.func_72436_e((Vec3d)hit.get())) < distShortest)) continue;
            entityHit = entity;
            distShortest = dist;
        }
        return (T)entityHit;
    }

    public static void teleportEntity(Entity entity, DimensionType dimension, final Vec3d pos, final float pitch, float yaw) {
        if (!(entity.func_130014_f_() instanceof ServerWorld)) {
            return;
        }
        ServerWorld worldCurrent = (ServerWorld)entity.func_130014_f_();
        if (dimension != worldCurrent.field_73011_w.getDimension().func_186058_p()) {
            if (entity instanceof ServerPlayerEntity) {
                ((ServerPlayerEntity)entity).func_200619_a(worldCurrent.func_73046_m().func_71218_a(dimension), pos.field_72450_a, pos.field_72448_b, pos.field_72449_c, yaw, pitch);
            } else {
                entity.changeDimension(dimension, new ITeleporter(){

                    public Entity placeEntity(Entity entity, ServerWorld currentWorld, ServerWorld destWorld, float yaw, Function<Boolean, Entity> repositionEntity) {
                        Entity entityRepos = repositionEntity.apply(false);
                        entityRepos.func_70080_a(pos.field_72450_a, pos.field_72448_b, pos.field_72449_c, yaw, pitch);
                        EntityUtil.setPositionAndNullifyMotion(entityRepos, pos);
                        return entityRepos;
                    }
                });
                return;
            }
        }
        entity.field_70125_A = pitch;
        entity.field_70177_z = yaw;
        EntityUtil.setPositionAndNullifyMotion(entity, pos);
    }

    private static void setPositionAndNullifyMotion(Entity entity, Vec3d pos) {
        entity.func_70634_a(pos.field_72450_a, pos.field_72448_b, pos.field_72449_c);
        entity.func_213293_j(0.0, 0.0, 0.0);
        entity.field_70143_R = 0.0f;
    }

    public static class LocationTeleport {
        private final DimensionType dimension;
        private final Vec3d pos;
        private final float pitch;
        private final float yaw;

        public LocationTeleport(DimensionType dimension, Vec3d pos, float pitch, float yaw) {
            this.dimension = dimension;
            this.pos = pos;
            this.pitch = pitch;
            this.yaw = yaw;
        }

        public void teleportEntity(Entity entity) {
            EntityUtil.teleportEntity(entity, this.dimension, this.pos, this.pitch, this.yaw);
        }
    }
}

