/*
 * Decompiled with CFR 0.152.
 */
package com.github.phylogeny.boundtotems.util;

import com.github.phylogeny.boundtotems.util.EntityUtil;
import com.github.phylogeny.boundtotems.util.LangUtil;
import java.util.List;
import java.util.UUID;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.function.Supplier;
import javax.annotation.Nullable;
import net.minecraft.client.gui.screen.Screen;
import net.minecraft.entity.Entity;
import net.minecraft.entity.LivingEntity;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.CompoundNBT;
import net.minecraft.nbt.INBT;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.math.Vec3d;
import net.minecraft.util.text.ITextComponent;
import net.minecraft.world.dimension.DimensionType;
import net.minecraft.world.server.ServerWorld;

public class NBTUtil {
    public static final String BOUND_KNIFE = "bound_knife";
    public static final String BOUND_ENTITY = "bound_entity";
    public static final String BOUND_LOCATION = "bound_location";
    public static final String ENTITY_NAME = "name";
    public static final String DIMENSION = "dim";
    public static final String PITCH = "pitch";
    public static final String YAW = "yaw";
    public static final String X = "x";
    public static final String Y = "y";
    public static final String Z = "z";
    public static final String POSITION = "pos";
    public static final String DIRECTION = "dir";
    public static final String KNIFE = "knife";
    public static final String GLOWING = "glowing";

    public static boolean hasBoundEntity(ItemStack stack) {
        return NBTUtil.hasBoundEntity(stack.func_77978_p());
    }

    public static boolean hasBoundEntity(CompoundNBT nbt) {
        return nbt != null && nbt.func_74764_b(BOUND_ENTITY);
    }

    public static UUID readUniqueId(CompoundNBT nbt) {
        return net.minecraft.nbt.NBTUtil.func_186860_b((CompoundNBT)nbt);
    }

    public static CompoundNBT writeUniqueId(UUID id) {
        return net.minecraft.nbt.NBTUtil.func_186862_a((UUID)id);
    }

    @Nullable
    public static UUID getBoundEntityId(ItemStack stack) {
        CompoundNBT nbt = stack.func_179543_a(BOUND_ENTITY);
        return nbt == null ? null : NBTUtil.readUniqueId(nbt);
    }

    @Nullable
    public static LivingEntity getBoundEntity(ItemStack stack, ServerWorld world) {
        Entity entity;
        UUID id = NBTUtil.getBoundEntityId(stack);
        if (id != null && (entity = world.func_217461_a(id)) != null) {
            return (LivingEntity)entity;
        }
        return null;
    }

    @Nullable
    public static String getBoundEntityName(ItemStack stack) {
        CompoundNBT nbt = stack.func_179543_a(BOUND_ENTITY);
        return nbt == null ? null : nbt.func_74779_i(ENTITY_NAME);
    }

    public static ItemStack copyBoundEntity(ItemStack source, ItemStack target) {
        CompoundNBT nbt = source.func_179543_a(BOUND_ENTITY);
        if (nbt != null) {
            NBTUtil.setBoundEntity(target, NBTUtil.readUniqueId(nbt), nbt.func_74779_i(ENTITY_NAME));
        }
        return target;
    }

    public static boolean setBoundEntity(ItemStack stack, LivingEntity entity) {
        if (NBTUtil.hasBoundEntity(stack)) {
            return false;
        }
        NBTUtil.setBoundEntity(stack, entity.func_110124_au(), entity.func_145748_c_().getString());
        return true;
    }

    public static void setBoundEntity(ItemStack stack, UUID entityId, String entityDisplayName) {
        CompoundNBT nbt = NBTUtil.writeUniqueId(entityId);
        nbt.func_74778_a(ENTITY_NAME, entityDisplayName);
        stack.func_77983_a(BOUND_ENTITY, (INBT)nbt);
    }

    public static boolean matchesBoundEntity(ItemStack stack, LivingEntity entity) {
        UUID entityId = NBTUtil.getBoundEntityId(stack);
        return entityId != null && entity.func_110124_au().equals(entityId);
    }

    public static void addBoundEntityInformation(ItemStack stack, List<ITextComponent> tooltip) {
        String name = NBTUtil.getBoundEntityName(stack);
        if (name != null) {
            LangUtil.addTooltip(tooltip, "entity.name", name);
            if (Screen.hasShiftDown()) {
                LangUtil.addTooltip(tooltip, "entity.uuid", NBTUtil.getBoundEntityId(stack));
            }
        }
    }

    public static boolean hasBoundLocation(CompoundNBT nbt) {
        return nbt != null && nbt.func_74764_b(BOUND_LOCATION);
    }

    @Nullable
    public static EntityUtil.LocationTeleport getBoundLocation(ItemStack stack) {
        CompoundNBT nbt = stack.func_179543_a(BOUND_LOCATION);
        if (nbt == null) {
            return null;
        }
        DimensionType dimension = NBTUtil.getDimension(nbt.func_74779_i(DIMENSION));
        return dimension == null ? null : new EntityUtil.LocationTeleport(dimension, NBTUtil.readVec(nbt), nbt.func_74760_g(PITCH), nbt.func_74760_g(YAW));
    }

    public static void copyBoundLocation(ItemStack source, ItemStack target) {
        CompoundNBT nbt = source.func_179543_a(BOUND_LOCATION);
        if (nbt != null) {
            NBTUtil.setBoundLocation(target, NBTUtil.readVec(nbt), nbt.func_74779_i(DIMENSION), nbt.func_74760_g(PITCH), nbt.func_74760_g(YAW));
        }
    }

    public static void setBoundLocation(ItemStack stack, LivingEntity entity) {
        NBTUtil.setBoundLocation(stack, entity.func_174791_d(), NBTUtil.getDimensionName(entity.field_71093_bK), entity.field_70125_A, entity.field_70177_z);
    }

    public static void setBoundLocation(ItemStack stack, Vec3d pos, String dimension, float pitch, float yaw) {
        CompoundNBT nbt = NBTUtil.writeVec(pos);
        nbt.func_74778_a(DIMENSION, dimension);
        nbt.func_74776_a(PITCH, pitch);
        nbt.func_74776_a(YAW, yaw);
        stack.func_77983_a(BOUND_LOCATION, (INBT)nbt);
    }

    public static DimensionType getDimension(String name) {
        return DimensionType.func_193417_a((ResourceLocation)new ResourceLocation(name));
    }

    public static String getDimensionName(DimensionType dimension) {
        ResourceLocation name = DimensionType.func_212678_a((DimensionType)dimension);
        return name != null ? name.toString() : "[DIMENSION NOT FOUND]";
    }

    private static Vec3d readVec(CompoundNBT nbt) {
        return new Vec3d(nbt.func_74769_h("X"), nbt.func_74769_h("Y"), nbt.func_74769_h("Z"));
    }

    private static CompoundNBT writeVec(Vec3d vec) {
        CompoundNBT nbt = new CompoundNBT();
        nbt.func_74780_a("X", vec.field_72450_a);
        nbt.func_74780_a("Y", vec.field_72448_b);
        nbt.func_74780_a("Z", vec.field_72449_c);
        return nbt;
    }

    public static void addBoundLocationInformation(ItemStack stack, List<ITextComponent> tooltip, boolean fullDimensionName) {
        CompoundNBT nbt = stack.func_179543_a(BOUND_LOCATION);
        if (nbt == null) {
            return;
        }
        Vec3d pos = NBTUtil.readVec(nbt);
        String dimension = nbt.func_74779_i(DIMENSION);
        if (!fullDimensionName) {
            dimension = dimension.substring(dimension.indexOf(":") + 1);
        }
        LangUtil.addTooltip(tooltip, "location", dimension, Integer.toString((int)pos.field_72450_a), Integer.toString((int)pos.field_72448_b), Integer.toString((int)pos.field_72449_c));
    }

    public static boolean isKnifeBound(CompoundNBT nbt) {
        return nbt != null && nbt.func_74767_n(BOUND_KNIFE);
    }

    public static void bindKnife(CompoundNBT nbt) {
        nbt.func_74757_a(BOUND_KNIFE, true);
    }

    public static void writeObjectToSubTag(CompoundNBT nbt, String key, Consumer<CompoundNBT> nbtWriter) {
        CompoundNBT nbtSub = new CompoundNBT();
        nbtWriter.accept(nbtSub);
        nbt.func_218657_a(key, (INBT)nbtSub);
    }

    public static <T> T readObjectFromSubTag(CompoundNBT nbt, String key, Function<CompoundNBT, T> nbtReader) {
        return nbtReader.apply(nbt.func_74775_l(key));
    }

    public static void writeNullableObject(Object object, Runnable nbtWriter) {
        if (object != null) {
            nbtWriter.run();
        }
    }

    @Nullable
    public static <T> T readNullableObject(CompoundNBT nbt, String key, Supplier<T> nbtReader) {
        return nbt.func_74764_b(key) ? (T)nbtReader.get() : null;
    }
}

