/*
 * Decompiled with CFR 0.152.
 */
package com.github.phylogeny.boundtotems.util;

import java.util.function.Supplier;
import javax.annotation.Nullable;
import net.minecraft.network.PacketBuffer;
import net.minecraft.util.math.AxisAlignedBB;
import net.minecraft.util.math.Vec3d;

public class PacketBufferUtil {
    public static void writeNullableObject(PacketBuffer buf, Object object, Runnable bufWriter) {
        boolean nonNull = object != null;
        buf.writeBoolean(nonNull);
        if (nonNull) {
            bufWriter.run();
        }
    }

    @Nullable
    public static <T> T readNullableObject(PacketBuffer buf, Supplier<T> bufReader) {
        return buf.readBoolean() ? (T)bufReader.get() : null;
    }

    public static void writeVec(PacketBuffer buf, Vec3d vec) {
        buf.writeDouble(vec.field_72450_a);
        buf.writeDouble(vec.field_72448_b);
        buf.writeDouble(vec.field_72449_c);
    }

    public static Vec3d readVec(PacketBuffer buf) {
        return new Vec3d(buf.readDouble(), buf.readDouble(), buf.readDouble());
    }

    public static void writeAABB(PacketBuffer buf, AxisAlignedBB box) {
        buf.writeDouble(box.field_72340_a);
        buf.writeDouble(box.field_72338_b);
        buf.writeDouble(box.field_72339_c);
        buf.writeDouble(box.field_72336_d);
        buf.writeDouble(box.field_72337_e);
        buf.writeDouble(box.field_72334_f);
    }

    public static AxisAlignedBB readAABB(PacketBuffer buf) {
        return new AxisAlignedBB(buf.readDouble(), buf.readDouble(), buf.readDouble(), buf.readDouble(), buf.readDouble(), buf.readDouble());
    }
}

