/*
 * Decompiled with CFR 0.152.
 */
package com.github.phylogeny.boundtotems.util;

import com.google.common.collect.ImmutableList;
import com.google.common.collect.ImmutableMap;
import java.util.Collection;
import java.util.Collections;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.IntStream;
import net.minecraft.block.Block;
import net.minecraft.block.BlockState;
import net.minecraft.state.DirectionProperty;
import net.minecraft.state.IProperty;
import net.minecraft.util.Direction;
import net.minecraft.util.math.shapes.VoxelShape;
import net.minecraft.util.math.shapes.VoxelShapes;

public class VoxelShapeUtil {
    public static Collection<VoxelShape> makeCuboidShape(double x1, double y1, double z1, double x2, double y2, double z2) {
        return Collections.singletonList(Block.func_208617_a((double)x1, (double)y1, (double)z1, (double)x2, (double)y2, (double)z2));
    }

    public static ImmutableMap<BlockState, VoxelShape> getTransformedShapes(ImmutableMap<BlockState, VoxelShape> shapes, Function<VoxelShape, VoxelShape> transform) {
        ImmutableMap.Builder builder = new ImmutableMap.Builder();
        shapes.forEach((state, shape) -> builder.put(state, transform.apply((VoxelShape)shape)));
        return builder.build();
    }

    public static ImmutableMap<BlockState, VoxelShape> generateShapes(ImmutableList<BlockState> states, DirectionProperty facing, Function<BlockState, Collection<VoxelShape>> factory) {
        ImmutableMap.Builder builder = new ImmutableMap.Builder();
        states.forEach(state -> builder.put(state, (Object)VoxelShapeUtil.combineAll(VoxelShapeUtil.getRotatedVoxelShapes((Collection)factory.apply((BlockState)state)).stream().map(shapes -> shapes[((Direction)state.func_177229_b((IProperty)facing)).func_176736_b()]).collect(Collectors.toList()))));
        return builder.build();
    }

    public static VoxelShape combineAll(Collection<VoxelShape> shapes) {
        return VoxelShapes.func_216384_a((VoxelShape)VoxelShapes.func_197880_a(), (VoxelShape[])shapes.toArray(new VoxelShape[0]));
    }

    public static Collection<VoxelShape[]> getRotatedVoxelShapes(Collection<VoxelShape> shapes) {
        return shapes.stream().map(shape -> (VoxelShape[])IntStream.range(0, 4).mapToObj(index -> VoxelShapeUtil.rotateShape(shape, Direction.func_176731_b((int)((index + 3) % 4)))).toArray(VoxelShape[]::new)).collect(Collectors.toList());
    }

    public static VoxelShape rotateShape(VoxelShape shape, Direction facing) {
        double startX = shape.func_197762_b(Direction.Axis.X);
        double startZ = shape.func_197762_b(Direction.Axis.Z);
        double endX = shape.func_197758_c(Direction.Axis.X);
        double endZ = shape.func_197758_c(Direction.Axis.Z);
        switch (facing) {
            case WEST: {
                double tempStartX = startX;
                double tempStartZ = startZ;
                startX = 1.0 - endX;
                startZ = 1.0 - endZ;
                endX = 1.0 - tempStartX;
                endZ = 1.0 - tempStartZ;
                break;
            }
            case NORTH: {
                double tempStartX = startX;
                startX = startZ;
                startZ = 1.0 - endX;
                endX = endZ;
                endZ = 1.0 - tempStartX;
                break;
            }
            case SOUTH: {
                double tempStartX = startX;
                double tempStartZ = startZ;
                double tempEndX = endX;
                startX = 1.0 - endZ;
                startZ = tempStartX;
                endX = 1.0 - tempStartZ;
                endZ = tempEndX;
                break;
            }
        }
        return VoxelShapes.func_197873_a((double)startX, (double)shape.func_197762_b(Direction.Axis.Y), (double)startZ, (double)endX, (double)shape.func_197758_c(Direction.Axis.Y), (double)endZ);
    }
}

