/*
 * Decompiled with CFR 0.152.
 */
package tschipp.buildersbag;

import java.io.File;
import java.io.IOException;
import java.nio.file.Files;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import net.minecraftforge.fml.common.Mod;
import net.minecraftforge.fml.common.SidedProxy;
import net.minecraftforge.fml.common.event.FMLConstructionEvent;
import net.minecraftforge.fml.common.event.FMLFingerprintViolationEvent;
import net.minecraftforge.fml.common.event.FMLInitializationEvent;
import net.minecraftforge.fml.common.event.FMLPostInitializationEvent;
import net.minecraftforge.fml.common.event.FMLPreInitializationEvent;
import net.minecraftforge.fml.common.network.simpleimpl.SimpleNetworkWrapper;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import tschipp.buildersbag.CommonProxy;

@Mod.EventBusSubscriber
@Mod(modid="buildersbag", name="Builder's Bag", version="1.12.2", dependencies="required-after:forge@[13.20.1.2386,);after:chiselsandbits;after:littletiles@[1.5.0,);after:creativecore@[1.10.0,);after:linear@[1.3,);after:craftteaker;", acceptedMinecraftVersions="[1.12.2,1.13)", guiFactory="tschipp.buildersbag.client.gui.GuiFactoryBuildersBag", certificateFingerprint="fd21553434f4905f2f73ea7838147ac4ea07bd88")
public class BuildersBag {
    @SidedProxy(clientSide="tschipp.buildersbag.ClientProxy", serverSide="tschipp.buildersbag.CommonProxy")
    public static CommonProxy proxy;
    @Mod.Instance(value="buildersbag")
    public static BuildersBag instance;
    public static final String MODID = "buildersbag";
    public static final String VERSION = "1.12.2";
    public static final String NAME = "Builder's Bag";
    public static final String ACCEPTED_VERSIONS = "[1.12.2,1.13)";
    public static final String DEPENDENCIES = "required-after:forge@[13.20.1.2386,);after:chiselsandbits;after:littletiles@[1.5.0,);after:creativecore@[1.10.0,);after:linear@[1.3,);after:craftteaker;";
    public static final Logger LOGGER;
    public static final String CERTIFICATE = "fd21553434f4905f2f73ea7838147ac4ea07bd88";
    public static SimpleNetworkWrapper network;
    public static boolean FINGERPRINT_VIOLATED;
    private static final File configFile;
    public static final File seenModsFile;
    private static final List<String> seenMods;
    public static boolean isNewlyGenerated;

    public BuildersBag() {
        if (!configFile.exists()) {
            isNewlyGenerated = true;
        }
    }

    @Mod.EventHandler
    public void construction(FMLConstructionEvent event) {
        try {
            if (seenModsFile.exists()) {
                seenMods.addAll(Files.readAllLines(seenModsFile.toPath()));
            } else {
                seenModsFile.createNewFile();
            }
        }
        catch (IOException e) {
            e.printStackTrace();
        }
    }

    @Mod.EventHandler
    public void preInit(FMLPreInitializationEvent event) {
        proxy.preInit(event);
    }

    @Mod.EventHandler
    public void init(FMLInitializationEvent event) {
        proxy.init(event);
    }

    @Mod.EventHandler
    public void postInit(FMLPostInitializationEvent event) {
        proxy.postInit(event);
    }

    @Mod.EventHandler
    public void onFingerprintViolation(FMLFingerprintViolationEvent event) {
        LOGGER.error("WARNING! Invalid fingerprint detected! The file " + event.getSource().getName() + " may have been tampered with! If you didn't download the file from https://minecraft.curseforge.com/projects/buildersbag or through any kind of mod launcher, immediately delete the file and re-download it from https://minecraft.curseforge.com/projects/buildersbag");
        FINGERPRINT_VIOLATED = true;
    }

    public static Set<String> getSeenMods() {
        return new HashSet<String>(seenMods);
    }

    static {
        LOGGER = LogManager.getFormatterLogger((String)MODID.toUpperCase());
        FINGERPRINT_VIOLATED = false;
        configFile = new File("config/buildersbag.cfg");
        seenModsFile = new File("seen_buildersbag_addons.txt");
        seenMods = new ArrayList<String>();
        isNewlyGenerated = false;
    }
}

