/*
 * Decompiled with CFR 0.152.
 */
package tschipp.buildersbag.client.gui;

import java.io.IOException;
import java.util.ArrayList;
import net.minecraft.block.Block;
import net.minecraft.client.gui.inventory.GuiContainer;
import net.minecraft.client.renderer.GlStateManager;
import net.minecraft.client.renderer.RenderHelper;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.init.Blocks;
import net.minecraft.init.SoundEvents;
import net.minecraft.inventory.Container;
import net.minecraft.inventory.Slot;
import net.minecraft.item.ItemStack;
import net.minecraft.util.EnumHand;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.text.TextFormatting;
import net.minecraft.util.text.translation.I18n;
import net.minecraftforge.fml.common.network.simpleimpl.IMessage;
import net.minecraftforge.items.ItemStackHandler;
import tschipp.buildersbag.BuildersBag;
import tschipp.buildersbag.api.IBagModule;
import tschipp.buildersbag.common.helper.BagHelper;
import tschipp.buildersbag.common.helper.CapHelper;
import tschipp.buildersbag.common.helper.InventoryHelper;
import tschipp.buildersbag.common.inventory.ContainerBag;
import tschipp.buildersbag.network.server.CompactBagServer;
import tschipp.buildersbag.network.server.RequestBagUpdateServer;
import tschipp.buildersbag.network.server.SyncModuleStateServer;

public class GuiBag
extends GuiContainer {
    private ContainerBag container;
    private EntityPlayer player;
    private ItemStack bag;
    private EnumHand hand;
    private boolean isBauble = false;
    private int slot = 0;
    private int mainWidth;
    private int mainHeight;
    private int leftOffset;
    private int compactButtonX;
    private int compactButtonY;
    private static int TEX_HEIGHT = 60;
    private static int TEX_WIDTH = 54;
    private boolean isNew = true;

    public GuiBag(ContainerBag container, EntityPlayer player) {
        super((Container)container);
        this.container = container;
        this.player = player;
        this.bag = container.bag;
        this.hand = container.hand;
        this.isBauble = container.isBauble;
        this.slot = container.slot;
        this.mainWidth = InventoryHelper.getTotalWidth();
        this.mainHeight = InventoryHelper.getTotalHeight(container.invSize);
        this.leftOffset = Math.max(InventoryHelper.getBagExtraLeft(CapHelper.getBagCap(this.bag)), InventoryHelper.getBagExtraRight(CapHelper.getBagCap(this.bag)));
        this.field_146999_f = this.mainWidth + this.leftOffset * 2;
        this.field_147000_g = this.mainHeight;
        this.compactButtonX = this.leftOffset + 72;
        this.compactButtonY = this.mainHeight;
    }

    public void func_73863_a(int mouseX, int mouseY, float partialTicks) {
        super.func_73863_a(mouseX, mouseY, partialTicks);
        this.func_191948_b(mouseX, mouseY);
        if (this.isNew) {
            this.isNew = false;
            BuildersBag.network.sendToServer((IMessage)new RequestBagUpdateServer(this.slot, this.isBauble));
        }
        int mX = mouseX - this.field_147003_i;
        int mY = mouseY - this.field_147009_r;
        if (mX >= this.compactButtonX && mX <= this.compactButtonX + 32 && mY >= this.compactButtonY && mY <= this.compactButtonY + 32) {
            ArrayList<String> tooltip = new ArrayList<String>();
            tooltip.add(TextFormatting.BOLD + I18n.func_74838_a((String)"buildersbag.sort"));
            tooltip.add(TextFormatting.GOLD + I18n.func_74838_a((String)"buildersbag.module.left") + TextFormatting.RESET + I18n.func_74838_a((String)"buildersbag.module.to") + I18n.func_74838_a((String)"buildersbag.sort"));
            this.func_146283_a(tooltip, mouseX, mouseY);
        }
        this.container.modules.forEach((module, triple) -> {
            int x = (Integer)triple.getLeft();
            int y = (Integer)triple.getMiddle();
            boolean right = (Boolean)triple.getRight();
            if (mX >= x && mX <= x + 32 && mY >= y && mY <= y + 32) {
                ArrayList<String> tooltip = new ArrayList<String>();
                tooltip.add(TextFormatting.BOLD + I18n.func_74838_a((String)("buildersbag.module." + module.getName())));
                if (!module.doesntUseOwnInventory()) {
                    tooltip.add(TextFormatting.GOLD + I18n.func_74838_a((String)"buildersbag.module.shiftleft") + TextFormatting.RESET + I18n.func_74838_a((String)"buildersbag.module.toggle"));
                }
                tooltip.add(TextFormatting.GOLD + I18n.func_74838_a((String)"buildersbag.module.left") + TextFormatting.RESET + I18n.func_74838_a((String)"buildersbag.module.to") + (module.isEnabled() ? TextFormatting.RED + I18n.func_74838_a((String)"buildersbag.module.disable") : TextFormatting.GREEN + I18n.func_74838_a((String)"buildersbag.module.enable")));
                this.func_146283_a(tooltip, mouseX, mouseY);
            }
        });
    }

    protected void func_146976_a(float partialTicks, int mouseX, int mouseY) {
        this.func_146276_q_();
        GlStateManager.func_179094_E();
        this.field_146297_k.func_110434_K().func_110577_a(new ResourceLocation("buildersbag:textures/gui/bag.png"));
        this.drawBackground(0 + this.leftOffset, 0, this.mainWidth, this.mainHeight);
        this.drawBackground(72 + this.leftOffset, -32, 32, 32, 16);
        this.drawHoverableBackground(this.compactButtonX, this.compactButtonY, 32, 32, mouseX, mouseY, 28, 32);
        RenderHelper.func_74520_c();
        this.field_146296_j.func_180450_b(new ItemStack((Block)Blocks.field_150486_ae), this.compactButtonX + 8 + this.field_147003_i, this.compactButtonY + 8 + this.field_147009_r);
        RenderHelper.func_74518_a();
        this.field_146297_k.func_110434_K().func_110577_a(new ResourceLocation("buildersbag:textures/gui/bag.png"));
        this.container.modules.forEach((module, triple) -> {
            int x = (Integer)triple.getLeft();
            int y = (Integer)triple.getMiddle();
            boolean right = (Boolean)triple.getRight();
            this.drawHoverableBackgroundToggleable(x, y, 32, 32, mouseX, mouseY, module.isEnabled());
            RenderHelper.func_74520_c();
            this.field_146296_j.func_180450_b(module.getDisplayItem(), x + 8 + this.field_147003_i, y + 8 + this.field_147009_r);
            RenderHelper.func_74518_a();
            this.field_146297_k.func_110434_K().func_110577_a(new ResourceLocation("buildersbag:textures/gui/bag.png"));
            ItemStackHandler handler = module.getInventory();
            if (handler != null && module.isExpanded()) {
                int slotWidth = InventoryHelper.getSlotWidth(handler.getSlots());
                this.drawBackground(x + (right ? 32 : -32), y, slotWidth, 32);
            }
        });
        this.drawSlotBackgrounds();
        this.field_146289_q.func_78276_b(this.container.name, this.field_147003_i + 7 + this.leftOffset, this.field_147009_r + 6, 0x404040);
        this.field_146289_q.func_78276_b(this.player.field_71071_by.func_145748_c_().func_150260_c(), this.field_147003_i + 7 + this.leftOffset, this.field_147009_r + 6 + InventoryHelper.getBagRows(this.container.invSize) * 18 + 14, 0x404040);
        GlStateManager.func_179121_F();
    }

    protected void func_73864_a(int mouseX, int mouseY, int mouseButton) throws IOException {
        super.func_73864_a(mouseX, mouseY, mouseButton);
        int mousePosX = mouseX - this.field_147003_i;
        int mousePosY = mouseY - this.field_147009_r;
        if (mousePosX >= this.compactButtonX && mousePosX <= this.compactButtonX + 32 && mousePosY >= this.compactButtonY && mousePosY <= this.compactButtonY + 32) {
            this.player.func_184185_a(SoundEvents.field_187909_gi, 1.0f, 1.0f);
            BagHelper.compactStacks(CapHelper.getBagCap(this.bag), this.player);
            BuildersBag.network.sendToServer((IMessage)new CompactBagServer(this.container.slot, this.container.isBauble));
            this.container.update();
        }
        this.container.modules.forEach((module, triple) -> {
            int x = (Integer)triple.getLeft();
            int y = (Integer)triple.getMiddle();
            boolean right = (Boolean)triple.getRight();
            if (mousePosX >= x && mousePosX <= x + 32 && mousePosY >= y && mousePosY <= y + 32 && mouseButton == 0) {
                if (module.doesntUseOwnInventory()) {
                    module.toggle();
                } else if (this.func_146272_n()) {
                    module.setExpanded(!module.isExpanded());
                } else {
                    module.toggle();
                }
                this.container.update();
                this.sendUpdate((IBagModule)module);
                this.player.func_184185_a(SoundEvents.field_187909_gi, 1.0f, 1.0f);
            }
        });
    }

    public void func_146281_b() {
        super.func_146281_b();
    }

    private void drawSlotBackgrounds() {
        for (Slot slot : this.container.field_75151_b) {
            if (!slot.func_111238_b()) continue;
            GuiBag.func_146110_a((int)(this.field_147003_i + slot.field_75223_e - 1), (int)(this.field_147009_r + slot.field_75221_f - 1), (float)36.0f, (float)0.0f, (int)18, (int)18, (float)TEX_WIDTH, (float)TEX_HEIGHT);
        }
    }

    private void drawHoverableBackground(int x, int y, int width, int height, int mouseX, int mouseY, int texVNormal, int texVHovered) {
        if ((mouseX -= this.field_147003_i) >= x && mouseX <= x + width && (mouseY -= this.field_147009_r) >= y && mouseY <= y + height) {
            this.drawBackground(x, y, width, height, texVHovered);
        } else {
            this.drawBackground(x, y, width, height, texVNormal);
        }
    }

    private void drawHoverableBackgroundToggleable(int x, int y, int width, int height, int mouseX, int mouseY, boolean enabled) {
        if ((mouseX -= this.field_147003_i) >= x && mouseX <= x + width && (mouseY -= this.field_147009_r) >= y && mouseY <= y + height) {
            if (enabled) {
                this.drawBackground(x, y, width, height, 20);
            } else {
                this.drawBackground(x, y, width, height, 24);
            }
        } else if (enabled) {
            this.drawBackground(x, y, width, height, 8);
        } else {
            this.drawBackground(x, y, width, height, 12);
        }
    }

    private void drawBackground(int x, int y, int width, int height) {
        this.drawBackground(x, y, width, height, 0);
    }

    private void drawBackground(int x, int y, int width, int height, int offset) {
        int i;
        int drawWidth = (width - 8) / 4;
        int drawHeight = (height - 8) / 4;
        int oldX = x += this.getGuiLeft();
        int oldY = y += this.getGuiTop();
        GuiBag.func_146110_a((int)x, (int)y, (float)0.0f, (float)(0 + offset), (int)4, (int)4, (float)TEX_WIDTH, (float)TEX_HEIGHT);
        x += 4;
        for (i = 0; i < drawWidth; ++i) {
            GuiBag.func_146110_a((int)x, (int)y, (float)4.0f, (float)(0 + offset), (int)4, (int)4, (float)TEX_WIDTH, (float)TEX_HEIGHT);
            x += 4;
        }
        GuiBag.func_146110_a((int)x, (int)y, (float)16.0f, (float)(0 + offset), (int)4, (int)4, (float)TEX_WIDTH, (float)TEX_HEIGHT);
        x = oldX;
        y += 4;
        for (i = 0; i < drawHeight; ++i) {
            GuiBag.func_146110_a((int)x, (int)y, (float)8.0f, (float)(0 + offset), (int)4, (int)4, (float)TEX_WIDTH, (float)TEX_HEIGHT);
            x += 4;
            for (int j = 0; j < drawWidth; ++j) {
                GuiBag.func_146110_a((int)x, (int)y, (float)12.0f, (float)(0 + offset), (int)4, (int)4, (float)TEX_WIDTH, (float)TEX_HEIGHT);
                x += 4;
            }
            GuiBag.func_146110_a((int)x, (int)y, (float)20.0f, (float)(0 + offset), (int)4, (int)4, (float)TEX_WIDTH, (float)TEX_HEIGHT);
            y += 4;
            x = oldX;
        }
        GuiBag.func_146110_a((int)x, (int)y, (float)32.0f, (float)(0 + offset), (int)4, (int)4, (float)TEX_WIDTH, (float)TEX_HEIGHT);
        x += 4;
        for (i = 0; i < drawWidth; ++i) {
            GuiBag.func_146110_a((int)x, (int)y, (float)28.0f, (float)(0 + offset), (int)4, (int)4, (float)TEX_WIDTH, (float)TEX_HEIGHT);
            x += 4;
        }
        GuiBag.func_146110_a((int)x, (int)y, (float)24.0f, (float)(0 + offset), (int)4, (int)4, (float)TEX_WIDTH, (float)TEX_HEIGHT);
    }

    private void sendUpdate(IBagModule module) {
        BuildersBag.network.sendToServer((IMessage)new SyncModuleStateServer(module.getName(), module));
    }
}

