/*
 * Decompiled with CFR 0.152.
 */
package tschipp.buildersbag.client.rendering;

import com.google.common.collect.Lists;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import net.minecraft.client.Minecraft;
import net.minecraft.client.entity.EntityPlayerSP;
import net.minecraft.client.renderer.GlStateManager;
import net.minecraft.client.renderer.RenderItem;
import net.minecraft.client.renderer.block.model.IBakedModel;
import net.minecraft.client.renderer.block.model.ItemCameraTransforms;
import net.minecraft.client.renderer.block.model.ModelResourceLocation;
import net.minecraft.client.renderer.tileentity.TileEntityItemStackRenderer;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.item.ItemBlock;
import net.minecraft.item.ItemStack;
import net.minecraft.world.World;
import net.minecraftforge.client.ForgeHooksClient;
import net.minecraftforge.fml.common.Mod;
import net.minecraftforge.fml.common.eventhandler.SubscribeEvent;
import net.minecraftforge.fml.common.gameevent.TickEvent;
import net.minecraftforge.fml.relauncher.ReflectionHelper;
import net.minecraftforge.fml.relauncher.Side;
import tschipp.buildersbag.api.IBagCap;
import tschipp.buildersbag.common.config.BuildersBagConfig;
import tschipp.buildersbag.common.helper.BagHelper;
import tschipp.buildersbag.common.helper.CapHelper;
import tschipp.buildersbag.common.item.BuildersBagItem;

@Mod.EventBusSubscriber(modid="buildersbag", value={Side.CLIENT})
public class BagItemStackRenderer
extends TileEntityItemStackRenderer {
    public static ItemCameraTransforms.TransformType transform;
    private Map<Integer, List<ItemStack>> possibleItems = new HashMap<Integer, List<ItemStack>>();
    private Map<Integer, String> renderStack = new HashMap<Integer, String>();
    public static Set<String> working;
    public static int listIndex;
    private static int renderTimer;
    private static int renderTotal;
    private static Method renderModelF;

    public void func_192838_a(ItemStack stack, float partialTicks) {
        EntityPlayerSP player = Minecraft.func_71410_x().field_71439_g;
        Minecraft mc = Minecraft.func_71410_x();
        World world = player.field_70170_p;
        RenderItem render = mc.func_175599_af();
        IBakedModel gears = render.func_175037_a().func_178083_a().func_174953_a(new ModelResourceLocation("buildersbag:gears", "inventory"));
        String serialized = stack.serializeNBT().toString();
        int hash = stack.hashCode();
        if (this.renderStack.get(hash) == null) {
            this.renderStack.put(hash, serialized);
            this.regenerateAvailablityList(stack);
        }
        if (this.renderStack.get(hash) != null && !this.renderStack.get(hash).equals(serialized)) {
            this.renderStack.put(hash, serialized);
            this.regenerateAvailablityList(stack);
        }
        IBagCap bag = CapHelper.getBagCap(stack);
        boolean random = bag.hasModuleAndEnabled("buildersbag:random");
        List<ItemStack> possibleItems = this.possibleItems.get(hash);
        ItemStack selected = random ? (possibleItems.size() > 0 ? possibleItems.get(listIndex % possibleItems.size()) : ItemStack.field_190927_a) : bag.getSelectedInventory().getStackInSlot(0);
        IBakedModel selectedModel = render.func_184393_a(selected, (World)mc.field_71441_e, (EntityLivingBase)mc.field_71439_g);
        IBakedModel renderModel = render.func_184393_a(stack, (World)mc.field_71441_e, (EntityLivingBase)mc.field_71439_g);
        boolean renderAsBlock = transform == ItemCameraTransforms.TransformType.FIRST_PERSON_LEFT_HAND || transform == ItemCameraTransforms.TransformType.FIRST_PERSON_RIGHT_HAND || transform == ItemCameraTransforms.TransformType.THIRD_PERSON_LEFT_HAND || transform == ItemCameraTransforms.TransformType.THIRD_PERSON_RIGHT_HAND;
        GlStateManager.func_179094_E();
        GlStateManager.func_179091_B();
        if (!selected.func_190926_b()) {
            if (transform == ItemCameraTransforms.TransformType.THIRD_PERSON_LEFT_HAND || transform == ItemCameraTransforms.TransformType.THIRD_PERSON_RIGHT_HAND) {
                GlStateManager.func_179094_E();
                GlStateManager.func_179109_b((float)0.5f, (float)0.17f, (float)0.5f);
                GlStateManager.func_179139_a((double)1.85, (double)1.85, (double)1.85);
                ForgeHooksClient.handleCameraTransforms((IBakedModel)selectedModel, (ItemCameraTransforms.TransformType)transform, (boolean)false);
                GlStateManager.func_179109_b((float)-0.5f, (float)-0.5f, (float)-0.5f);
                this.renderModel(render, selectedModel, -1, selected);
                GlStateManager.func_179121_F();
            } else if (transform == ItemCameraTransforms.TransformType.FIRST_PERSON_LEFT_HAND || transform == ItemCameraTransforms.TransformType.FIRST_PERSON_RIGHT_HAND) {
                GlStateManager.func_179094_E();
                if (transform == ItemCameraTransforms.TransformType.FIRST_PERSON_RIGHT_HAND) {
                    GlStateManager.func_179137_b((double)0.0, (double)0.22, (double)0.4);
                    GlStateManager.func_179139_a((double)1.8, (double)1.8, (double)1.8);
                    GlStateManager.func_179114_b((float)90.0f, (float)0.0f, (float)1.0f, (float)0.0f);
                    GlStateManager.func_179114_b((float)25.0f, (float)1.0f, (float)0.0f, (float)0.0f);
                } else {
                    GlStateManager.func_179137_b((double)1.0, (double)0.22, (double)0.4);
                    GlStateManager.func_179139_a((double)1.8, (double)1.8, (double)1.8);
                    GlStateManager.func_179114_b((float)3.0f, (float)0.0f, (float)1.0f, (float)0.0f);
                    GlStateManager.func_179114_b((float)25.0f, (float)0.0f, (float)0.0f, (float)1.0f);
                    if (!render.func_175050_a(selected)) {
                        GlStateManager.func_179137_b((double)-0.3, (double)0.15, (double)0.0);
                        GlStateManager.func_179114_b((float)10.0f, (float)1.0f, (float)0.0f, (float)0.0f);
                        GlStateManager.func_179114_b((float)-50.0f, (float)0.0f, (float)0.0f, (float)1.0f);
                        GlStateManager.func_179114_b((float)80.0f, (float)0.0f, (float)1.0f, (float)0.0f);
                    }
                }
                ForgeHooksClient.handleCameraTransforms((IBakedModel)selectedModel, (ItemCameraTransforms.TransformType)transform, (boolean)false);
                GlStateManager.func_179109_b((float)-0.5f, (float)-0.5f, (float)-0.5f);
                this.renderModel(render, selectedModel, -1, selected);
                GlStateManager.func_179121_F();
            } else {
                GlStateManager.func_179094_E();
                this.renderModel(render, renderModel, -1, stack);
                GlStateManager.func_179121_F();
                if (transform == ItemCameraTransforms.TransformType.GUI) {
                    GlStateManager.func_179094_E();
                    GlStateManager.func_179145_e();
                    GlStateManager.func_179109_b((float)0.0f, (float)0.0f, (float)3.0f);
                    GlStateManager.func_179137_b((double)0.1, (double)0.1, (double)0.0);
                    GlStateManager.func_179139_a((double)0.5, (double)0.5, (double)0.5);
                    GlStateManager.func_179137_b((double)1.3, (double)1.3, (double)0.0);
                    ForgeHooksClient.handleCameraTransforms((IBakedModel)selectedModel, (ItemCameraTransforms.TransformType)transform, (boolean)false);
                    GlStateManager.func_179109_b((float)-0.5f, (float)-0.5f, (float)-0.5f);
                    this.renderModel(render, selectedModel, -1, selected);
                    GlStateManager.func_179121_F();
                    if (BuildersBagConfig.Settings.drawWorkingState) {
                        if (working.contains(bag.getUUID())) {
                            GlStateManager.func_179094_E();
                            GlStateManager.func_179139_a((double)0.7, (double)0.7, (double)0.7);
                            GlStateManager.func_179137_b((double)0.0, (double)0.0, (double)2.0);
                            this.renderModel(render, gears, -1, stack);
                            GlStateManager.func_179121_F();
                        }
                    }
                }
            }
        } else {
            this.renderModel(render, renderModel, -1, stack);
        }
        GlStateManager.func_179121_F();
    }

    private void renderModel(RenderItem render, IBakedModel model, int color, ItemStack stack) {
        try {
            if (model.func_188618_c() && !(stack.func_77973_b() instanceof BuildersBagItem)) {
                GlStateManager.func_179094_E();
                GlStateManager.func_179131_c((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
                GlStateManager.func_179091_B();
                TileEntityItemStackRenderer.field_147719_a.func_179022_a(stack);
                GlStateManager.func_179121_F();
            } else {
                renderModelF.invoke((Object)render, model, color, stack);
            }
        }
        catch (IllegalAccessException | IllegalArgumentException | InvocationTargetException exception) {
            // empty catch block
        }
    }

    private void regenerateAvailablityList(ItemStack bagStack) {
        IBagCap cap;
        ArrayList list;
        if (!(bagStack.func_77973_b() instanceof BuildersBagItem)) {
            return;
        }
        if (renderTotal >= 10000) {
            this.possibleItems.clear();
            this.renderStack.clear();
            renderTotal = 0;
        }
        if ((list = this.possibleItems.get(bagStack.hashCode())) == null) {
            list = Lists.newArrayList();
        }
        if (!(cap = CapHelper.getBagCap(bagStack)).hasModuleAndEnabled("buildersbag:random")) {
            return;
        }
        list.clear();
        for (ItemStack s : BagHelper.getAllAvailableStacks(cap, (EntityPlayer)Minecraft.func_71410_x().field_71439_g)) {
            if (!(s.func_77973_b() instanceof ItemBlock)) continue;
            list.add(s);
        }
        this.possibleItems.put(bagStack.hashCode(), list);
    }

    @SubscribeEvent
    public static void onClientTick(TickEvent.ClientTickEvent event) {
        ++renderTotal;
        if (++renderTimer >= 60) {
            renderTimer = 0;
            if (++listIndex >= 50000) {
                listIndex = 0;
            }
        }
    }

    static {
        working = new HashSet<String>();
        renderTimer = 0;
        renderTotal = 0;
        renderModelF = ReflectionHelper.findMethod(RenderItem.class, (String)"renderModel", (String)"func_191967_a", (Class[])new Class[]{IBakedModel.class, Integer.TYPE, ItemStack.class});
        renderModelF.setAccessible(true);
    }
}

