/*
 * Decompiled with CFR 0.152.
 */
package tschipp.buildersbag.common;

import java.io.FileWriter;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.function.Supplier;
import javax.annotation.Nullable;
import net.minecraft.item.Item;
import net.minecraft.util.ResourceLocation;
import net.minecraftforge.common.capabilities.Capability;
import net.minecraftforge.common.capabilities.CapabilityManager;
import net.minecraftforge.fml.common.Loader;
import net.minecraftforge.fml.common.Mod;
import tschipp.buildersbag.BuildersBag;
import tschipp.buildersbag.api.IBagCap;
import tschipp.buildersbag.api.IBagModule;
import tschipp.buildersbag.common.caps.BagCap;
import tschipp.buildersbag.common.caps.BagCapStorage;
import tschipp.buildersbag.common.config.BuildersBagConfig;
import tschipp.buildersbag.common.item.BuildersBagItem;
import tschipp.buildersbag.common.modules.ChiselModule;
import tschipp.buildersbag.common.modules.ChiselsBitsModule;
import tschipp.buildersbag.common.modules.CraftingModule;
import tschipp.buildersbag.common.modules.LittleTilesModule;
import tschipp.buildersbag.common.modules.RandomnessModule;
import tschipp.buildersbag.common.modules.SupplierModule;

@Mod.EventBusSubscriber(modid="buildersbag")
public class BuildersBagRegistry {
    private static final Map<ResourceLocation, Supplier<IBagModule>> modules = new HashMap<ResourceLocation, Supplier<IBagModule>>();
    private static final Map<ResourceLocation, Set<Integer>> defaultModuleStages = new HashMap<ResourceLocation, Set<Integer>>();
    public static Item tier1;
    public static Item tier2;
    public static Item tier3;
    public static Item tier4;
    public static Item tier5;
    public static List<Item> items;

    public static void registerItems() {
        tier1 = new BuildersBagItem(1, "one");
        tier2 = new BuildersBagItem(2, "two");
        tier3 = new BuildersBagItem(3, "three");
        tier4 = new BuildersBagItem(4, "four");
        tier5 = new BuildersBagItem(5, "five");
        items.add(tier1);
        items.add(tier2);
        items.add(tier3);
        items.add(tier4);
        items.add(tier5);
    }

    public static void registerModules() {
        BuildersBagRegistry.addModule(new ResourceLocation("buildersbag", "random"), RandomnessModule::new, 1, 2, 3, 4, 5);
        BuildersBagRegistry.addModule(new ResourceLocation("buildersbag", "crafting"), CraftingModule::new, 4, 5);
        BuildersBagRegistry.addModule(new ResourceLocation("buildersbag", "supplier"), SupplierModule::new, 5);
        if (Loader.isModLoaded((String)"chisel")) {
            BuildersBagRegistry.addModule(new ResourceLocation("buildersbag", "chisel"), ChiselModule::new, 2, 3, 4, 5);
        }
        if (Loader.isModLoaded((String)"littletiles")) {
            BuildersBagRegistry.addModule(new ResourceLocation("buildersbag", "littletiles"), LittleTilesModule::new, 3, 4, 5);
        }
        if (Loader.isModLoaded((String)"chiselsandbits")) {
            BuildersBagRegistry.addModule(new ResourceLocation("buildersbag", "chiselsandbits"), ChiselsBitsModule::new, 3, 4, 5);
        }
    }

    @Nullable
    public static IBagModule getModule(ResourceLocation loc) {
        Supplier<IBagModule> sup = modules.get(loc);
        if (sup != null) {
            return sup.get();
        }
        return null;
    }

    public static void addModule(ResourceLocation name, Supplier<IBagModule> supplier, int ... bagStages) {
        modules.put(name, supplier);
        HashSet<Integer> list = new HashSet<Integer>();
        for (int i : bagStages) {
            if (i < 1 || i > 5) continue;
            list.add(i);
        }
        defaultModuleStages.put(name, list);
    }

    public static void sayHi(String modid) {
        Set<String> seenMods = BuildersBag.getSeenMods();
        if (!seenMods.contains(modid)) {
            BuildersBagConfig.addToCurrentConfig(modid);
            try {
                FileWriter writer = new FileWriter(BuildersBag.seenModsFile, true);
                writer.append(modid + "\n");
                writer.close();
            }
            catch (IOException e) {
                e.printStackTrace();
            }
        }
    }

    public static String[] getDefaultModulesForTier(int tier) {
        ArrayList<String> modules = new ArrayList<String>();
        block0: for (Map.Entry<ResourceLocation, Set<Integer>> entry : defaultModuleStages.entrySet()) {
            for (int t : entry.getValue()) {
                if (t != tier) continue;
                modules.add(entry.getKey().toString());
                continue block0;
            }
        }
        return modules.toArray(new String[modules.size()]);
    }

    public static List<Integer> getTiersForModule(ResourceLocation module) {
        return new ArrayList<Integer>((Collection)defaultModuleStages.get(module));
    }

    public static List<ResourceLocation> getModulesFromMod(String modid) {
        ArrayList<ResourceLocation> moduleL = new ArrayList<ResourceLocation>();
        for (ResourceLocation module : modules.keySet()) {
            if (!module.func_110624_b().equals(modid)) continue;
            moduleL.add(module);
        }
        return moduleL;
    }

    public static void registerCapabilities() {
        CapabilityManager.INSTANCE.register(IBagCap.class, (Capability.IStorage)new BagCapStorage(), BagCap::new);
    }

    static {
        items = new ArrayList<Item>();
    }
}

