/*
 * Decompiled with CFR 0.152.
 */
package tschipp.buildersbag.common.cache;

import java.util.ArrayDeque;
import java.util.concurrent.locks.Condition;
import java.util.concurrent.locks.Lock;
import java.util.concurrent.locks.ReentrantLock;

public class CacheUpdaterThread
extends Thread {
    public Lock lock = new ReentrantLock();
    public Condition needsProgress = this.lock.newCondition();
    private ArrayDeque<Runnable> queue = new ArrayDeque();

    public CacheUpdaterThread(String name) {
        super(name);
    }

    public void enqueueRunnable(Runnable run) {
        this.queue.push(run);
        this.lock.lock();
        this.needsProgress.signalAll();
        this.lock.unlock();
    }

    @Override
    public void run() {
        while (true) {
            Runnable run;
            try {
                this.lock.lock();
                this.needsProgress.await();
                this.lock.unlock();
            }
            catch (InterruptedException interruptedException) {
                // empty catch block
            }
            if (this.queue.isEmpty() || (run = this.queue.poll()) == null) continue;
            run.run();
        }
    }
}

