/*
 * Decompiled with CFR 0.152.
 */
package tschipp.buildersbag.common.cache;

import com.google.common.collect.Maps;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.item.ItemStack;
import net.minecraftforge.fml.common.network.simpleimpl.IMessage;
import tschipp.buildersbag.BuildersBag;
import tschipp.buildersbag.api.IBagCap;
import tschipp.buildersbag.common.cache.BagCache;
import tschipp.buildersbag.common.data.ItemContainer;
import tschipp.buildersbag.common.data.Tuple;
import tschipp.buildersbag.common.helper.CapHelper;
import tschipp.buildersbag.common.helper.InventoryHelper;
import tschipp.buildersbag.network.server.RequestCacheUpdateServer;

public class CachedBag {
    private EntityPlayer player;
    private ItemStack bag;
    private IBagCap bagCap;
    private Map<ItemContainer, CachedAmount> cachedStacks = new HashMap<ItemContainer, CachedAmount>();
    private boolean isSimulating = false;
    private Map<ItemContainer, CachedAmount> cacheCopy = new HashMap<ItemContainer, CachedAmount>();
    private Set<ItemContainer> pendingRequests = new HashSet<ItemContainer>();
    private Map<ItemContainer, CachedAmount> dirtyClientCache = new HashMap<ItemContainer, CachedAmount>();

    public CachedBag(EntityPlayer player, ItemStack bag) {
        this.bagCap = CapHelper.getBagCap(bag);
        this.bag = bag;
        this.player = player;
    }

    public void clearCache() {
        this.cachedStacks.clear();
        this.cacheCopy.clear();
        this.pendingRequests.clear();
        this.dirtyClientCache.clear();
    }

    public void updatePlayer(EntityPlayer player) {
        this.player = player;
    }

    public boolean hasItemCached(ItemStack forStack) {
        return this.cachedStacks.containsKey(ItemContainer.forStack(forStack));
    }

    public int getCachedAmount(ItemStack forStack, int preferredAmount) {
        ItemContainer ic = ItemContainer.forStack(forStack);
        CachedAmount amount = this.cachedStacks.get(ic);
        if (amount == null) {
            if (this.dirtyClientCache.containsKey(ic)) {
                return this.dirtyClientCache.get(ic).value;
            }
            this.requestCacheUpdate(forStack, preferredAmount);
            CachedAmount c = new CachedAmount();
            c.value = 100;
            this.dirtyClientCache.put(ic, c);
            return 100;
        }
        if (amount.value < preferredAmount) {
            this.requestCacheUpdate(forStack, preferredAmount);
        }
        return amount.value;
    }

    public void modifyCachedAmount(ItemStack forStack, int delta) {
        CachedAmount amount = this.cachedStacks.get(ItemContainer.forStack(forStack));
        if (amount == null) {
            return;
        }
        CachedAmount cachedAmount = amount;
        cachedAmount.value = cachedAmount.value + delta;
        if (amount.value <= 0) {
            amount.value = 0;
        }
    }

    public void requestCacheUpdate(ItemStack forStack, int preferredAmount) {
        if (!this.pendingRequests.contains(ItemContainer.forStack(forStack))) {
            this.pendingRequests.add(ItemContainer.forStack(forStack));
            if (this.player.field_70170_p.field_72995_K) {
                Tuple<Boolean, Integer> slot = InventoryHelper.getSlotForStackWithBaubles(this.player, this.bag);
                BuildersBag.network.sendToServer((IMessage)new RequestCacheUpdateServer(slot.getSecond(), slot.getFirst(), forStack, preferredAmount));
                return;
            }
            BagCache.updateCachedBagStack(this.bag, this.player, forStack, preferredAmount);
        }
    }

    public void updateCachedAmount(ItemStack stack, int amount) {
        ItemContainer cont = ItemContainer.forStack(stack);
        this.pendingRequests.remove(cont);
        this.dirtyClientCache.remove(cont);
        CachedAmount cache = this.cachedStacks.get(cont);
        if (cache == null) {
            cache = new CachedAmount();
        }
        cache.value = amount;
        cache.timestamp = System.currentTimeMillis();
        this.cachedStacks.put(cont, cache);
    }

    public boolean isSimulating() {
        return this.isSimulating;
    }

    public void startSimulation() {
        if (this.isSimulating) {
            BuildersBag.LOGGER.warn("Already simulating!");
        }
        this.isSimulating = true;
        this.cacheCopy = Maps.newHashMap();
        for (Map.Entry<ItemContainer, CachedAmount> s : this.cachedStacks.entrySet()) {
            this.cacheCopy.put(s.getKey(), s.getValue().copy());
        }
    }

    public void stopSimulating() {
        if (!this.isSimulating) {
            BuildersBag.LOGGER.warn("Not simulating!");
        }
        this.isSimulating = false;
        this.cachedStacks = this.cacheCopy;
    }

    public void removeOldCaches() {
        long time = System.currentTimeMillis();
        for (Map.Entry<ItemContainer, CachedAmount> entry : this.cachedStacks.entrySet()) {
            if (time - entry.getValue().timestamp < 300000L) continue;
            this.cachedStacks.remove(entry.getKey());
        }
    }

    private static class CachedAmount {
        private int value;
        private long timestamp;

        private CachedAmount() {
        }

        public CachedAmount copy() {
            CachedAmount c = new CachedAmount();
            c.value = this.value;
            c.timestamp = this.timestamp;
            return c;
        }
    }
}

