/*
 * Decompiled with CFR 0.152.
 */
package tschipp.buildersbag.common.caps;

import com.google.common.collect.Lists;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import net.minecraft.util.ResourceLocation;
import net.minecraftforge.items.ItemStackHandler;
import tschipp.buildersbag.api.IBagCap;
import tschipp.buildersbag.api.IBagModule;
import tschipp.buildersbag.common.BuildersBagRegistry;
import tschipp.buildersbag.common.config.BuildersBagConfig;
import tschipp.buildersbag.common.inventory.BagItemStackHandler;
import tschipp.buildersbag.common.inventory.SelectedBlockHandler;

public class BagCap
implements IBagCap {
    private IBagModule[] modules = new IBagModule[0];
    private ItemStackHandler inv = new ItemStackHandler(0);
    private ItemStackHandler selected = new SelectedBlockHandler(1);
    private String uuid;

    public BagCap() {
        this(1);
        this.uuid = "";
    }

    public BagCap(int tier) {
        switch (tier) {
            case 1: {
                this.initModules(BuildersBagConfig.Settings.tier1Modules);
                this.inv = new BagItemStackHandler(BuildersBagConfig.Settings.tier1Slots);
                break;
            }
            case 2: {
                this.initModules(BuildersBagConfig.Settings.tier2Modules);
                this.inv = new BagItemStackHandler(BuildersBagConfig.Settings.tier2Slots);
                break;
            }
            case 3: {
                this.initModules(BuildersBagConfig.Settings.tier3Modules);
                this.inv = new BagItemStackHandler(BuildersBagConfig.Settings.tier3Slots);
                break;
            }
            case 4: {
                this.initModules(BuildersBagConfig.Settings.tier4Modules);
                this.inv = new BagItemStackHandler(BuildersBagConfig.Settings.tier4Slots);
                break;
            }
            case 5: {
                this.initModules(BuildersBagConfig.Settings.tier5Modules);
                this.inv = new BagItemStackHandler(BuildersBagConfig.Settings.tier5Slots);
            }
        }
        List list = Collections.EMPTY_LIST;
    }

    private void initModules(String[] modules) {
        ArrayList moduleList = new ArrayList();
        Lists.newArrayList((Object[])modules).stream().distinct().sorted().forEach(s -> {
            IBagModule module = BuildersBagRegistry.getModule(new ResourceLocation(s));
            if (module != null) {
                moduleList.add(module);
            }
        });
        this.modules = moduleList.toArray(new IBagModule[moduleList.size()]);
    }

    @Override
    public ItemStackHandler getBlockInventory() {
        return this.inv;
    }

    @Override
    public IBagModule[] getModules() {
        return this.modules;
    }

    @Override
    public void setBlockInventory(ItemStackHandler handler) {
        this.inv = handler;
    }

    @Override
    public void setModules(IBagModule[] modules) {
        this.modules = modules;
    }

    @Override
    public void setSelectedInventory(ItemStackHandler handler) {
        this.selected = handler;
    }

    @Override
    public ItemStackHandler getSelectedInventory() {
        return this.selected;
    }

    @Override
    public boolean hasModuleAndEnabled(String name) {
        for (IBagModule m : this.modules) {
            if (!m.getName().equals(name) || !m.isEnabled()) continue;
            return true;
        }
        return false;
    }

    @Override
    public void transferDataFromCap(IBagCap from) {
        int i;
        this.selected = from.getSelectedInventory();
        ItemStackHandler oldInv = from.getBlockInventory();
        for (i = 0; i < oldInv.getSlots(); ++i) {
            if (i >= this.inv.getSlots()) continue;
            this.inv.setStackInSlot(i, oldInv.getStackInSlot(i));
        }
        block1: for (i = 0; i < this.modules.length; ++i) {
            IBagModule module = this.modules[i];
            for (IBagModule fromModule : from.getModules()) {
                if (!module.getName().equals(fromModule.getName())) continue;
                this.modules[i] = fromModule;
                continue block1;
            }
        }
    }

    @Override
    public void reInit(int tier) {
        this.modules = null;
        switch (tier) {
            case 1: {
                this.initModules(BuildersBagConfig.Settings.tier1Modules);
                this.inv = new BagItemStackHandler(BuildersBagConfig.Settings.tier1Slots);
                break;
            }
            case 2: {
                this.initModules(BuildersBagConfig.Settings.tier2Modules);
                this.inv = new BagItemStackHandler(BuildersBagConfig.Settings.tier2Slots);
                break;
            }
            case 3: {
                this.initModules(BuildersBagConfig.Settings.tier3Modules);
                this.inv = new BagItemStackHandler(BuildersBagConfig.Settings.tier3Slots);
                break;
            }
            case 4: {
                this.initModules(BuildersBagConfig.Settings.tier4Modules);
                this.inv = new BagItemStackHandler(BuildersBagConfig.Settings.tier4Slots);
                break;
            }
            case 5: {
                this.initModules(BuildersBagConfig.Settings.tier5Modules);
                this.inv = new BagItemStackHandler(BuildersBagConfig.Settings.tier5Slots);
            }
        }
    }

    @Override
    public IBagCap copy() {
        int i;
        BagCap newcap = new BagCap();
        newcap.inv = new ItemStackHandler(this.inv.getSlots());
        newcap.modules = new IBagModule[this.modules.length];
        newcap.selected.setStackInSlot(0, this.selected.getStackInSlot(0).func_77946_l());
        for (i = 0; i < this.inv.getSlots(); ++i) {
            newcap.inv.setStackInSlot(i, this.inv.getStackInSlot(i).func_77946_l());
        }
        for (i = 0; i < this.modules.length; ++i) {
            IBagModule newModule = BuildersBagRegistry.getModule(new ResourceLocation(this.modules[i].getName()));
            newModule.deserializeNBT(this.modules[i].serializeNBT());
            newcap.modules[i] = newModule;
        }
        return newcap;
    }

    @Override
    public String getUUID() {
        return this.uuid;
    }

    @Override
    public void setUUID(String uuid) {
        this.uuid = uuid;
    }
}

