/*
 * Decompiled with CFR 0.152.
 */
package tschipp.buildersbag.common.caps;

import java.util.ArrayList;
import java.util.UUID;
import net.minecraft.nbt.NBTBase;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.nbt.NBTTagList;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.ResourceLocation;
import net.minecraftforge.common.capabilities.Capability;
import tschipp.buildersbag.api.IBagCap;
import tschipp.buildersbag.api.IBagModule;
import tschipp.buildersbag.common.BuildersBagRegistry;
import tschipp.buildersbag.common.inventory.BagItemStackHandler;
import tschipp.buildersbag.common.inventory.SelectedBlockHandler;

public class BagCapStorage
implements Capability.IStorage<IBagCap> {
    public NBTBase writeNBT(Capability<IBagCap> capability, IBagCap instance, EnumFacing side) {
        NBTTagCompound tag = new NBTTagCompound();
        NBTTagCompound inventory = instance.getBlockInventory().serializeNBT();
        NBTTagCompound selected = instance.getSelectedInventory().serializeNBT();
        NBTTagList modules = new NBTTagList();
        for (IBagModule module : instance.getModules()) {
            modules.func_74742_a(module.serializeNBT());
        }
        tag.func_74782_a("inventory", (NBTBase)inventory);
        tag.func_74782_a("modules", (NBTBase)modules);
        tag.func_74782_a("selected", (NBTBase)selected);
        tag.func_74778_a("uuid", instance.getUUID());
        return tag;
    }

    public void readNBT(Capability<IBagCap> capability, IBagCap instance, EnumFacing side, NBTBase nbt) {
        NBTTagCompound tag = (NBTTagCompound)nbt;
        NBTTagCompound inventory = tag.func_74775_l("inventory");
        NBTTagCompound selected = tag.func_74775_l("selected");
        NBTTagList modules = tag.func_150295_c("modules", 10);
        String uuid = tag.func_74779_i("uuid");
        if (uuid.isEmpty()) {
            uuid = UUID.randomUUID().toString();
        }
        BagItemStackHandler handler = new BagItemStackHandler(0);
        handler.deserializeNBT(inventory);
        instance.setBlockInventory(handler);
        SelectedBlockHandler selectedHandler = new SelectedBlockHandler(1);
        selectedHandler.deserializeNBT(selected);
        instance.setSelectedInventory(selectedHandler);
        instance.setUUID(uuid);
        ArrayList<IBagModule> parsedModules = new ArrayList<IBagModule>();
        for (int i = 0; i < modules.func_74745_c(); ++i) {
            NBTTagCompound module = modules.func_150305_b(i);
            IBagModule mod = BuildersBagRegistry.getModule(new ResourceLocation(module.func_74779_i("name")));
            if (mod == null) continue;
            mod.deserializeNBT((NBTBase)module);
            parsedModules.add(mod);
        }
        instance.setModules(parsedModules.toArray(new IBagModule[parsedModules.size()]));
    }
}

