/*
 * Decompiled with CFR 0.152.
 */
package tschipp.buildersbag.common.config;

import com.google.common.collect.Lists;
import java.io.File;
import java.lang.invoke.MethodHandle;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import net.minecraft.util.ResourceLocation;
import net.minecraftforge.common.config.Config;
import net.minecraftforge.common.config.ConfigManager;
import net.minecraftforge.common.config.Configuration;
import net.minecraftforge.common.config.Property;
import net.minecraftforge.fml.client.event.ConfigChangedEvent;
import net.minecraftforge.fml.common.Mod;
import net.minecraftforge.fml.common.eventhandler.SubscribeEvent;
import tschipp.buildersbag.BuildersBag;
import tschipp.buildersbag.common.BuildersBagRegistry;
import tschipp.buildersbag.common.config.Configs;
import tschipp.buildersbag.common.helper.ReflectionUtil;

@Config(modid="buildersbag")
public class BuildersBagConfig {
    @Config.LangKey(value="buildersbag")
    @Config.Comment(value={"General Mod Settings"})
    public static Configs.Settings Settings = new Configs.Settings();

    public static void addToCurrentConfig(String modid) {
        if (BuildersBag.isNewlyGenerated) {
            return;
        }
        Configuration config = EventHandler.getConfiguration();
        List<ResourceLocation> modules = BuildersBagRegistry.getModulesFromMod(modid);
        for (ResourceLocation module : modules) {
            List<Integer> tiers = BuildersBagRegistry.getTiersForModule(module);
            for (int tier : tiers) {
                Property prop = config.get("general.settings", "tier" + tier + "Modules", BuildersBagRegistry.getDefaultModulesForTier(tier));
                if (prop == null) continue;
                Object[] current = prop.getStringList();
                ArrayList currentList = Lists.newArrayList((Object[])current);
                currentList.add(module.toString());
                prop.set(currentList.toArray(new String[currentList.size()]));
            }
        }
        config.save();
        ConfigManager.load((String)"buildersbag", (Config.Type)Config.Type.INSTANCE);
    }

    public static void setDefaultsOnFirstLoad() {
        if (BuildersBag.isNewlyGenerated) {
            Configuration config = EventHandler.getConfiguration();
            for (int i = 1; i <= 5; ++i) {
                Property prop = config.get("general.settings", "tier" + i + "Modules", BuildersBagRegistry.getDefaultModulesForTier(i));
                prop.setDefaultValues(BuildersBagRegistry.getDefaultModulesForTier(i));
                prop.set(BuildersBagRegistry.getDefaultModulesForTier(i));
            }
            config.save();
            ConfigManager.load((String)"buildersbag", (Config.Type)Config.Type.INSTANCE);
        }
    }

    @Mod.EventBusSubscriber
    public static class EventHandler {
        private static final MethodHandle CONFIGS_GETTER = ReflectionUtil.findFieldGetter(ConfigManager.class, "CONFIGS");
        private static Configuration configuration;

        public static Configuration getConfiguration() {
            if (configuration == null) {
                try {
                    String fileName = "buildersbag.cfg";
                    Map configsMap = CONFIGS_GETTER.invokeExact();
                    Optional<Map.Entry> entryOptional = configsMap.entrySet().stream().filter(entry -> "buildersbag.cfg".equals(new File((String)entry.getKey()).getName())).findFirst();
                    entryOptional.ifPresent(stringConfigurationEntry -> {
                        configuration = (Configuration)stringConfigurationEntry.getValue();
                    });
                }
                catch (Throwable throwable) {
                    throwable.printStackTrace();
                }
            }
            return configuration;
        }

        @SubscribeEvent
        public static void onConfigChanged(ConfigChangedEvent.OnConfigChangedEvent event) {
            if (event.getModID().equals("buildersbag")) {
                ConfigManager.load((String)"buildersbag", (Config.Type)Config.Type.INSTANCE);
            }
        }
    }
}

