/*
 * Decompiled with CFR 0.152.
 */
package tschipp.buildersbag.common.crafting;

import java.lang.reflect.Method;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.stream.Collectors;
import net.minecraft.item.Item;
import net.minecraft.item.ItemBlock;
import net.minecraft.item.ItemStack;
import net.minecraft.item.crafting.IRecipe;
import net.minecraft.item.crafting.Ingredient;
import net.minecraft.nbt.JsonToNBT;
import net.minecraft.nbt.NBTException;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.util.NonNullList;
import net.minecraftforge.fml.common.Loader;
import net.minecraftforge.fml.common.registry.ForgeRegistries;
import net.minecraftforge.fml.relauncher.ReflectionHelper;
import net.minecraftforge.oredict.OreDictionary;
import net.minecraftforge.oredict.OreIngredient;
import tschipp.buildersbag.common.crafting.RecipeContainer;
import tschipp.buildersbag.common.crafting.RecipeTreeNew;

public class CraftingHandler {
    private static final Map<String, List<RecipeContainer>> recipes = new HashMap<String, List<RecipeContainer>>();
    private static final RecipeTreeNew recipeTree = new RecipeTreeNew();
    private static final Map<String, Set<String>> alternativeIngredients = new HashMap<String, Set<String>>();

    public static void generateRecipes() {
        for (IRecipe recipe : ForgeRegistries.RECIPES) {
            ItemStack output = recipe.func_77571_b();
            if (!output.func_190926_b()) {
                NonNullList ingredients = recipe.func_192400_c();
                String itemString = CraftingHandler.getItemString(output);
                List<RecipeContainer> genRecipes = recipes.get(itemString);
                if (genRecipes != null) {
                    genRecipes.add(new RecipeContainer((NonNullList<Ingredient>)ingredients, output, CraftingHandler.getTierIfStaged(recipe)));
                } else {
                    genRecipes = new ArrayList<RecipeContainer>();
                    genRecipes.add(new RecipeContainer((NonNullList<Ingredient>)ingredients, output, CraftingHandler.getTierIfStaged(recipe)));
                    recipes.put(itemString, genRecipes);
                }
            }
            recipeTree.add(recipe);
        }
    }

    public static void addIngredientIfAlternative(Ingredient ing) {
        if (ing.func_193365_a().length > 1 && !(ing instanceof OreIngredient)) {
            String ingString = CraftingHandler.getIngredientString(ing);
            for (String s : CraftingHandler.getIngredientStrings(ing)) {
                Set<String> set = alternativeIngredients.get(s);
                if (set == null) {
                    set = new HashSet<String>();
                }
                set.add(ingString);
                alternativeIngredients.put(s, set);
            }
        }
    }

    public static List<RecipeContainer> getRecipes(ItemStack stack) {
        String name = CraftingHandler.getItemString(stack);
        if (recipes.get(name) == null) {
            return Collections.EMPTY_LIST;
        }
        return recipes.get(name);
    }

    public static NonNullList<ItemStack> getPossibleItems(NonNullList<ItemStack> available, boolean removeAvailable) {
        RecipeTreeNew subtree = recipeTree.getSubtree(available);
        return subtree.getPossibleStacks(removeAvailable);
    }

    public static NonNullList<ItemStack> getPossibleBlocks(NonNullList<ItemStack> available, boolean removeAvailable) {
        NonNullList<ItemStack> items = CraftingHandler.getPossibleItems(available, removeAvailable);
        NonNullList blocks = NonNullList.func_191196_a();
        blocks.addAll((Collection)items.stream().filter(stack -> stack.func_77973_b() instanceof ItemBlock).collect(Collectors.toList()));
        return blocks;
    }

    public static RecipeTreeNew getRecipeTree(ItemStack requested, NonNullList<ItemStack> available) {
        RecipeTreeNew subtree = recipeTree.getSubtree(available);
        return subtree.getRecipeTree(requested);
    }

    public static RecipeTreeNew getSubTree(NonNullList<ItemStack> available) {
        RecipeTreeNew subtree = recipeTree.getSubtree(available);
        return subtree;
    }

    public static String getTierIfStaged(IRecipe recipe) {
        if (Loader.isModLoaded((String)"recipestages")) {
            try {
                Class<?> clazz = Class.forName("com.blamejared.recipestages.recipes.RecipeStage");
                if (clazz.isInstance(recipe)) {
                    Method getTier = ReflectionHelper.findMethod(clazz, (String)"getTier", null, (Class[])new Class[0]);
                    String tier = (String)getTier.invoke((Object)recipe, new Object[0]);
                    return tier;
                }
            }
            catch (Exception e) {
                return "";
            }
        }
        return "";
    }

    public static String getItemString(ItemStack output) {
        String outputString = output.func_77973_b().getRegistryName().toString() + "@" + output.func_77960_j() + "$" + (output.func_77942_o() ? output.func_77978_p().toString() : "") + ";";
        return outputString;
    }

    public static String[] getStackIngredientStrings(ItemStack output, boolean self) {
        if (output.func_190926_b()) {
            return new String[0];
        }
        int[] ores = OreDictionary.getOreIDs((ItemStack)output);
        ArrayList<String> oredict = new ArrayList<String>();
        for (int i = 0; i < ores.length; ++i) {
            OreIngredient ore = new OreIngredient(OreDictionary.getOreName((int)ores[i]));
            oredict.add(CraftingHandler.getIngredientString((Ingredient)ore));
        }
        String itemString = CraftingHandler.getItemString(output);
        if (self) {
            oredict.add(itemString);
        }
        if (alternativeIngredients.containsKey(itemString)) {
            oredict.addAll((Collection)alternativeIngredients.get(itemString));
        }
        return oredict.toArray(new String[oredict.size()]);
    }

    public static String getStackIngredientString(ItemStack output, boolean self) {
        String[] str = CraftingHandler.getStackIngredientStrings(output, self);
        StringBuilder sb = new StringBuilder();
        for (String s : str) {
            sb.append(s);
        }
        return sb.toString();
    }

    public static String[] getIngredientStrings(Ingredient ing) {
        String[] strings = new String[ing.func_193365_a().length];
        for (int i = 0; i < ing.func_193365_a().length; ++i) {
            strings[i] = CraftingHandler.getItemString(ing.func_193365_a()[i]);
        }
        return strings;
    }

    public static String getIngredientString(Ingredient ing) {
        StringBuilder sb = new StringBuilder();
        for (ItemStack stack : ing.func_193365_a()) {
            sb.append(CraftingHandler.getItemString(stack));
        }
        return sb.toString();
    }

    public static ItemStack getItemFromString(String str) {
        str = str.substring(0, str.length() - 1);
        int at = str.indexOf(64);
        int hash = str.indexOf(35);
        int dollar = str.indexOf(36);
        String name = str.substring(0, at);
        int meta = Integer.parseInt(str.substring(at + 1, dollar));
        String nbt = dollar == str.length() - 1 ? "" : str.substring(dollar + 1, str.length());
        ItemStack stack = new ItemStack(Item.func_111206_d((String)name), 1, meta);
        if (!nbt.isEmpty()) {
            try {
                NBTTagCompound tag = JsonToNBT.func_180713_a((String)nbt);
                stack.func_77982_d(tag);
            }
            catch (NBTException e) {
                return ItemStack.field_190927_a;
            }
        }
        return stack;
    }
}

