/*
 * Decompiled with CFR 0.152.
 */
package tschipp.buildersbag.common.crafting;

import com.google.common.collect.Maps;
import java.util.ArrayDeque;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.LinkedList;
import java.util.Map;
import java.util.Queue;
import java.util.Stack;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.item.ItemStack;
import tschipp.buildersbag.api.IBagCap;
import tschipp.buildersbag.common.crafting.CraftingHandler;
import tschipp.buildersbag.common.crafting.RecipeContainer;
import tschipp.buildersbag.common.crafting.RecipeContainerProvided;
import tschipp.buildersbag.common.crafting.RecipeTreeNew;
import tschipp.buildersbag.common.data.ItemContainer;
import tschipp.buildersbag.common.data.Tuple;
import tschipp.buildersbag.common.helper.InventoryHelper;

public class RecipeRequirementList {
    private RecipeTreeNew tree;
    private Map<ItemContainer, Double> totalRequirements = new HashMap<ItemContainer, Double>();
    private Map<ItemContainer, Requirement> itemRequirements = new HashMap<ItemContainer, Requirement>();
    private Map<ItemContainer, RecipeContainer> recipes = new HashMap<ItemContainer, RecipeContainer>();
    private ItemStack createdItem;
    private int creationCount;
    private RecipeContainer creationRecipe;
    boolean invalid = false;

    public RecipeRequirementList(RecipeTreeNew tree, ItemStack createdItem, int creationCount, RecipeContainer creationRecipe) {
        this.tree = tree;
        this.createdItem = createdItem;
        this.creationCount = creationCount;
        this.creationRecipe = creationRecipe;
    }

    public void addItemRequirement(ItemStack forStack, ItemStack stack, double count, boolean root) {
        ItemContainer cont = ItemContainer.forStack(forStack);
        Requirement requirement = this.itemRequirements.get(cont);
        if (requirement == null) {
            requirement = new Requirement();
        }
        requirement.addItemRequirement(stack, count);
        this.itemRequirements.put(cont, requirement);
        if (root) {
            cont = ItemContainer.forStack(stack);
            Double i = this.totalRequirements.get(cont);
            if (i == null) {
                i = 0.0;
            }
            i = i + count;
            this.totalRequirements.put(cont, i);
        }
    }

    public void removeItemRequirement(ItemStack forStack) {
        this.itemRequirements.remove(ItemContainer.forStack(forStack));
    }

    public boolean containsItemRequirement(String key) {
        ItemStack s = CraftingHandler.getItemFromString(key);
        return this.itemRequirements.containsKey(ItemContainer.forStack(s));
    }

    public void setCreationRecipe(ItemStack forStack, RecipeContainer recipe) {
        ItemContainer cont = ItemContainer.forStack(forStack);
        this.recipes.put(cont, recipe);
    }

    public void blacklist(RecipeContainer recipe) {
        this.tree.blacklistedRecipes.add(recipe);
    }

    public void finalizeRequirements(EntityPlayer player, IBagCap bag) {
        HashMap<ItemContainer, Double> moreRequirements = new HashMap<ItemContainer, Double>();
        for (Map.Entry<ItemContainer, Double> entry : this.totalRequirements.entrySet()) {
            this.addReqRecursively(moreRequirements, entry.getKey(), entry.getValue(), new ArrayDeque<ItemContainer>());
        }
        for (Map.Entry<ItemContainer, Double> entry : moreRequirements.entrySet()) {
            Double d = this.totalRequirements.get(entry.getKey());
            if (d == null) {
                d = 0.0;
            }
            d = d + entry.getValue();
            this.totalRequirements.put(entry.getKey(), d);
        }
    }

    private Map<ItemContainer, Integer> generateExactRequirementList(int amountToCraft, EntityPlayer player, IBagCap bag) {
        int craftingOps = (int)Math.ceil((double)amountToCraft / (double)this.creationCount);
        int totalItemsCrafted = craftingOps * this.creationCount;
        HashMap<ItemContainer, Integer> exact = new HashMap<ItemContainer, Integer>();
        for (Map.Entry<ItemContainer, Double> entry : this.totalRequirements.entrySet()) {
            RecipeContainer r = this.recipes.get(entry.getKey());
            if (r == null) continue;
            ItemStack out = r.getOutput();
            int outCount = out.func_190916_E();
            int totalItemsAlreadyThere = InventoryHelper.getMatchingStacksWithSizeOne(out, InventoryHelper.getInventoryStacks(bag, player)).size();
            double minNeeded = entry.getValue() * (double)totalItemsCrafted;
            int recipeOps = (int)Math.ceil(minNeeded / (double)outCount);
            int actualNeeded = recipeOps * outCount;
            exact.put(entry.getKey(), Math.max(actualNeeded - totalItemsAlreadyThere, 0));
        }
        return exact;
    }

    public CraftingOrderList generateCraftingOrderList(int amountToCraft, EntityPlayer player, IBagCap bag) {
        CraftingOrderList orderList = new CraftingOrderList();
        if (this.invalid) {
            return orderList;
        }
        int craftingOps = (int)Math.ceil((double)amountToCraft / (double)this.creationCount);
        int totalItemsCrafted = craftingOps * this.creationCount;
        Map<ItemContainer, Integer> exactRequirements = this.generateExactRequirementList(amountToCraft, player, bag);
        HashMap<ItemContainer, Requirement> requirementHierarchy = new HashMap<ItemContainer, Requirement>();
        for (Map.Entry<ItemContainer, Requirement> entry : this.itemRequirements.entrySet()) {
            if (!this.totalRequirements.containsKey(entry.getKey()) && !entry.getKey().equals(ItemContainer.forStack(this.createdItem))) continue;
            requirementHierarchy.put(entry.getKey(), entry.getValue().clone());
        }
        do {
            for (Map.Entry<ItemContainer, Object> entry : this.totalRequirements.entrySet()) {
                if (requirementHierarchy.containsKey(entry.getKey())) continue;
                RecipeContainer recipe = this.recipes.get(entry.getKey());
                if (recipe == null) {
                    recipe = new RecipeContainerProvided(entry.getKey().getItem());
                }
                int outputAmount = recipe.getOutput().func_190916_E();
                boolean exact = exactRequirements.containsKey(entry.getKey());
                double totalItemsNeededCount = exact ? (double)exactRequirements.get(entry.getKey()).intValue() : (double)totalItemsCrafted * (Double)entry.getValue();
                int recipeItemsAlreadyThere = orderList.getToBeCreatedItems(recipe.getOutput());
                int totalItemsAlreadyThere = InventoryHelper.getMatchingStacksWithSizeOne(recipe.getOutput(), InventoryHelper.getInventoryStacks(bag, player)).size() + recipeItemsAlreadyThere;
                int recipeCraftingOps = (int)Math.ceil((exact ? totalItemsNeededCount - (double)recipeItemsAlreadyThere : totalItemsNeededCount * (double)outputAmount - (double)totalItemsAlreadyThere) / (double)outputAmount);
                if (recipeCraftingOps > 0 && !(recipe instanceof RecipeContainerProvided)) {
                    orderList.addRecipe(recipe, recipeCraftingOps);
                }
                ArrayList toRemove = new ArrayList();
                for (Map.Entry h : requirementHierarchy.entrySet()) {
                    Requirement req = (Requirement)h.getValue();
                    req.req.remove(entry.getKey());
                    if (!req.req.isEmpty()) continue;
                    toRemove.add(h.getKey());
                }
                for (ItemContainer ic : toRemove) {
                    requirementHierarchy.remove(ic);
                }
            }
        } while (!requirementHierarchy.isEmpty());
        orderList.addRecipe(this.recipes.get(ItemContainer.forStack(this.createdItem)), craftingOps);
        return orderList;
    }

    private void addReqRecursively(Map<ItemContainer, Double> map, ItemContainer forItem, double count, Queue<ItemContainer> stack) {
        Requirement req = this.itemRequirements.get(forItem);
        if (req != null) {
            for (Map.Entry entry : req.req.entrySet()) {
                Double i = map.get(entry.getKey());
                if (i == null) {
                    i = 0.0;
                }
                i = i + (Double)entry.getValue() * count;
                map.put((ItemContainer)entry.getKey(), i);
                stack.add((ItemContainer)entry.getKey());
                this.addReqRecursively(map, (ItemContainer)entry.getKey(), (Double)entry.getValue() * count, stack);
            }
        }
    }

    private boolean containsCircle(Queue<ItemContainer> stack) {
        if (stack.isEmpty()) {
            return false;
        }
        ArrayDeque<ItemContainer> s = new ArrayDeque<ItemContainer>();
        s.addAll(stack);
        ItemContainer start = (ItemContainer)s.remove();
        Stack<ItemContainer> loop = new Stack<ItemContainer>();
        loop.add(start);
        while (!s.isEmpty()) {
            ItemContainer ic = (ItemContainer)s.remove();
            if (ic.equals(start)) {
                loop.addAll(loop);
                boolean isLoop = true;
                ArrayDeque<ItemContainer> sCopy = new ArrayDeque<ItemContainer>(stack);
                for (ItemContainer c : loop) {
                    if (sCopy.isEmpty()) {
                        isLoop = false;
                        break;
                    }
                    if (((ItemContainer)sCopy.remove()).equals(c)) continue;
                    isLoop = false;
                }
                return isLoop;
            }
            loop.add(ic);
        }
        return false;
    }

    public void merge(RecipeRequirementList other) {
        this.recipes.putAll(other.recipes);
        this.itemRequirements.putAll(other.itemRequirements);
        for (Map.Entry<ItemContainer, Double> entry : other.totalRequirements.entrySet()) {
            Double d = this.totalRequirements.get(entry.getKey());
            if (d == null) {
                d = 0.0;
            }
            this.totalRequirements.put(entry.getKey(), d + entry.getValue());
        }
    }

    public static class CraftingOrderList {
        private Map<RecipeContainer, Integer> recipeAmounts = new HashMap<RecipeContainer, Integer>();
        private Queue<RecipeContainer> recipeQueue = new LinkedList<RecipeContainer>();

        public void addRecipe(RecipeContainer recipe, int craftCount) {
            this.recipeAmounts.put(recipe, craftCount);
            this.recipeQueue.add(recipe);
        }

        public boolean hasNext() {
            return !this.recipeQueue.isEmpty();
        }

        public Tuple<RecipeContainer, Integer> getNextRecipe() {
            RecipeContainer recipe = this.recipeQueue.poll();
            int amount = this.recipeAmounts.get(recipe);
            return new Tuple<RecipeContainer, Integer>(recipe, amount);
        }

        public int getToBeCreatedItems(ItemStack stack) {
            int count = 0;
            for (RecipeContainer c : this.recipeQueue) {
                if (!ItemStack.func_179545_c((ItemStack)c.getOutput(), (ItemStack)stack)) continue;
                count += c.getOutput().func_190916_E() * this.recipeAmounts.get(c);
            }
            return count;
        }
    }

    public static class Requirement {
        private Map<ItemContainer, Double> req = new HashMap<ItemContainer, Double>();

        public void addItemRequirement(ItemStack stack, double count) {
            ItemContainer cont = ItemContainer.forStack(stack);
            Double i = this.req.get(cont);
            if (i == null) {
                i = 0.0;
            }
            i = i + count;
            this.req.put(cont, i);
        }

        public Requirement clone() {
            Requirement r = new Requirement();
            r.req = Maps.newHashMap(this.req);
            return r;
        }
    }
}

