/*
 * Decompiled with CFR 0.152.
 */
package tschipp.buildersbag.common.crafting;

import java.io.File;
import java.io.FileWriter;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.Map;
import java.util.Set;
import net.minecraft.item.ItemStack;
import net.minecraft.item.crafting.IRecipe;
import net.minecraft.item.crafting.Ingredient;
import net.minecraft.util.NonNullList;
import tschipp.buildersbag.BuildersBag;
import tschipp.buildersbag.common.crafting.CraftingHandler;
import tschipp.buildersbag.common.crafting.RecipeContainer;
import tschipp.buildersbag.common.data.Tuple;

public class RecipeTree {
    private Map<String, Set<RecipeNode>> nodes = new HashMap<String, Set<RecipeNode>>();
    private Map<String, RecipeNode> stackAvailableNodes = new HashMap<String, RecipeNode>();

    public void add(IRecipe recipe) {
        ItemStack output = recipe.func_77571_b();
        if (!output.func_190926_b()) {
            NonNullList ingredients = recipe.func_192400_c();
            String outputString = CraftingHandler.getItemString(output);
            RecipeContainer cont = new RecipeContainer((NonNullList<Ingredient>)ingredients, output, CraftingHandler.getTierIfStaged(recipe));
            RecipeNode outputNode = this.getNodeExact(output);
            if (outputNode == null) {
                outputNode = new RecipeNode(outputString);
                this.putNode(outputString, outputNode);
            }
            for (Ingredient ing : ingredients) {
                if (ing.func_193365_a().length == 0) continue;
                String ingString = CraftingHandler.getIngredientString(ing);
                RecipeNode ingNode = this.getNodeExact(ing);
                if (ingNode == null) {
                    ingNode = new RecipeNode(ingString);
                    this.putNode(ingString, ingNode);
                }
                ingNode.add(outputNode, cont);
                for (ItemStack ingStack : ing.func_193365_a()) {
                    String ingStackString = CraftingHandler.getItemString(ingStack);
                    this.putNode(ingStackString, ingNode);
                }
            }
        }
    }

    public RecipeTree getSubtree(NonNullList<ItemStack> stacks) {
        RecipeTree subtree = new RecipeTree();
        for (ItemStack stack : stacks) {
            if (stack.func_190926_b()) continue;
            Set<RecipeNode> nodes = this.getNodes(CraftingHandler.getItemString(stack));
            for (RecipeNode node : nodes) {
                BuildersBag.LOGGER.info("Adding to availability list: " + node.id);
                subtree.stackAvailableNodes.put(node.id, node);
                subtree.putNode(node.id, node);
                subtree.addNodesRecursively(node, this);
            }
        }
        BuildersBag.LOGGER.info("Subtree before removal of illegals: " + subtree.nodes);
        for (int i = 0; i < 6; ++i) {
            HashMap<String, Set<RecipeNode>> nodeCopy = new HashMap<String, Set<RecipeNode>>();
            nodeCopy.putAll(subtree.nodes);
            ArrayList<String> availableStacks = new ArrayList<String>();
            for (ItemStack st : stacks) {
                availableStacks.add(CraftingHandler.getItemString(st));
            }
            for (Set nodeSet : nodeCopy.values()) {
                for (RecipeNode node : nodeSet) {
                    boolean containsAll = true;
                    HashMap<RecipeContainer, Boolean> validRecipeMap = new HashMap<RecipeContainer, Boolean>();
                    block6: for (Tuple<RecipeNode, RecipeContainer> parent : node.parentNodes) {
                        RecipeNode parentNode = parent.getFirst();
                        RecipeContainer recipe = parent.getSecond();
                        Boolean prev = (Boolean)validRecipeMap.get(recipe);
                        if (prev != null && !prev.booleanValue()) continue;
                        validRecipeMap.put(recipe, true);
                        for (Ingredient recipeIngredient : recipe.getIngredients()) {
                            String[] split;
                            String ingId = CraftingHandler.getIngredientString(recipeIngredient);
                            boolean hasAny = false;
                            for (String spl : split = node.id.split(";")) {
                                if (subtree.nodes.get(spl + ";") == null) continue;
                                hasAny = true;
                                break;
                            }
                            if (hasAny) continue;
                            validRecipeMap.put(recipe, false);
                            continue block6;
                        }
                        if (subtree.nodes.get(parentNode.id) != null || availableStacks.contains(node.id)) continue;
                        containsAll = false;
                        break;
                    }
                    Iterator<Tuple<RecipeNode, RecipeContainer>> iterator = validRecipeMap.values().iterator();
                    while (iterator.hasNext()) {
                        boolean b = (Boolean)((Object)iterator.next());
                        containsAll |= b;
                    }
                    if (node.parentNodes.isEmpty()) {
                        boolean hasAny = false;
                        for (String av : availableStacks) {
                            if (!node.id.contains(av)) continue;
                            hasAny = true;
                            break;
                        }
                        if (!hasAny) {
                            String[] split;
                            for (String spl : split = node.id.split(";")) {
                                if (subtree.nodes.get(spl + ";") == null) continue;
                                hasAny = true;
                                break;
                            }
                        }
                        if (!hasAny) {
                            containsAll = false;
                        }
                    }
                    if (containsAll) continue;
                    subtree.nodes.remove(node.id);
                }
            }
        }
        return subtree;
    }

    public NonNullList<ItemStack> getPossibleStacks() {
        NonNullList stacks = NonNullList.func_191196_a();
        BuildersBag.LOGGER.info("stackAvailableNodes: " + this.stackAvailableNodes.keySet());
        BuildersBag.LOGGER.info("nodes in subtree: " + this.nodes);
        for (Set<RecipeNode> nodeSet : this.nodes.values()) {
            for (RecipeNode node : nodeSet) {
                BuildersBag.LOGGER.info("testing availablilty for : " + node.id);
                if (this.stackAvailableNodes.get(node.id) != null) continue;
                String[] split = node.id.split(";");
                BuildersBag.LOGGER.info("doing the test for : " + node.id);
                if (split.length > 1) continue;
                stacks.add((Object)CraftingHandler.getItemFromString(node.id));
            }
        }
        return stacks;
    }

    public RecipeTree getRecipeTree(ItemStack requested) {
        RecipeTree recipeTree = new RecipeTree();
        RecipeNode node = this.getNodeExact(requested);
        if (node == null) {
            return recipeTree;
        }
        recipeTree.putNode(node.id, node);
        recipeTree.addPredecessorRecursively(node);
        return recipeTree;
    }

    private void addPredecessorRecursively(RecipeNode node) {
        for (Tuple<RecipeNode, RecipeContainer> parent : node.parentNodes) {
            if (this.nodes.get(parent.getFirst().id) != null) continue;
            this.putNode(parent.getFirst().id, parent.getFirst());
            this.addPredecessorRecursively(parent.getFirst());
        }
    }

    private void addNodesRecursively(RecipeNode node, RecipeTree parentTree) {
        for (Tuple<RecipeNode, RecipeContainer> adjacent : node.adjacentNodes) {
            RecipeNode adjacentNode = adjacent.getFirst();
            for (RecipeNode n : parentTree.getNodes(adjacentNode.id)) {
                if (this.nodes.get(n.id) != null) continue;
                this.putNode(n.id, n);
                this.addNodesRecursively(n, parentTree);
            }
        }
    }

    public RecipeNode getNodeExact(ItemStack stack) {
        String itemString = CraftingHandler.getItemString(stack);
        Set<RecipeNode> rnodes = this.nodes.get(itemString);
        if (rnodes == null) {
            return null;
        }
        for (RecipeNode node : rnodes) {
            if (!node.id.equals(itemString)) continue;
            return node;
        }
        return null;
    }

    private Set<RecipeNode> getNodes(String key) {
        Set<RecipeNode> rnodes = this.nodes.get(key);
        if (rnodes == null) {
            return Collections.EMPTY_SET;
        }
        return rnodes;
    }

    private RecipeNode getNodeExact(Ingredient ing) {
        String itemString = CraftingHandler.getIngredientString(ing);
        Set<RecipeNode> rnodes = this.nodes.get(itemString);
        if (rnodes == null) {
            return null;
        }
        for (RecipeNode node : rnodes) {
            if (!node.id.equals(itemString)) continue;
            return node;
        }
        return null;
    }

    private void putNode(String key, RecipeNode node) {
        Set<RecipeNode> lnodes = this.nodes.get(key);
        if (lnodes == null) {
            lnodes = new HashSet<RecipeNode>();
        }
        lnodes.add(node);
        this.nodes.put(key, lnodes);
    }

    public void visualize() {
        File output = new File("recipetree.txt");
        try {
            FileWriter writer = new FileWriter(output);
            writer.write("digraph G {\n");
            writer.write("graph [ dpi = 75 ];");
            writer.write("ranksep = 1\n");
            block2: for (Set<RecipeNode> nodeSet : this.nodes.values()) {
                for (RecipeNode node : nodeSet) {
                    for (Tuple<RecipeNode, RecipeContainer> adj : node.adjacentNodes) {
                        int semi = 0;
                        for (char c : node.id.toCharArray()) {
                            if (c == ';' && ++semi >= 2) continue block2;
                        }
                        if (this.nodes.get(adj.getFirst().id) == null) continue;
                        writer.write("\"" + node.id + "\" -> \"" + adj.getFirst().id + "\"\n");
                    }
                }
            }
            writer.write("}");
            writer.close();
        }
        catch (IOException e) {
            e.printStackTrace();
        }
    }

    public static class RecipeNode {
        public String id;
        public Set<Tuple<RecipeNode, RecipeContainer>> adjacentNodes;
        public Set<Tuple<RecipeNode, RecipeContainer>> parentNodes;

        private RecipeNode(String id) {
            this.id = id;
            this.adjacentNodes = new HashSet<Tuple<RecipeNode, RecipeContainer>>();
            this.parentNodes = new HashSet<Tuple<RecipeNode, RecipeContainer>>();
        }

        private void add(RecipeNode n, RecipeContainer c) {
            this.adjacentNodes.add(new Tuple<RecipeNode, RecipeContainer>(n, c));
            n.parentNodes.add(new Tuple<RecipeNode, RecipeContainer>(this, c));
        }

        public String toString() {
            return this.id;
        }
    }
}

