/*
 * Decompiled with CFR 0.152.
 */
package tschipp.buildersbag.common.crafting;

import java.io.File;
import java.io.FileWriter;
import java.io.IOException;
import java.util.ArrayDeque;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.Stack;
import javax.annotation.Nullable;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.item.ItemStack;
import net.minecraft.item.crafting.IRecipe;
import net.minecraft.item.crafting.Ingredient;
import net.minecraft.util.NonNullList;
import tschipp.buildersbag.api.IBagCap;
import tschipp.buildersbag.common.crafting.CraftingHandler;
import tschipp.buildersbag.common.crafting.RecipeContainer;
import tschipp.buildersbag.common.crafting.RecipeRequirementList;
import tschipp.buildersbag.common.data.Tuple;
import tschipp.buildersbag.common.helper.InventoryHelper;
import tschipp.buildersbag.compat.gamestages.StageHelper;

public class RecipeTreeNew {
    private Map<String, RecipeNode> nodes = new HashMap<String, RecipeNode>();
    private Map<String, RecipeNode> rootNodes = new HashMap<String, RecipeNode>();
    private Map<String, Boolean> markedNodes = new HashMap<String, Boolean>();
    private Map<String, Boolean> validatedNodes = new HashMap<String, Boolean>();
    private Map<String, Boolean> invalidatedNodes = new HashMap<String, Boolean>();
    private Stack<String> callStack = new Stack();
    private boolean aborted = false;
    public Set<RecipeContainer> blacklistedRecipes = new HashSet<RecipeContainer>();

    public void add(IRecipe recipe) {
        ItemStack output = recipe.func_77571_b();
        if (!output.func_190926_b()) {
            String oreOutputString;
            RecipeNode altOutputNode;
            NonNullList ingredients = recipe.func_192400_c();
            String outputString = CraftingHandler.getItemString(output);
            RecipeContainer cont = new RecipeContainer((NonNullList<Ingredient>)ingredients, output, CraftingHandler.getTierIfStaged(recipe));
            RecipeNode outputNode = this.nodes.get(outputString);
            if (outputNode == null) {
                outputNode = new RecipeNode(outputString);
                this.nodes.put(outputString, outputNode);
            }
            if ((altOutputNode = this.nodes.get(oreOutputString = CraftingHandler.getStackIngredientString(output, false))) == null) {
                altOutputNode = new RecipeNode(outputString);
                this.nodes.put(oreOutputString, altOutputNode);
            }
            for (Ingredient ing : ingredients) {
                if (ing.func_193365_a().length == 0) continue;
                CraftingHandler.addIngredientIfAlternative(ing);
                String ingString = CraftingHandler.getIngredientString(ing);
                RecipeNode node = this.nodes.get(ingString);
                if (node == null) {
                    node = new RecipeNode(ingString);
                    this.nodes.put(ingString, node);
                }
                node.add(outputNode, cont);
                node.add(altOutputNode, cont);
            }
        }
    }

    @Nullable
    public RecipeRequirementList generateRequirementList(ItemStack toCreate, @Nullable RecipeRequirementList reqList, EntityPlayer player, IBagCap cap) {
        boolean isRoot;
        RecipeNode current;
        String name = CraftingHandler.getItemString(toCreate);
        RecipeNode toCreateNode = this.nodes.get(name);
        RecipeNode parentNode = null;
        RecipeContainer fastestRecipe = null;
        if (this.aborted) {
            return reqList;
        }
        if (reqList == null) {
            this.validatedNodes.clear();
            this.invalidatedNodes.clear();
            this.callStack.clear();
            this.aborted = false;
        }
        if (toCreateNode == null) {
            return reqList;
        }
        if (this.invalidatedNodes.containsKey(toCreateNode.id)) {
            return reqList;
        }
        this.markedNodes.clear();
        ArrayDeque<RecipeNode> bfsqueue = new ArrayDeque<RecipeNode>();
        bfsqueue.add(toCreateNode);
        this.markedNodes.put(toCreateNode.id, true);
        while (!bfsqueue.isEmpty()) {
            current = (RecipeNode)bfsqueue.poll();
            for (Tuple<RecipeNode, RecipeContainer> parent : current.parentNodes) {
                if (this.blacklistedRecipes.contains(parent.getSecond()) || !StageHelper.hasStage(player, parent.getSecond().getStage())) continue;
                RecipeNode p = parent.getFirst();
                if (this.markedNodes.containsKey(p.id)) continue;
                if (this.rootNodes.containsKey(p.id)) {
                    parentNode = p;
                }
                bfsqueue.add(p);
                this.markedNodes.put(p.id, true);
            }
        }
        if (parentNode == null) {
            return reqList;
        }
        bfsqueue.clear();
        bfsqueue.add(parentNode);
        this.invalidatedNodes.put(parentNode.id, true);
        this.markedNodes.clear();
        block2: while (!bfsqueue.isEmpty()) {
            current = (RecipeNode)bfsqueue.poll();
            for (Tuple<RecipeNode, RecipeContainer> child : current.adjacentNodes) {
                if (this.blacklistedRecipes.contains(child.getSecond()) || !StageHelper.hasStage(player, child.getSecond().getStage())) continue;
                RecipeNode c = child.getFirst();
                if (this.markedNodes.containsKey(c.id)) continue;
                if (toCreateNode.id.equals(c.id)) {
                    fastestRecipe = child.getSecond();
                    break block2;
                }
                bfsqueue.add(c);
                this.markedNodes.put(c.id, true);
            }
        }
        if (fastestRecipe == null) {
            return null;
        }
        int creationCount = fastestRecipe.getOutput().func_190916_E();
        boolean bl = isRoot = reqList == null;
        if (reqList == null) {
            reqList = new RecipeRequirementList(this, toCreate, creationCount, fastestRecipe);
        }
        if (isRoot) {
            this.validatedNodes.clear();
        }
        reqList.setCreationRecipe(toCreate, fastestRecipe);
        block4: for (Tuple<RecipeNode, RecipeContainer> parent : toCreateNode.parentNodes) {
            String[] split;
            if (parent.getSecond() != fastestRecipe) continue;
            boolean isRootElement = this.rootNodes.containsKey(parent.getFirst().id);
            for (String str : split = parent.getFirst().id.split(";")) {
                RecipeNode n = this.nodes.get(str + ";");
                if (n == null) continue;
                ItemStack stack = CraftingHandler.getItemFromString(str + ";");
                double ingCount = 0.0;
                for (Ingredient ing : parent.getSecond().getIngredients()) {
                    if (!ing.test((Object)stack)) continue;
                    ingCount += 1.0;
                }
                reqList.addItemRequirement(toCreate, stack, ingCount / (double)creationCount, isRoot);
                boolean wasValidated = this.validatedNodes.containsKey(parent.getFirst().id);
                boolean inQueue = this.callStack.contains(parent.getFirst().id);
                if (inQueue) {
                    reqList.removeItemRequirement(stack);
                    continue block4;
                }
                this.callStack.add(parent.getFirst().id);
                if (!wasValidated) {
                    this.generateRequirementList(stack, reqList, player, cap);
                }
                this.callStack.pop();
                this.validatedNodes.put(parent.getFirst().id, true);
                continue block4;
            }
        }
        if (isRoot && this.aborted) {
            this.aborted = false;
            reqList = this.generateRequirementList(toCreate, null, player, cap);
        }
        if (isRoot && reqList != null) {
            reqList.finalizeRequirements(player, cap);
        }
        return reqList;
    }

    private boolean hasEnoughMaterialsForRoot(RecipeNode p, RecipeContainer recipeContainer, EntityPlayer player, IBagCap cap) {
        String[] split;
        for (String str : split = p.id.split(";")) {
            ItemStack stack = CraftingHandler.getItemFromString(str + ";");
            double ingCount = 0.0;
            for (Ingredient ing : recipeContainer.getIngredients()) {
                if (!ing.test((Object)stack)) continue;
                ingCount += 1.0;
            }
            int provided = InventoryHelper.getMatchingStacksWithSizeOne(stack, InventoryHelper.getInventoryStacks(cap, player)).size();
            if (!((double)provided >= ingCount)) continue;
            return true;
        }
        return false;
    }

    public RecipeTreeNew getSubtree(NonNullList<ItemStack> stacks) {
        RecipeTreeNew subtree = new RecipeTreeNew();
        long time = System.currentTimeMillis();
        for (Object stack : stacks) {
            if (stack.func_190926_b()) continue;
            String[] names = CraftingHandler.getStackIngredientStrings((ItemStack)stack, true);
            RecipeNode n = this.nodes.get(CraftingHandler.getItemString((ItemStack)stack));
            if (n != null) {
                subtree.rootNodes.put(n.id, n);
            }
            for (String name : names) {
                RecipeNode node = this.nodes.get(name);
                if (node == null || subtree.nodes.containsKey(node.id)) continue;
                subtree.rootNodes.put(node.id, node);
                subtree.nodes.put(name, node);
                subtree.addNodesRecursively(node, this);
            }
        }
        ArrayList<String> availableStacks = new ArrayList<String>();
        for (ItemStack st : stacks) {
            availableStacks.add(CraftingHandler.getItemString(st));
        }
        time = System.currentTimeMillis();
        int lastNodeSize = 0;
        for (int i = 0; i < 6; ++i) {
            HashSet<RecipeNode> nodeCopy = new HashSet<RecipeNode>();
            nodeCopy.addAll(subtree.nodes.values());
            for (RecipeNode node : nodeCopy) {
                if (!node.parentNodes.isEmpty()) {
                    subtree.checkDependenciesRecursively(node, null, new ArrayList<RecipeContainer>());
                    continue;
                }
                boolean hasAny = false;
                for (String av : availableStacks) {
                    if (!node.id.contains(av)) continue;
                    hasAny = true;
                    break;
                }
                if (hasAny) continue;
                subtree.nodes.remove(node.id);
            }
            if (subtree.nodes.size() == lastNodeSize) break;
            lastNodeSize = subtree.nodes.size();
        }
        return subtree;
    }

    public NonNullList<ItemStack> getPossibleStacks(boolean removeAvailable) {
        NonNullList stacks = NonNullList.func_191196_a();
        for (RecipeNode node : this.nodes.values()) {
            String[] split;
            if (removeAvailable && this.rootNodes.get(node.id) != null || (split = node.id.split(";")).length > 1) continue;
            stacks.add((Object)CraftingHandler.getItemFromString(node.id));
        }
        return stacks;
    }

    public RecipeTreeNew getRecipeTree(ItemStack requested) {
        RecipeTreeNew recipeTree = new RecipeTreeNew();
        RecipeNode node = this.nodes.get(CraftingHandler.getItemString(requested));
        if (node == null) {
            return recipeTree;
        }
        recipeTree.nodes.put(node.id, node);
        recipeTree.addPredecessorRecursively(node);
        return recipeTree;
    }

    private void addPredecessorRecursively(RecipeNode node) {
        for (Tuple<RecipeNode, RecipeContainer> parent : node.parentNodes) {
            if (this.nodes.get(parent.getFirst().id) != null) continue;
            this.nodes.put(parent.getFirst().id, parent.getFirst());
            this.addPredecessorRecursively(parent.getFirst());
        }
    }

    private boolean checkDependenciesRecursively(RecipeNode node, RecipeContainer callingRecipe, List<RecipeContainer> excludeRecipes) {
        if (node == null) {
            return false;
        }
        if (this.invalidatedNodes.containsKey(node.id)) {
            return false;
        }
        if (this.validatedNodes.containsKey(node.id)) {
            return true;
        }
        if (this.rootNodes.containsKey(node.id)) {
            return true;
        }
        if (this.markedNodes.containsKey(node.id)) {
            excludeRecipes.add(callingRecipe);
            if (this.checkRecipes(node, excludeRecipes)) {
                this.validatedNodes.put(node.id, true);
                excludeRecipes.clear();
                return true;
            }
            this.invalidatedNodes.put(node.id, true);
            return false;
        }
        this.markedNodes.put(node.id, true);
        boolean hasValidRecipe = this.checkRecipes(node, excludeRecipes);
        this.markedNodes.remove(node.id);
        if (!hasValidRecipe) {
            this.nodes.remove(node.id);
            this.invalidatedNodes.put(node.id, true);
            return false;
        }
        this.validatedNodes.put(node.id, true);
        return true;
    }

    private boolean checkRecipes(RecipeNode node, List<RecipeContainer> exclude) {
        if (this.invalidatedNodes.containsKey(node.id)) {
            return false;
        }
        if (this.validatedNodes.containsKey(node.id)) {
            return true;
        }
        if (this.rootNodes.containsKey(node.id)) {
            return true;
        }
        HashMap<RecipeContainer, Boolean> validRecipeMap = new HashMap<RecipeContainer, Boolean>();
        for (Tuple<RecipeNode, RecipeContainer> parent : node.parentNodes) {
            String[] split;
            RecipeNode parentNode = parent.getFirst();
            RecipeContainer parentRecipe = parent.getSecond();
            if (exclude.contains(parentRecipe)) continue;
            Boolean prevRecipeVal = (Boolean)validRecipeMap.get(parentRecipe);
            if (prevRecipeVal == null) {
                validRecipeMap.put(parent.getSecond(), true);
            } else if (prevRecipeVal != null && !prevRecipeVal.booleanValue()) continue;
            if (this.checkDependenciesRecursively(parentNode, parentRecipe, exclude)) continue;
            boolean hasAny = false;
            for (String spl : split = parentNode.id.split(";")) {
                if (!this.checkDependenciesRecursively(this.nodes.get(spl + ";"), parentRecipe, exclude)) continue;
                hasAny = true;
                break;
            }
            if (hasAny) continue;
            validRecipeMap.put(parent.getSecond(), false);
        }
        boolean hasValidRecipe = false;
        Iterator iterator = validRecipeMap.values().iterator();
        while (iterator.hasNext()) {
            boolean b = (Boolean)iterator.next();
            hasValidRecipe |= b;
        }
        return hasValidRecipe;
    }

    private void addNodesRecursively(RecipeNode node, RecipeTreeNew parentTree) {
        for (Tuple<RecipeNode, RecipeContainer> adjacent : node.adjacentNodes) {
            String[] altNames;
            RecipeNode adjacentNode = adjacent.getFirst();
            RecipeNode n = parentTree.nodes.get(adjacentNode.id);
            if (this.nodes.get(n.id) != null) continue;
            this.nodes.put(n.id, n);
            this.addNodesRecursively(n, parentTree);
            String[] split = n.id.split(";");
            if (split.length != 1) continue;
            for (String alt : altNames = CraftingHandler.getStackIngredientStrings(CraftingHandler.getItemFromString(split[0] + ";"), false)) {
                RecipeNode ni = parentTree.nodes.get(alt);
                if (ni == null || this.nodes.get(ni.id) != null) continue;
                this.nodes.put(ni.id, ni);
                this.addNodesRecursively(ni, parentTree);
            }
        }
    }

    private void removeNodesRecursively(RecipeNode node) {
        for (Tuple<RecipeNode, RecipeContainer> adjacent : node.adjacentNodes) {
            RecipeNode adjacentNode = adjacent.getFirst();
            if (this.nodes.get(adjacentNode.id) == null) continue;
            this.nodes.remove(adjacentNode.id);
            this.removeNodesRecursively(adjacentNode);
        }
    }

    public void visualize() {
        File output = new File("recipetree.txt");
        try {
            FileWriter writer = new FileWriter(output);
            writer.write("digraph G {\n");
            ArrayList drawn = new ArrayList();
            for (RecipeNode node : this.nodes.values()) {
                for (Tuple<RecipeNode, RecipeContainer> adj : node.adjacentNodes) {
                    if (this.nodes.get(adj.getFirst().id) == null) continue;
                    writer.write("\"" + node.id + "\" -> \"" + adj.getFirst().id + "\"\n");
                }
            }
            writer.write("}");
            writer.close();
        }
        catch (IOException e) {
            e.printStackTrace();
        }
    }

    public static class RecipeNode {
        public String id;
        public Set<Tuple<RecipeNode, RecipeContainer>> adjacentNodes;
        public Set<Tuple<RecipeNode, RecipeContainer>> parentNodes;

        private RecipeNode(String id) {
            this.id = id;
            this.adjacentNodes = new HashSet<Tuple<RecipeNode, RecipeContainer>>();
            this.parentNodes = new HashSet<Tuple<RecipeNode, RecipeContainer>>();
        }

        private void add(RecipeNode n, RecipeContainer c) {
            this.adjacentNodes.add(new Tuple<RecipeNode, RecipeContainer>(n, c));
            n.parentNodes.add(new Tuple<RecipeNode, RecipeContainer>(this, c));
        }

        public String toString() {
            return this.id;
        }
    }
}

