/*
 * Decompiled with CFR 0.152.
 */
package tschipp.buildersbag.common.events;

import net.minecraft.block.Block;
import net.minecraft.entity.Entity;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.entity.player.EntityPlayerMP;
import net.minecraft.item.Item;
import net.minecraft.item.ItemBlock;
import net.minecraft.item.ItemStack;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.NonNullList;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.IBlockAccess;
import net.minecraft.world.World;
import net.minecraftforge.common.util.FakePlayer;
import net.minecraftforge.event.entity.EntityJoinWorldEvent;
import net.minecraftforge.event.entity.player.PlayerInteractEvent;
import net.minecraftforge.event.world.WorldEvent;
import net.minecraftforge.fml.common.Loader;
import net.minecraftforge.fml.common.Mod;
import net.minecraftforge.fml.common.eventhandler.SubscribeEvent;
import net.minecraftforge.fml.common.network.simpleimpl.IMessage;
import tschipp.buildersbag.BuildersBag;
import tschipp.buildersbag.api.IBagCap;
import tschipp.buildersbag.api.IBagModule;
import tschipp.buildersbag.common.cache.BagCache;
import tschipp.buildersbag.common.helper.BagHelper;
import tschipp.buildersbag.common.helper.CapHelper;
import tschipp.buildersbag.common.helper.InventoryHelper;
import tschipp.buildersbag.compat.linear.LinearCompatManager;
import tschipp.buildersbag.network.client.SyncBagCapInventoryClient;
import tschipp.buildersbag.network.client.SyncEnderchestToClient;

@Mod.EventBusSubscriber(modid="buildersbag")
public class BlockEvents {
    @SubscribeEvent
    public static void onBlockPlace(PlayerInteractEvent.RightClickBlock event) {
        EntityPlayer player = event.getEntityPlayer();
        World world = event.getWorld();
        BlockPos pos = event.getPos();
        EnumFacing facing = event.getFace();
        if (player instanceof FakePlayer) {
            return;
        }
        ItemStack placementItem = player.func_184586_b(event.getHand());
        if (placementItem.func_190916_E() == 1 && placementItem.func_77973_b() instanceof ItemBlock && !player.func_184812_l_()) {
            boolean b;
            Block block = Block.func_149634_a((Item)placementItem.func_77973_b());
            boolean canPlace = world.func_190527_a(block, world.func_180495_p(pos).func_177230_c().func_176200_f((IBlockAccess)world, pos) ? pos : pos.func_177972_a(facing), false, facing, (Entity)player);
            boolean canEdit = player.func_175151_a(pos, facing, placementItem);
            boolean bl = b = canEdit && canPlace;
            if (b) {
                NonNullList<ItemStack> bags = InventoryHelper.getBagsInInventory(player);
                for (ItemStack bag : bags) {
                    IBagCap bagCap = CapHelper.getBagCap(bag);
                    for (IBagModule module : BagHelper.getSortedModules(bagCap)) {
                        if (!module.isEnabled() || !module.isSupplier() || Loader.isModLoaded((String)"linear") && LinearCompatManager.isDragging(player)) continue;
                        ItemStack provided = module.createStack(placementItem, bagCap, player);
                        if (!provided.func_190926_b()) {
                            ItemStack s = placementItem.func_77946_l();
                            placementItem.func_190917_f(1);
                            if (!player.field_70170_p.field_72995_K) {
                                BuildersBag.network.sendTo((IMessage)new SyncBagCapInventoryClient(bagCap, InventoryHelper.getSlotForStack(player, bag)), (EntityPlayerMP)player);
                                BuildersBag.network.sendTo((IMessage)new SyncEnderchestToClient(player), (EntityPlayerMP)player);
                            }
                            return;
                        }
                        if (!world.field_72995_K) continue;
                        placementItem.func_190917_f(1);
                    }
                }
            }
        }
    }

    @SubscribeEvent
    public static void onLogin(EntityJoinWorldEvent event) {
        Entity e = event.getEntity();
        World world = event.getWorld();
        if (e instanceof EntityPlayer && !world.field_72995_K) {
            EntityPlayerMP player = (EntityPlayerMP)e;
            BuildersBag.network.sendTo((IMessage)new SyncEnderchestToClient((EntityPlayer)player), player);
        }
    }

    @SubscribeEvent
    public static void onExitWorld(WorldEvent.Unload event) {
        BagCache.clearCache();
    }
}

