/*
 * Decompiled with CFR 0.152.
 */
package tschipp.buildersbag.common.helper;

import baubles.api.BaublesApi;
import com.google.common.collect.Lists;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import net.minecraft.entity.Entity;
import net.minecraft.entity.item.EntityItem;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.item.ItemStack;
import net.minecraft.util.NonNullList;
import net.minecraft.world.WorldServer;
import net.minecraftforge.fml.common.Loader;
import net.minecraftforge.items.IItemHandler;
import net.minecraftforge.items.ItemStackHandler;
import tschipp.buildersbag.BuildersBag;
import tschipp.buildersbag.api.IBagCap;
import tschipp.buildersbag.api.IBagModule;
import tschipp.buildersbag.api.IBlockSource;
import tschipp.buildersbag.common.cache.BagCache;
import tschipp.buildersbag.common.config.BuildersBagConfig;
import tschipp.buildersbag.common.crafting.RecipeTreeNew;
import tschipp.buildersbag.common.helper.CapHelper;
import tschipp.buildersbag.common.helper.FakePlayerCopy;
import tschipp.buildersbag.common.helper.InventoryHelper;
import tschipp.buildersbag.common.helper.ItemHelper;
import tschipp.buildersbag.common.item.BuildersBagItem;
import tschipp.buildersbag.common.modules.CraftingModule;
import tschipp.buildersbag.compat.blocksourceadapter.BlockSourceAdapterHandler;
import tschipp.buildersbag.compat.botania.BotaniaCompat;

public class BagHelper {
    private static final Map<String, Integer> recursion_depth = new HashMap<String, Integer>();
    private static RecipeTreeNew cachedTree = null;
    private static long treeCacheTime = 0L;
    private static ItemStack cachedRoot = ItemStack.field_190927_a;

    public static NonNullList<ItemStack> getOrProvideStackWithTree(ItemStack stack, int count, IBagCap bag, EntityPlayer player, @Nullable IBagModule exclude, @Nullable RecipeTreeNew tree, @Nonnull ItemStack root) {
        ItemStack bagStack = BagHelper.getStackFromCap(player, bag);
        NonNullList providedList = NonNullList.func_191196_a();
        if (tree == null && cachedTree != null && ItemStack.func_179545_c((ItemStack)cachedRoot, (ItemStack)stack) && System.currentTimeMillis() - treeCacheTime <= 1000L) {
            tree = cachedTree;
            root = cachedRoot;
        }
        if (player.field_70170_p.field_72995_K) {
            int amount = BagCache.getCachedAmount(bagStack, player, stack, count);
            BagCache.modifyCachedAmount(bagStack, stack, -Math.min(amount, count));
            return ItemHelper.listOf(stack, Math.min(amount, count));
        }
        ItemStack foundStack = ItemStack.field_190927_a;
        NonNullList<ItemStack> availableBlocks = InventoryHelper.getStacks((IItemHandler)bag.getBlockInventory());
        BuildersBag.proxy.startWorking(bag.getUUID(), player);
        providedList.addAll(InventoryHelper.addMatchingStacksWithSizeOne(stack, count, availableBlocks));
        for (ItemStack available : availableBlocks) {
            ItemStack provided;
            int i;
            if (available.func_77973_b() instanceof IBlockSource) {
                if (providedList.size() >= count) {
                    BuildersBag.proxy.stopWorking(bag.getUUID(), player);
                    return providedList;
                }
                for (i = 0; i < count - providedList.size(); ++i) {
                    provided = ((IBlockSource)available.func_77973_b()).createBlock(available, stack, player, player.field_70170_p.field_72995_K);
                    if (provided.func_190926_b()) continue;
                    BagCache.sendBagModificationToClient(bagStack, stack, -1, player);
                    providedList.add((Object)provided);
                }
                continue;
            }
            if (!BlockSourceAdapterHandler.hasAdapter(available)) continue;
            if (providedList.size() >= count) {
                BuildersBag.proxy.stopWorking(bag.getUUID(), player);
                return providedList;
            }
            for (i = 0; i < count - providedList.size(); ++i) {
                provided = BlockSourceAdapterHandler.createBlock(available, stack, player, BagHelper.botaniaCheck(available) ? false : player.field_70170_p.field_72995_K);
                if (provided.func_190926_b()) continue;
                BagCache.sendBagModificationToClient(bagStack, stack, -1, player);
                providedList.add((Object)provided);
            }
        }
        for (IBagModule module : BagHelper.getSortedModules(bag)) {
            if (!module.isEnabled() || module.isSupplier() || exclude != null && exclude == module) continue;
            if (providedList.size() >= count) {
                BuildersBag.proxy.stopWorking(bag.getUUID(), player);
                return providedList;
            }
            if (BagHelper.incrementRecursionDepth(player)) {
                NonNullList<ItemStack> provided = module instanceof CraftingModule ? ((CraftingModule)module).createStackWithRecipeTree(stack, count - providedList.size(), bag, player, tree, root) : module.createStackWithCount(stack, count, bag, player);
                BagHelper.resetRecursionDepth(player);
                BagCache.sendBagModificationToClient(bagStack, stack, -provided.size(), player);
                providedList.addAll(provided);
                continue;
            }
            BuildersBag.proxy.stopWorking(bag.getUUID(), player);
            return providedList;
        }
        BuildersBag.proxy.stopWorking(bag.getUUID(), player);
        return providedList;
    }

    public static IBagModule getModule(String name, IBagCap cap) {
        for (IBagModule mod : cap.getModules()) {
            if (mod == null || !mod.getName().equals(name)) continue;
            return mod;
        }
        return null;
    }

    public static int getAllAvailableStacksCount(IBagCap bag, EntityPlayer player) {
        NonNullList<ItemStack> list = BagHelper.getAllAvailableStacks(bag, player);
        int count = 0;
        for (ItemStack s : list) {
            count += s.func_190916_E();
        }
        return count;
    }

    public static NonNullList<ItemStack> getAllAvailableStacks(IBagCap bag, EntityPlayer player) {
        return BagHelper.getAllAvailableStacksExcept(bag, player, null);
    }

    public static NonNullList<ItemStack> getAllAvailableStacksExcept(IBagCap bag, EntityPlayer player, @Nullable IBagModule exclude) {
        NonNullList list = NonNullList.func_191196_a();
        list.addAll(InventoryHelper.getInventoryStacks(bag, player));
        for (IBagModule module : BagHelper.getSortedModules(bag)) {
            if (!module.isEnabled() || module == exclude) continue;
            list.addAll(module.getPossibleStacks(bag, player));
        }
        return list;
    }

    private static boolean incrementRecursionDepth(EntityPlayer player) {
        Integer i = recursion_depth.get(player.func_110124_au().toString());
        if (i == null) {
            i = new Integer(0);
        }
        Integer n = i;
        Integer n2 = i = Integer.valueOf(i + 1);
        recursion_depth.put(player.func_110124_au().toString(), i);
        return i <= BuildersBagConfig.Settings.maximumRecursionDepth;
    }

    public static void resetRecursionDepth(EntityPlayer player) {
        recursion_depth.put(player.func_110124_au().toString(), 0);
    }

    public static ItemStack getOrProvideStack(ItemStack stack, IBagCap bag, EntityPlayer player, @Nullable IBagModule exclude) {
        NonNullList<ItemStack> list = BagHelper.getOrProvideStackWithTree(stack, 1, bag, player, exclude, null, ItemStack.field_190927_a);
        if (list.isEmpty()) {
            return ItemStack.field_190927_a;
        }
        return (ItemStack)list.get(0);
    }

    public static boolean simulateProvideStack(ItemStack stack, ItemStack bag, EntityPlayer player, @Nullable IBagModule exclude) {
        return !BagHelper.getOrProvideStack(stack, CapHelper.getBagCap(bag.func_77946_l()), (EntityPlayer)new FakePlayerCopy((WorldServer)player.field_70170_p, player.func_146103_bH(), player), exclude).func_190926_b();
    }

    public static NonNullList<ItemStack> getOrProvideStackWithCount(ItemStack stack, int count, IBagCap bag, EntityPlayer player, @Nullable IBagModule exclude) {
        NonNullList<ItemStack> list = BagHelper.getOrProvideStackWithTree(stack, count, bag, player, exclude, null, ItemStack.field_190927_a);
        return list;
    }

    public static NonNullList<ItemStack> getOrProvideStackWithCountDominating(int count, IBagCap bag, EntityPlayer player) {
        NonNullList provided = NonNullList.func_191196_a();
        IBagModule dominatingModule = null;
        for (IBagModule module : BagHelper.getSortedModules(bag)) {
            if (!module.isEnabled() || !module.isDominating()) continue;
            dominatingModule = module;
            break;
        }
        if (dominatingModule != null) {
            ItemStack s;
            for (int i = 0; i < count && !(s = BagHelper.getOrProvideStack(dominatingModule.getBlock(bag, player), bag, player, null)).func_190926_b(); ++i) {
                provided.add((Object)s);
            }
        }
        return provided;
    }

    public static NonNullList<ItemStack> simulateProvideStackWithCount(ItemStack stack, int count, ItemStack bag, EntityPlayer player, @Nullable IBagModule exclude) {
        return BagHelper.getOrProvideStackWithCount(stack, count, CapHelper.getBagCap(bag.func_77946_l()), (EntityPlayer)new FakePlayerCopy((WorldServer)player.field_70170_p, player.func_146103_bH(), player), exclude);
    }

    public static void compactStacks(IBagCap cap, EntityPlayer player) {
        NonNullList<ItemStack> stacks = InventoryHelper.getStacks((IItemHandler)cap.getBlockInventory());
        for (IBagModule module : BagHelper.getSortedModules(cap)) {
            stacks = module.getCompactedStacks(stacks, player);
        }
        for (int i = 0; i < cap.getBlockInventory().getSlots(); ++i) {
            cap.getBlockInventory().setStackInSlot(i, ItemStack.field_190927_a);
        }
        for (ItemStack s : stacks) {
            BagHelper.addStack(s, cap, player);
        }
    }

    public static void addStack(ItemStack stack, int count, IBagCap cap, EntityPlayer player) {
        int stacks = count / 64;
        int rest = count % 64;
        for (int i = 0; i < stacks; ++i) {
            ItemStack s = stack.func_77946_l();
            s.func_190920_e(64);
            BagHelper.addStack(s, cap, player);
        }
        ItemStack s = stack.func_77946_l();
        s.func_190920_e(rest);
        BagHelper.addStack(s, cap, player);
    }

    public static void addStack(ItemStack stack, IBagCap cap, EntityPlayer player) {
        if (player.func_184812_l_()) {
            return;
        }
        ItemStackHandler handler = cap.getBlockInventory();
        for (int i = 0; i < handler.getSlots(); ++i) {
            if (handler.insertItem(i, stack, true) == stack) continue;
            ItemStack rest = handler.insertItem(i, stack, false);
            if (!rest.func_190926_b()) {
                BagHelper.addStack(rest, cap, player);
            }
            return;
        }
        if (!player.func_191521_c(stack)) {
            player.func_71019_a(stack, false);
        }
    }

    public static void addOrDropStack(ItemStack stack, IBagCap cap, EntityPlayer player) {
        if (player.func_184812_l_()) {
            return;
        }
        ItemStackHandler handler = cap.getBlockInventory();
        for (int i = 0; i < handler.getSlots(); ++i) {
            if (handler.insertItem(i, stack, true) == stack) continue;
            ItemStack rest = handler.insertItem(i, stack, false);
            if (!rest.func_190926_b()) {
                BagHelper.addStack(rest, cap, player);
            }
            return;
        }
        if (!player.func_191521_c(stack)) {
            player.func_71019_a(stack, false);
        }
    }

    public static void addStackToPlayerInvOrDrop(ItemStack stack, EntityPlayer player) {
        if (player.func_184812_l_()) {
            return;
        }
        if (!player.field_70170_p.field_72995_K) {
            EntityItem eItem = new EntityItem(player.field_70170_p, player.field_70165_t, player.field_70163_u, player.field_70161_v, stack);
            player.field_70170_p.func_72838_d((Entity)eItem);
        }
    }

    public static ItemStack getStackFromCap(EntityPlayer player, IBagCap cap) {
        ItemStack bauble;
        for (int i = 0; i < player.field_71071_by.func_70302_i_(); ++i) {
            ItemStack s = player.field_71071_by.func_70301_a(i);
            if (!(s.func_77973_b() instanceof BuildersBagItem) || !CapHelper.areCapsEqual(cap, CapHelper.getBagCap(s))) continue;
            return s;
        }
        if (Loader.isModLoaded((String)"baubles") && (bauble = BaublesApi.getBaubles((EntityPlayer)player).func_70301_a(3)).func_77973_b() instanceof BuildersBagItem && CapHelper.areCapsEqual(cap, CapHelper.getBagCap(bauble))) {
            return bauble;
        }
        return ItemStack.field_190927_a;
    }

    public static List<IBagModule> getSortedModules(IBagCap cap) {
        List<Object> modules = Lists.newArrayList((Object[])cap.getModules());
        modules = modules.stream().sorted((a, b) -> Integer.compare(b.getPriority().getVal(), a.getPriority().getVal())).collect(Collectors.toList());
        return modules;
    }

    public static void updateTreeCache(RecipeTreeNew tree, ItemStack root) {
        cachedTree = tree;
        cachedRoot = root;
        treeCacheTime = System.currentTimeMillis();
    }

    private static boolean botaniaCheck(ItemStack stack) {
        if (Loader.isModLoaded((String)"botania")) {
            return BotaniaCompat.isEnderHand(stack);
        }
        return false;
    }
}

