/*
 * Decompiled with CFR 0.152.
 */
package tschipp.buildersbag.common.helper;

import baubles.api.BaublesApi;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.inventory.IInventory;
import net.minecraft.item.ItemStack;
import net.minecraft.util.NonNullList;
import net.minecraftforge.fml.common.Loader;
import net.minecraftforge.items.IItemHandler;
import net.minecraftforge.items.ItemStackHandler;
import tschipp.buildersbag.api.IBagCap;
import tschipp.buildersbag.api.IBagModule;
import tschipp.buildersbag.api.IBlockSource;
import tschipp.buildersbag.common.data.Tuple;
import tschipp.buildersbag.common.helper.ItemHelper;
import tschipp.buildersbag.common.item.BuildersBagItem;
import tschipp.buildersbag.compat.blocksourceadapter.BlockSourceAdapterHandler;

public class InventoryHelper {
    public static final int TOP_OFFSET = 15;
    public static final int LEFT_OFFSET = 7;
    public static final int INV_OFFSET = 14;
    public static final int HOTBAR_OFFSET = 4;
    public static final int BOTTOM_OFFSET = 7;
    public static final int RIGHT_OFFSET = 7;

    public static int getSlotWidth(int slotAmount) {
        return slotAmount * 18 + 7 + 7;
    }

    public static int getBagRows(int slotAmount) {
        return (int)Math.ceil((double)slotAmount / 9.0);
    }

    public static int getLastRowExtra(int slotAmount) {
        return slotAmount % 9;
    }

    public static int getMaxModules(int slotAmount) {
        return InventoryHelper.getTotalHeight(slotAmount) / 33;
    }

    public static int getTotalHeight(int slotAmount) {
        return 15 + (InventoryHelper.getBagRows(slotAmount) + 4) * 18 + 4 + 14 + 7;
    }

    public static int getTotalWidth() {
        return 176;
    }

    public static int getBagExtraRight(IBagCap cap) {
        int maxModules = InventoryHelper.getMaxModules(cap.getBlockInventory().getSlots());
        int maximum = 0;
        for (int i = 0; i < maxModules && i < cap.getModules().length; ++i) {
            IBagModule module = cap.getModules()[i];
            ItemStackHandler handler = module.getInventory();
            int base = 32;
            if (handler != null) {
                int slotExtra = handler.getSlots() * 18 + 14;
                if (maximum >= slotExtra + base) continue;
                maximum = slotExtra + base;
                continue;
            }
            if (maximum >= base) continue;
            maximum = base;
        }
        return maximum;
    }

    public static int getBagExtraLeft(IBagCap cap) {
        int maxModules = InventoryHelper.getMaxModules(cap.getBlockInventory().getSlots());
        int maximum = 0;
        for (int i = maxModules; i < cap.getModules().length; ++i) {
            IBagModule module = cap.getModules()[i];
            ItemStackHandler handler = module.getInventory();
            int base = 32;
            if (handler != null) {
                int slotExtra = handler.getSlots() * 18 + 14;
                if (maximum >= slotExtra + base) continue;
                maximum = slotExtra + base;
                continue;
            }
            if (maximum >= base) continue;
            maximum = base;
        }
        return maximum;
    }

    public static NonNullList<ItemStack> getInventoryStacks(IBagCap bag, EntityPlayer player) {
        NonNullList list = NonNullList.func_191196_a();
        list.addAll(InventoryHelper.getStacks((IItemHandler)bag.getBlockInventory()));
        for (ItemStack available : list) {
            if (available.func_77973_b() instanceof IBlockSource) {
                list.addAll(((IBlockSource)available.func_77973_b()).getCreateableBlocks(available, player));
                continue;
            }
            if (!BlockSourceAdapterHandler.hasAdapter(available)) continue;
            list.addAll(BlockSourceAdapterHandler.getCreateableBlocks(available, player));
        }
        return list;
    }

    public static NonNullList<ItemStack> getStacks(IItemHandler handler) {
        NonNullList list = NonNullList.func_191196_a();
        for (int i = 0; i < handler.getSlots(); ++i) {
            ItemStack stack = handler.getStackInSlot(i);
            if (stack.func_190926_b()) continue;
            list.add((Object)stack);
        }
        return list;
    }

    public static NonNullList<ItemStack> getBagsInInventory(EntityPlayer player) {
        NonNullList list = NonNullList.func_191196_a();
        for (ItemStack s : player.field_71071_by.field_70462_a) {
            if (!(s.func_77973_b() instanceof BuildersBagItem)) continue;
            list.add((Object)s);
        }
        for (ItemStack s : player.field_71071_by.field_184439_c) {
            if (!(s.func_77973_b() instanceof BuildersBagItem)) continue;
            list.add((Object)s);
        }
        if (Loader.isModLoaded((String)"baubles")) {
            IInventory baubles = BaublesApi.getBaubles((EntityPlayer)player);
            for (int i = 0; i < baubles.func_70302_i_(); ++i) {
                ItemStack s = baubles.func_70301_a(i);
                if (!(s.func_77973_b() instanceof BuildersBagItem)) continue;
                list.add((Object)s);
            }
        }
        return list;
    }

    public static NonNullList<ItemStack> addMatchingStacksWithSizeOne(ItemStack stack, int count, NonNullList<ItemStack> fromStacks) {
        NonNullList list = NonNullList.func_191196_a();
        stack = stack.func_77946_l();
        stack.func_190920_e(1);
        for (ItemStack s : fromStacks) {
            if (count <= 0) break;
            if (!ItemStack.func_179545_c((ItemStack)s, (ItemStack)stack)) continue;
            int reduce = Math.min(s.func_190916_E(), count);
            list.addAll(ItemHelper.listOf(stack, reduce));
            count -= reduce;
            s.func_190918_g(reduce);
        }
        return list;
    }

    public static NonNullList<ItemStack> getMatchingStacksWithSizeOne(ItemStack stack, NonNullList<ItemStack> fromStacks) {
        NonNullList list = NonNullList.func_191196_a();
        for (ItemStack s : fromStacks) {
            if (!ItemStack.func_179545_c((ItemStack)s, (ItemStack)stack)) continue;
            s = s.func_77946_l();
            int count = s.func_190916_E();
            for (int i = 0; i < count; ++i) {
                list.add((Object)s.func_77979_a(1));
            }
        }
        return list;
    }

    public static int getSlotForStack(EntityPlayer player, ItemStack stack) {
        for (int i = 0; i < player.field_71071_by.func_70302_i_(); ++i) {
            if (player.field_71071_by.func_70301_a(i) != stack) continue;
            return i;
        }
        return -1;
    }

    public static ItemStack getStackInSlot(EntityPlayer player, int slot, boolean isBauble) {
        ItemStack stack = ItemStack.field_190927_a;
        if (isBauble && Loader.isModLoaded((String)"baubles")) {
            BaublesApi.getBaubles((EntityPlayer)player).func_70301_a(slot);
        } else {
            stack = player.field_71071_by.func_70301_a(slot);
        }
        return stack;
    }

    public static Tuple<Boolean, Integer> getSlotForStackWithBaubles(EntityPlayer player, ItemStack stack) {
        for (int i = 0; i < player.field_71071_by.func_70302_i_(); ++i) {
            if (!ItemStack.areItemStacksEqualUsingNBTShareTag((ItemStack)player.field_71071_by.func_70301_a(i), (ItemStack)stack)) continue;
            return new Tuple<Boolean, Integer>(false, i);
        }
        if (Loader.isModLoaded((String)"baubles") && ItemStack.areItemStacksEqualUsingNBTShareTag((ItemStack)BaublesApi.getBaubles((EntityPlayer)player).func_70301_a(3), (ItemStack)stack)) {
            return new Tuple<Boolean, Integer>(true, 3);
        }
        return new Tuple<Boolean, Integer>(false, -1);
    }
}

