/*
 * Decompiled with CFR 0.152.
 */
package tschipp.buildersbag.common.inventory;

import baubles.api.BaublesApi;
import com.google.common.collect.ImmutableMap;
import java.util.ArrayList;
import java.util.List;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.entity.player.EntityPlayerMP;
import net.minecraft.inventory.ClickType;
import net.minecraft.inventory.Container;
import net.minecraft.inventory.IInventory;
import net.minecraft.inventory.Slot;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTBase;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.util.EnumHand;
import net.minecraft.util.text.translation.I18n;
import net.minecraftforge.fml.common.Loader;
import net.minecraftforge.fml.common.network.simpleimpl.IMessage;
import net.minecraftforge.items.IItemHandler;
import net.minecraftforge.items.ItemStackHandler;
import net.minecraftforge.items.SlotItemHandler;
import org.apache.commons.lang3.tuple.ImmutableTriple;
import org.apache.commons.lang3.tuple.Triple;
import tschipp.buildersbag.BuildersBag;
import tschipp.buildersbag.api.IBagCap;
import tschipp.buildersbag.api.IBagModule;
import tschipp.buildersbag.common.cache.BagCache;
import tschipp.buildersbag.common.helper.CapHelper;
import tschipp.buildersbag.common.helper.InventoryHelper;
import tschipp.buildersbag.common.inventory.SelectedBlockSlot;
import tschipp.buildersbag.common.inventory.ToggleableSlot;
import tschipp.buildersbag.network.client.SyncBagCapClient;
import tschipp.buildersbag.network.client.SyncBagCapInventoryClient;

public class ContainerBag
extends Container {
    public ItemStack bag;
    public IBagCap bagCap;
    private EntityPlayer player;
    public EnumHand hand;
    private ItemStackHandler inv;
    public boolean isBauble = false;
    public int slot = -1;
    private List<Slot> inventoryBagSlots = new ArrayList<Slot>();
    private Slot selectedBlockSlot;
    public int invSize;
    public String name;
    public ImmutableMap<IBagModule, Triple<Integer, Integer, Boolean>> modules;
    public int leftOffset = 0;

    public ContainerBag(EntityPlayer player, ItemStack bag, EnumHand hand) {
        this(player, bag);
        this.hand = hand;
        this.sync();
    }

    public ContainerBag(EntityPlayer player, ItemStack bag, int baubleSlot) {
        this(player, bag);
        this.slot = baubleSlot;
        this.isBauble = true;
        this.sync();
    }

    private ContainerBag(EntityPlayer player, ItemStack bag) {
        this.player = player;
        this.bag = bag;
        this.bagCap = CapHelper.getBagCap(bag);
        this.inv = this.bagCap.getBlockInventory();
        this.invSize = this.inv.getSlots();
        this.slot = InventoryHelper.getSlotForStack(player, bag);
        this.leftOffset = Math.max(InventoryHelper.getBagExtraLeft(CapHelper.getBagCap(bag)), InventoryHelper.getBagExtraRight(CapHelper.getBagCap(bag)));
        this.name = bag.func_82837_s() ? bag.func_82833_r() : I18n.func_74838_a((String)"buildersbag.name");
        this.setupInventories();
    }

    private void setupInventories() {
        this.setupPlayerInventory();
        this.setupBagInventory();
        this.setupModuleInventories();
    }

    private void setupBagInventory() {
        int slotIndex = 0;
        int x = 0;
        int y = 0;
        x += 8;
        y += 16;
        for (int i = 0; i < InventoryHelper.getBagRows(this.invSize); ++i) {
            for (int j = 0; j < 9 && slotIndex < this.invSize; ++j) {
                this.inventoryBagSlots.add(this.func_75146_a((Slot)new SlotItemHandler((IItemHandler)this.inv, slotIndex++, x + j * 18 + this.leftOffset, y + i * 18)));
            }
        }
        this.selectedBlockSlot = this.func_75146_a((Slot)new SelectedBlockSlot((IItemHandler)this.bagCap.getSelectedInventory(), 0, 80 + this.leftOffset, -24));
    }

    private void setupPlayerInventory() {
        int x = 0;
        int y = 0;
        int slotIndex = 9;
        x += 8;
        y += 16 + InventoryHelper.getBagRows(this.invSize) * 18 + 14;
        for (int i = 0; i < 3; ++i) {
            for (int j = 0; j < 9; ++j) {
                this.func_75146_a(new Slot((IInventory)this.player.field_71071_by, slotIndex++, x + j * 18 + this.leftOffset, y + i * 18));
            }
        }
        slotIndex = 0;
        y += 58;
        for (int j = 0; j < 9; ++j) {
            this.func_75146_a(new Slot((IInventory)this.player.field_71071_by, slotIndex++, x + j * 18 + this.leftOffset, y));
        }
    }

    private void setupModuleInventories() {
        int j;
        ItemStackHandler handler;
        int slotIndex;
        IBagModule module;
        int i;
        ImmutableMap.Builder builder = ImmutableMap.builder();
        int moduleCount = InventoryHelper.getMaxModules(this.invSize);
        int x = InventoryHelper.getTotalWidth() + 40;
        int y = 8;
        int rightModuleCount = 0;
        int processedModules = 0;
        for (i = 0; i < this.bagCap.getModules().length && rightModuleCount != moduleCount; ++rightModuleCount, ++i) {
            ++processedModules;
            module = this.bagCap.getModules()[i];
            builder.put((Object)module, (Object)new ImmutableTriple((Object)(x - 40 + this.leftOffset), (Object)(y - 8), (Object)true));
            if (module.getInventory() != null) {
                slotIndex = 0;
                handler = module.getInventory();
                for (j = 0; j < handler.getSlots(); ++j) {
                    this.func_75146_a((Slot)new ToggleableSlot((IItemHandler)handler, slotIndex++, x + j * 18 + this.leftOffset, y).setSlotEnabled(module.isExpanded()));
                }
            }
            x = InventoryHelper.getTotalWidth() + 40;
            y += 34;
        }
        y = 8;
        x = -40;
        for (i = processedModules; i < this.bagCap.getModules().length; ++i) {
            module = this.bagCap.getModules()[i];
            builder.put((Object)module, (Object)new ImmutableTriple((Object)(x + 8 + this.leftOffset), (Object)(y - 8), (Object)false));
            if (module.getInventory() != null) {
                slotIndex = 0;
                handler = module.getInventory();
                for (j = 0; j < handler.getSlots(); ++j) {
                    this.func_75146_a((Slot)new ToggleableSlot((IItemHandler)handler, slotIndex++, x - j * 18 - 16 + this.leftOffset, y).setSlotEnabled(module.isExpanded()));
                }
            } else {
                x = -41;
            }
            y += 34;
        }
        this.modules = builder.build();
    }

    public ItemStack func_82846_b(EntityPlayer playerIn, int index) {
        ItemStack itemstack = ItemStack.field_190927_a;
        Slot slot = (Slot)this.field_75151_b.get(index);
        int rows = InventoryHelper.getBagRows(this.invSize);
        ItemStack stack = slot.func_75211_c();
        if (index < 36 ? !this.func_75135_a(stack, 36, 36 + this.invSize, false) && !this.func_75135_a(stack, 36 + this.invSize + 1, this.field_75151_b.size(), false) : (index >= 36 && index < 9 * (4 + rows) ? !this.func_75135_a(stack, 0, 36, false) : !this.func_75135_a(stack, 0, 36, false))) {
            return ItemStack.field_190927_a;
        }
        return itemstack;
    }

    protected boolean func_75135_a(ItemStack stack, int startIndex, int endIndex, boolean reverseDirection) {
        boolean flag = false;
        int i = startIndex;
        if (reverseDirection) {
            i = endIndex - 1;
        }
        if (stack.func_77985_e()) {
            while (!stack.func_190926_b() && !(reverseDirection ? i < startIndex : i >= endIndex)) {
                Slot slot = (Slot)this.field_75151_b.get(i);
                ItemStack itemstack = slot.func_75211_c();
                if (slot instanceof ToggleableSlot && !((ToggleableSlot)slot).isSlotEnabled()) {
                    if (reverseDirection) {
                        --i;
                        continue;
                    }
                    ++i;
                    continue;
                }
                if (!itemstack.func_190926_b() && itemstack.func_77973_b() == stack.func_77973_b() && (!stack.func_77981_g() || stack.func_77960_j() == itemstack.func_77960_j()) && ItemStack.func_77970_a((ItemStack)stack, (ItemStack)itemstack) && slot.func_75214_a(stack)) {
                    int maxSize;
                    int j = itemstack.func_190916_E() + stack.func_190916_E();
                    if (j <= (maxSize = Math.min(slot.func_75219_a(), stack.func_77976_d()))) {
                        stack.func_190920_e(0);
                        itemstack.func_190920_e(j);
                        slot.func_75218_e();
                        flag = true;
                    } else if (itemstack.func_190916_E() < maxSize) {
                        stack.func_190918_g(maxSize - itemstack.func_190916_E());
                        itemstack.func_190920_e(maxSize);
                        slot.func_75218_e();
                        flag = true;
                    }
                }
                if (reverseDirection) {
                    --i;
                    continue;
                }
                ++i;
            }
        }
        if (!stack.func_190926_b()) {
            i = reverseDirection ? endIndex - 1 : startIndex;
            while (!(!reverseDirection ? i >= endIndex : i < startIndex)) {
                Slot slot1 = (Slot)this.field_75151_b.get(i);
                if (slot1 instanceof ToggleableSlot && !((ToggleableSlot)slot1).isSlotEnabled()) {
                    if (reverseDirection) {
                        --i;
                        continue;
                    }
                    ++i;
                    continue;
                }
                ItemStack itemstack1 = slot1.func_75211_c();
                if (itemstack1.func_190926_b() && slot1.func_75214_a(stack)) {
                    if (stack.func_190916_E() > slot1.func_75219_a()) {
                        slot1.func_75215_d(stack.func_77979_a(slot1.func_75219_a()));
                    } else {
                        slot1.func_75215_d(stack.func_77979_a(stack.func_190916_E()));
                    }
                    slot1.func_75218_e();
                    flag = true;
                    break;
                }
                if (reverseDirection) {
                    --i;
                    continue;
                }
                ++i;
            }
        }
        return flag;
    }

    public boolean func_94531_b(Slot slot) {
        return !(slot instanceof SelectedBlockSlot);
    }

    public void updateModule(String name, NBTTagCompound nbt) {
        this.modules.forEach((module, triple) -> {
            if (module.getName().equals(name)) {
                module.deserializeNBT((NBTBase)nbt);
            }
        });
        this.update();
    }

    public void update() {
        this.field_75151_b.clear();
        this.field_75153_a.clear();
        this.setupInventories();
    }

    public void sync() {
        if (!this.player.field_70170_p.field_72995_K) {
            if (this.isBauble) {
                BuildersBag.network.sendTo((IMessage)new SyncBagCapInventoryClient(this.bagCap, this.slot, true), (EntityPlayerMP)this.player);
            } else {
                BuildersBag.network.sendTo((IMessage)new SyncBagCapClient(this.bagCap, this.hand), (EntityPlayerMP)this.player);
            }
        }
    }

    public boolean func_75145_c(EntityPlayer player) {
        if (Loader.isModLoaded((String)"baubles")) {
            return this.isBauble ? BaublesApi.getBaubles((EntityPlayer)player).func_70301_a(this.slot) == this.bag : !player.func_184586_b(this.hand).func_190926_b() && player.func_184586_b(this.hand) == this.bag;
        }
        return !player.func_184586_b(this.hand).func_190926_b() && player.func_184586_b(this.hand) == this.bag;
    }

    public ItemStack func_184996_a(int slotId, int dragType, ClickType clickTypeIn, EntityPlayer player) {
        if (slotId == this.selectedBlockSlot.field_75222_d) {
            ItemStack mouseItem = player.field_71071_by.func_70445_o().func_77946_l();
            if (this.selectedBlockSlot.func_75214_a(mouseItem) || mouseItem.func_190926_b()) {
                mouseItem.func_190920_e(1);
                this.selectedBlockSlot.func_75215_d(mouseItem);
            }
            this.sync();
            return ItemStack.field_190927_a;
        }
        ItemStack ret = super.func_184996_a(slotId, dragType, clickTypeIn, player);
        this.sync();
        return ret;
    }

    public void func_75134_a(EntityPlayer playerIn) {
        super.func_75134_a(playerIn);
        this.sync();
        BagCache.clearBagCache(this.bag);
    }
}

