/*
 * Decompiled with CFR 0.152.
 */
package tschipp.buildersbag.common.item;

import baubles.api.BaubleType;
import baubles.api.IBauble;
import com.creativemd.creativecore.common.utils.type.HashMapList;
import com.creativemd.littletiles.common.api.ILittleIngredientInventory;
import com.creativemd.littletiles.common.api.ILittleIngredientSupplier;
import com.creativemd.littletiles.common.util.ingredient.LittleIngredients;
import com.creativemd.littletiles.common.util.ingredient.LittleInventory;
import com.mojang.realmsclient.gui.ChatFormatting;
import javax.annotation.Nonnull;
import net.minecraft.block.Block;
import net.minecraft.creativetab.CreativeTabs;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.entity.player.EntityPlayerMP;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.util.ActionResult;
import net.minecraft.util.EnumActionResult;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.EnumHand;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.text.ITextComponent;
import net.minecraft.util.text.TextComponentString;
import net.minecraft.util.text.translation.I18n;
import net.minecraft.world.IBlockAccess;
import net.minecraft.world.World;
import net.minecraft.world.WorldServer;
import net.minecraftforge.common.capabilities.ICapabilityProvider;
import net.minecraftforge.common.util.FakePlayer;
import net.minecraftforge.fml.common.Loader;
import net.minecraftforge.fml.common.Optional;
import net.minecraftforge.fml.common.network.simpleimpl.IMessage;
import net.minecraftforge.fml.common.registry.ForgeRegistries;
import net.minecraftforge.registries.IForgeRegistryEntry;
import tschipp.buildersbag.BuildersBag;
import tschipp.buildersbag.api.IBagCap;
import tschipp.buildersbag.api.IBagModule;
import tschipp.buildersbag.common.caps.BagCapProvider;
import tschipp.buildersbag.common.helper.BagHelper;
import tschipp.buildersbag.common.helper.CapHelper;
import tschipp.buildersbag.common.modules.LittleTilesModule;
import tschipp.buildersbag.compat.botania.BotaniaCompat;
import tschipp.buildersbag.compat.linear.LinearCompatManager;
import tschipp.buildersbag.network.client.SyncBagCapClient;
import tschipp.buildersbag.network.client.SyncBagCapInventoryClient;
import tschipp.buildersbag.network.client.SyncEnderchestToClient;
import vazkii.botania.api.item.IBlockProvider;

@Optional.InterfaceList(value={@Optional.Interface(modid="littletiles", iface="com.creativemd.littletiles.common.api.ILittleIngredientSupplier"), @Optional.Interface(modid="littletiles", iface="com.creativemd.littletiles.common.api.ILittleIngredientInventory"), @Optional.Interface(modid="botania", iface="vazkii.botania.api.item.IBlockProvider"), @Optional.Interface(modid="baubles", iface="baubles.api.IBauble")})
public class BuildersBagItem
extends Item
implements ILittleIngredientSupplier,
ILittleIngredientInventory,
IBlockProvider,
IBauble {
    private int tier;

    public BuildersBagItem(int tier, String tiername) {
        String name = "builders_bag_tier_" + tiername;
        this.func_77655_b(name);
        this.setRegistryName(name);
        this.func_77637_a(CreativeTabs.field_78040_i);
        this.func_77625_d(1);
        this.tier = tier;
        BuildersBag.proxy.setTEISR(this);
        ForgeRegistries.ITEMS.register((IForgeRegistryEntry)this);
    }

    public ICapabilityProvider initCapabilities(ItemStack stack, NBTTagCompound nbt) {
        return new BagCapProvider(this.getTier());
    }

    public ActionResult<ItemStack> func_77659_a(World world, EntityPlayer player, EnumHand hand) {
        ItemStack stack = player.func_184586_b(hand);
        if (player.func_70093_af() && (!Loader.isModLoaded((String)"linear") || LinearCompatManager.doDragCheck(player))) {
            player.openGui((Object)BuildersBag.instance, 0, world, hand == EnumHand.MAIN_HAND ? 1 : 0, 0, 0);
        }
        if (!world.field_72995_K) {
            BuildersBag.network.sendTo((IMessage)new SyncEnderchestToClient(player), (EntityPlayerMP)player);
        }
        return new ActionResult(EnumActionResult.PASS, (Object)stack);
    }

    public EnumActionResult func_180614_a(EntityPlayer player, World world, BlockPos pos, EnumHand hand, EnumFacing facing, float hitX, float hitY, float hitZ) {
        if (player.func_70093_af()) {
            return EnumActionResult.PASS;
        }
        ItemStack stack = player.func_184586_b(hand);
        IBagCap bag = CapHelper.getBagCap(stack);
        if (!world.field_72995_K) {
            boolean b;
            FakePlayer fake = new FakePlayer((WorldServer)world, player.func_146103_bH());
            fake.field_70125_A = player.field_70125_A;
            fake.field_70177_z = player.field_70177_z;
            fake.func_70107_b(0.0, 0.0, 0.0);
            ItemStack placementStack = ItemStack.field_190927_a;
            for (IBagModule module : BagHelper.getSortedModules(bag)) {
                if (!module.isEnabled() || !module.isDominating()) continue;
                placementStack = module.getBlock(bag, player);
                break;
            }
            if (placementStack.func_190926_b()) {
                placementStack = bag.getSelectedInventory().getStackInSlot(0).func_77946_l();
            }
            if (placementStack.func_190926_b()) {
                player.func_146105_b((ITextComponent)new TextComponentString(ChatFormatting.RED + I18n.func_74838_a((String)"buildersbag.noblock")), true);
                return EnumActionResult.FAIL;
            }
            ItemStack requestedStack = placementStack.func_77946_l();
            fake.func_184611_a(hand, placementStack);
            fake.func_70107_b(player.field_70165_t, player.field_70163_u, player.field_70161_v);
            Block block = Block.func_149634_a((Item)placementStack.func_77973_b());
            boolean canPlace = world.func_190527_a(block, world.func_180495_p(pos).func_177230_c().func_176200_f((IBlockAccess)world, pos) ? pos : pos.func_177972_a(facing), false, facing, (Entity)player);
            boolean canEdit = player.func_175151_a(pos, facing, placementStack);
            boolean bl = b = canEdit && canPlace;
            if (!b) {
                player.func_146105_b((ITextComponent)new TextComponentString(ChatFormatting.RED + I18n.func_74837_a((String)"buildersbag.cantplace", (Object[])new Object[]{requestedStack.func_82833_r()})), true);
                return EnumActionResult.FAIL;
            }
            placementStack = !player.func_184812_l_() ? BagHelper.getOrProvideStack(placementStack, bag, player, null) : placementStack.func_77946_l();
            BagHelper.resetRecursionDepth(player);
            if (placementStack.func_190926_b()) {
                player.func_146105_b((ITextComponent)new TextComponentString(ChatFormatting.RED + I18n.func_74837_a((String)"buildersbag.nomaterials", (Object[])new Object[]{requestedStack.func_82833_r()})), true);
                return EnumActionResult.FAIL;
            }
            fake.func_70107_b(0.0, 0.0, 0.0);
            fake.func_184611_a(hand, placementStack);
            fake.func_70107_b(player.field_70165_t, player.field_70163_u, player.field_70161_v);
            EnumActionResult result = placementStack.func_179546_a((EntityPlayer)fake, world, pos, hand, facing, hitX, hitY, hitZ);
            if (result != EnumActionResult.SUCCESS) {
                BagHelper.addStack(placementStack, bag, player);
            } else {
                player.func_184609_a(hand);
            }
            BuildersBag.network.sendTo((IMessage)new SyncBagCapClient(bag, hand), (EntityPlayerMP)player);
            BuildersBag.network.sendTo((IMessage)new SyncEnderchestToClient(player), (EntityPlayerMP)player);
            return result;
        }
        return EnumActionResult.SUCCESS;
    }

    public boolean shouldCauseReequipAnimation(ItemStack oldStack, ItemStack newStack, boolean slotChanged) {
        return slotChanged;
    }

    public int getTier() {
        return this.tier;
    }

    @Optional.Method(modid="littletiles")
    public void requestIngredients(ItemStack stack, LittleIngredients ingredients, @Nonnull LittleIngredients overflow, LittleInventory inventory) {
        IBagCap bag = CapHelper.getBagCap(stack);
        if (bag.hasModuleAndEnabled("buildersbag:littletiles")) {
            LittleTilesModule.provideLittleIngredients(stack, ingredients, overflow, inventory.getPlayer(), inventory);
        }
    }

    @Optional.Method(modid="littletiles")
    public LittleIngredients getInventory(ItemStack stack) {
        return new LittleIngredients();
    }

    @Optional.Method(modid="littletiles")
    public void setInventory(ItemStack stack, LittleIngredients ing, LittleInventory inv) {
        IBagCap bag;
        if (stack.func_77973_b() instanceof BuildersBagItem && !inv.isSimulation() && (bag = CapHelper.getBagCap(stack)).hasModuleAndEnabled("buildersbag:littletiles")) {
            LittleTilesModule.addIngredients(stack, ing, inv.getPlayer());
        }
    }

    @Optional.Method(modid="littletiles")
    public void collect(HashMapList<String, ItemStack> list, ItemStack stack, EntityPlayer player) {
        IBagCap bag;
        if (stack.func_77973_b() instanceof BuildersBagItem && (bag = CapHelper.getBagCap(stack)).hasModuleAndEnabled("buildersbag:littletiles")) {
            LittleTilesModule.setAvailableIngredients(list, stack, bag, player);
        }
    }

    @Optional.Method(modid="botania")
    public boolean provideBlock(EntityPlayer player, ItemStack requestor, ItemStack stack, Block block, int meta, boolean doit) {
        return BotaniaCompat.provideBlock(player, requestor, stack, block, meta, doit);
    }

    @Optional.Method(modid="botania")
    public int getBlockCount(EntityPlayer player, ItemStack requestor, ItemStack stack, Block block, int meta) {
        return BotaniaCompat.getBlockCount(player, requestor, stack, block, meta);
    }

    @Optional.Method(modid="baubles")
    public BaubleType getBaubleType(ItemStack itemstack) {
        return BaubleType.BELT;
    }

    @Optional.Method(modid="baubles")
    public void onEquipped(ItemStack itemstack, EntityLivingBase player) {
        IBagCap cap = CapHelper.getBagCap(itemstack);
        if (!player.field_70170_p.field_72995_K) {
            BuildersBag.network.sendTo((IMessage)new SyncBagCapInventoryClient(cap, 3, true), (EntityPlayerMP)player);
        }
    }
}

