/*
 * Decompiled with CFR 0.152.
 */
package tschipp.buildersbag.common.modules;

import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Random;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.entity.player.EntityPlayerMP;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTBase;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.util.NonNullList;
import net.minecraftforge.items.ItemStackHandler;
import team.chisel.api.IChiselItem;
import team.chisel.api.carving.CarvingUtils;
import team.chisel.api.carving.ICarvingGroup;
import team.chisel.api.carving.ICarvingVariation;
import tschipp.buildersbag.api.AbstractBagModule;
import tschipp.buildersbag.api.IBagCap;
import tschipp.buildersbag.common.helper.BagHelper;
import tschipp.buildersbag.common.helper.InventoryHelper;
import tschipp.buildersbag.common.helper.ItemHelper;
import tschipp.buildersbag.common.inventory.ItemHandlerWithPredicate;

public class ChiselModule
extends AbstractBagModule {
    private ItemHandlerWithPredicate handler = new ItemHandlerWithPredicate(1, (stack, slot) -> stack.func_77973_b() instanceof IChiselItem);
    private static final ItemStack DISPLAY = new ItemStack(Item.func_111206_d((String)"chisel:chisel_iron"));

    public ChiselModule() {
        super("buildersbag:chisel");
    }

    @Override
    public NonNullList<ItemStack> getPossibleStacks(IBagCap bag, EntityPlayer player) {
        NonNullList<ItemStack> providedSacks = BagHelper.getAllAvailableStacksExcept(bag, player, this);
        NonNullList list = NonNullList.func_191196_a();
        ItemStack chisel = this.handler.getStackInSlot(0);
        if (chisel.func_190926_b() || !ChiselModule.validTinkersChisel(chisel)) {
            return list;
        }
        HashSet<ICarvingGroup> groups = new HashSet<ICarvingGroup>();
        for (ItemStack stack : providedSacks) {
            ICarvingGroup group;
            if (stack.func_190926_b() || (group = CarvingUtils.getChiselRegistry().getGroup(stack)) == null) continue;
            groups.add(group);
        }
        for (ICarvingGroup group : groups) {
            for (ICarvingVariation variation : group) {
                list.add((Object)variation.getStack());
            }
        }
        return list;
    }

    @Override
    public ItemStackHandler getInventory() {
        return this.handler;
    }

    @Override
    public NBTTagCompound serializeNBT() {
        NBTTagCompound tag = super.serializeNBT();
        tag.func_74782_a("Inventory", (NBTBase)this.handler.serializeNBT());
        return tag;
    }

    @Override
    public void deserializeNBT(NBTTagCompound nbt) {
        super.deserializeNBT(nbt);
        this.handler.deserializeNBT(nbt.func_74775_l("Inventory"));
    }

    @Override
    public boolean doesntUseOwnInventory() {
        return false;
    }

    @Override
    public ItemStack getDisplayItem() {
        return DISPLAY;
    }

    @Override
    public NonNullList<ItemStack> createStackWithCount(ItemStack stack, int count, IBagCap bag, EntityPlayer player) {
        NonNullList list = NonNullList.func_191196_a();
        ICarvingGroup group = CarvingUtils.getChiselRegistry().getGroup(stack);
        if (group == null) {
            return list;
        }
        ItemStack chisel = this.handler.getStackInSlot(0);
        if (chisel.func_190926_b() || !ChiselModule.validTinkersChisel(chisel)) {
            return list;
        }
        NonNullList<ItemStack> availableBlocks = InventoryHelper.getInventoryStacks(bag, player);
        NonNullList providedVariants = NonNullList.func_191196_a();
        block0: for (ICarvingVariation variant : group) {
            while (providedVariants.size() < count) {
                ItemStack available = ItemStack.field_190927_a;
                available = ItemHelper.containsStack(variant.getStack(), availableBlocks);
                if (available.func_190926_b()) continue block0;
                available.func_190918_g(1);
                providedVariants.add((Object)available);
            }
        }
        for (ICarvingVariation variant : group) {
            if (providedVariants.size() >= count) continue;
            NonNullList<ItemStack> provided = BagHelper.getOrProvideStackWithCount(variant.getStack(), count - providedVariants.size(), bag, player, this);
            providedVariants.addAll(provided);
        }
        if (!providedVariants.isEmpty()) {
            if (!player.field_70170_p.field_72995_K) {
                for (int i = 0; i < providedVariants.size(); ++i) {
                    if (!ChiselModule.validTinkersChisel(chisel) || chisel.func_96631_a(1, new Random(), (EntityPlayerMP)player)) {
                        list.add((Object)stack.func_77946_l());
                        if (!chisel.func_77973_b().getRegistryName().toString().equals("tcomplement:chisel")) {
                            chisel.func_190918_g(1);
                        }
                        for (int j = i; j < providedVariants.size(); ++j) {
                            BagHelper.addStack((ItemStack)providedVariants.get(j), bag, player);
                        }
                        break;
                    }
                    list.add((Object)stack.func_77946_l());
                }
            }
            return list;
        }
        return NonNullList.func_191196_a();
    }

    @Override
    public NonNullList<ItemStack> getCompactedStacks(NonNullList<ItemStack> toCompact, EntityPlayer player) {
        if (!this.isEnabled()) {
            return toCompact;
        }
        ItemStack chisel = this.handler.getStackInSlot(0);
        if (chisel.func_190926_b() || !ChiselModule.validTinkersChisel(chisel)) {
            return toCompact;
        }
        NonNullList compacted = NonNullList.func_191196_a();
        HashMap variations = new HashMap();
        for (ItemStack stack : toCompact) {
            ICarvingVariation vari = CarvingUtils.getChiselRegistry().getVariation(stack);
            ICarvingGroup group = CarvingUtils.getChiselRegistry().getGroup(stack);
            if (vari == null) {
                compacted.add((Object)stack);
                continue;
            }
            if (variations.get(group) != null) {
                if (((Map)variations.get(group)).get(vari) != null) {
                    ((Map)variations.get(group)).put(vari, (Integer)((Map)variations.get(group)).get(vari) + stack.func_190916_E());
                    continue;
                }
                ((Map)variations.get(group)).put(vari, stack.func_190916_E());
                continue;
            }
            HashMap<ICarvingVariation, Integer> map = new HashMap<ICarvingVariation, Integer>();
            map.put(vari, stack.func_190916_E());
            variations.put(group, map);
        }
        for (Map.Entry entry : variations.entrySet()) {
            Map map = (Map)entry.getValue();
            ICarvingVariation maxVari = null;
            int maxCount = 0;
            int totalCount = 0;
            for (Map.Entry mapEntry : map.entrySet()) {
                if ((Integer)mapEntry.getValue() > maxCount) {
                    maxCount = (Integer)mapEntry.getValue();
                    maxVari = (ICarvingVariation)mapEntry.getKey();
                }
                totalCount += ((Integer)mapEntry.getValue()).intValue();
            }
            int usedBlocks = 0;
            boolean chiselEmpty = false;
            if (maxVari == null || totalCount <= 0) continue;
            int stackCount = totalCount / 64;
            for (int i = 0; i < stackCount; ++i) {
                if (!chisel.func_190926_b() && ChiselModule.validTinkersChisel(chisel)) {
                    ItemStack s = maxVari.getStack();
                    s.func_190920_e(64);
                    compacted.add((Object)s);
                    if (!player.field_70170_p.field_72995_K && chisel.func_96631_a(1, new Random(), (EntityPlayerMP)player)) {
                        chisel.func_190918_g(1);
                    }
                    usedBlocks += 64;
                    continue;
                }
                chiselEmpty = true;
            }
            if (!chisel.func_190926_b() && ChiselModule.validTinkersChisel(chisel)) {
                ItemStack s = maxVari.getStack();
                s.func_190920_e(totalCount % 64);
                if (!s.func_190926_b()) {
                    compacted.add((Object)s);
                    usedBlocks += s.func_190916_E();
                    if (!player.field_70170_p.field_72995_K && chisel.func_96631_a(1, new Random(), (EntityPlayerMP)player)) {
                        chisel.func_190918_g(1);
                    }
                }
            } else {
                chiselEmpty = true;
            }
            if (!chiselEmpty) continue;
            for (Map.Entry mapEntry : map.entrySet()) {
                int amount = (Integer)mapEntry.getValue();
                if (amount <= usedBlocks) {
                    mapEntry.setValue(0);
                    usedBlocks -= amount;
                    continue;
                }
                mapEntry.setValue(amount - usedBlocks);
                usedBlocks = 0;
                int leftoverStackCountCount = (amount -= usedBlocks) / 64;
                for (int i = 0; i < leftoverStackCountCount; ++i) {
                    ItemStack s = ((ICarvingVariation)mapEntry.getKey()).getStack();
                    s.func_190920_e(64);
                    compacted.add((Object)s);
                }
                ItemStack s = ((ICarvingVariation)mapEntry.getKey()).getStack();
                s.func_190920_e(amount % 64);
                if (s.func_190926_b()) continue;
                compacted.add((Object)s);
            }
        }
        return compacted;
    }

    public static boolean validTinkersChisel(ItemStack stack) {
        if (stack.func_77973_b().getRegistryName().toString().equals("tcomplement:chisel")) {
            return stack.func_77952_i() != stack.func_77958_k();
        }
        return true;
    }
}

