/*
 * Decompiled with CFR 0.152.
 */
package tschipp.buildersbag.common.modules;

import java.lang.reflect.Field;
import java.util.List;
import java.util.Random;
import mod.chiselsandbits.chiseledblock.TileEntityBlockChiseled;
import mod.chiselsandbits.chiseledblock.data.BitLocation;
import mod.chiselsandbits.chiseledblock.data.VoxelBlob;
import mod.chiselsandbits.chiseledblock.iterators.ChiselIterator;
import mod.chiselsandbits.chiseledblock.iterators.ChiselTypeIterator;
import mod.chiselsandbits.helpers.ActingPlayer;
import mod.chiselsandbits.helpers.BitOperation;
import mod.chiselsandbits.helpers.ContinousBits;
import mod.chiselsandbits.helpers.IVoxelSrc;
import mod.chiselsandbits.helpers.ModUtil;
import mod.chiselsandbits.helpers.VoxelRegionSrc;
import mod.chiselsandbits.items.ItemBitBag;
import mod.chiselsandbits.items.ItemChisel;
import mod.chiselsandbits.items.ItemChiseledBit;
import mod.chiselsandbits.modes.ChiselMode;
import mod.chiselsandbits.network.ModPacket;
import mod.chiselsandbits.network.NetworkRouter;
import mod.chiselsandbits.network.packets.PacketChisel;
import net.minecraft.block.Block;
import net.minecraft.block.state.IBlockState;
import net.minecraft.entity.item.EntityItem;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.entity.player.EntityPlayerMP;
import net.minecraft.init.Blocks;
import net.minecraft.inventory.IInventory;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTBase;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.EnumHand;
import net.minecraft.util.NonNullList;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.IBlockAccess;
import net.minecraft.world.World;
import net.minecraftforge.fml.common.network.simpleimpl.IMessage;
import net.minecraftforge.fml.relauncher.ReflectionHelper;
import net.minecraftforge.items.ItemStackHandler;
import tschipp.buildersbag.BuildersBag;
import tschipp.buildersbag.api.AbstractBagModule;
import tschipp.buildersbag.api.IBagCap;
import tschipp.buildersbag.api.IBagModule;
import tschipp.buildersbag.common.helper.BagHelper;
import tschipp.buildersbag.common.helper.CapHelper;
import tschipp.buildersbag.common.helper.InventoryHelper;
import tschipp.buildersbag.common.inventory.ItemHandlerWithPredicate;
import tschipp.buildersbag.network.client.SetHeldItemClient;

public class ChiselsBitsModule
extends AbstractBagModule {
    private static final ItemStack DISPLAY = new ItemStack(Item.func_111206_d((String)"chiselsandbits:chisel_iron"));
    private ItemHandlerWithPredicate handler = new ItemHandlerWithPredicate(1, (stack, slot) -> stack.func_77973_b() instanceof ItemChisel);
    private static Field fromF = ReflectionHelper.findField(PacketChisel.class, (String[])new String[]{"from"});
    private static Field toF = ReflectionHelper.findField(PacketChisel.class, (String[])new String[]{"to"});
    private static Field placeF = ReflectionHelper.findField(PacketChisel.class, (String[])new String[]{"place"});
    private static Field sideF = ReflectionHelper.findField(PacketChisel.class, (String[])new String[]{"side"});
    private static Field modeF = ReflectionHelper.findField(PacketChisel.class, (String[])new String[]{"mode"});
    private static Field handF = ReflectionHelper.findField(PacketChisel.class, (String[])new String[]{"hand"});
    private static Field serverEntityF = ReflectionHelper.findField(ModPacket.class, (String[])new String[]{"serverEntity"});

    public ChiselsBitsModule() {
        super("buildersbag:chiselsandbits");
    }

    @Override
    public NonNullList<ItemStack> getPossibleStacks(IBagCap bag, EntityPlayer player) {
        return NonNullList.func_191196_a();
    }

    @Override
    public boolean doesntUseOwnInventory() {
        return false;
    }

    @Override
    public ItemStackHandler getInventory() {
        return this.handler;
    }

    @Override
    public ItemStack getDisplayItem() {
        return DISPLAY;
    }

    @Override
    public NBTTagCompound serializeNBT() {
        NBTTagCompound tag = super.serializeNBT();
        tag.func_74782_a("Inventory", (NBTBase)this.handler.serializeNBT());
        return tag;
    }

    @Override
    public void deserializeNBT(NBTTagCompound nbt) {
        super.deserializeNBT(nbt);
        this.handler.deserializeNBT(nbt.func_74775_l("Inventory"));
    }

    public static void checkAndProvideBits(PacketChisel packet, EntityPlayer player) {
        try {
            BitLocation from = (BitLocation)fromF.get(packet);
            BitLocation to = (BitLocation)toF.get(packet);
            BitOperation place = (BitOperation)placeF.get(packet);
            EnumFacing side = (EnumFacing)sideF.get(packet);
            ChiselMode mode = (ChiselMode)modeF.get(packet);
            EnumHand hand = (EnumHand)handF.get(packet);
            World world = player.field_70170_p;
            int minX = Math.min(from.blockPos.func_177958_n(), to.blockPos.func_177958_n());
            int maxX = Math.max(from.blockPos.func_177958_n(), to.blockPos.func_177958_n());
            int minY = Math.min(from.blockPos.func_177956_o(), to.blockPos.func_177956_o());
            int maxY = Math.max(from.blockPos.func_177956_o(), to.blockPos.func_177956_o());
            int minZ = Math.min(from.blockPos.func_177952_p(), to.blockPos.func_177952_p());
            int maxZ = Math.max(from.blockPos.func_177952_p(), to.blockPos.func_177952_p());
            if (!(player.func_184586_b(hand).func_77973_b() instanceof ItemChiseledBit)) {
                return;
            }
            int placeStateID = place.usesBits() ? ItemChiseledBit.getStackState((ItemStack)player.func_184586_b(hand)) : 0;
            int missingBits = 0;
            int totalBits = 0;
            int placedBits = 0;
            boolean extra = false;
            ActingPlayer acting = ActingPlayer.testingAs((EntityPlayer)player, (EnumHand)hand);
            for (int xOff = minX; xOff <= maxX; ++xOff) {
                for (int yOff = minY; yOff <= maxY; ++yOff) {
                    for (int zOff = minZ; zOff <= maxZ; ++zOff) {
                        BlockPos pos = new BlockPos(xOff, yOff, zOff);
                        VoxelBlob vb = null;
                        TileEntity te = world.func_175625_s(pos);
                        if (te != null && te instanceof TileEntityBlockChiseled) {
                            vb = ((TileEntityBlockChiseled)te).getBlob();
                        } else if (!world.func_180495_p(pos).func_177230_c().func_176200_f((IBlockAccess)world, pos)) continue;
                        ChiselIterator it = ChiselsBitsModule.getIterator(new VoxelRegionSrc(world, pos, 1), pos, place, mode, from, to, side);
                        int bitCount = 0;
                        while (it.hasNext()) {
                            if (vb != null && (vb.get(it.x(), it.y(), it.z()) != Block.func_176210_f((IBlockState)Blocks.field_150350_a.func_176223_P()) && !place.usesChisels() || vb.get(it.x(), it.y(), it.z()) == placeStateID && place.usesChisels())) continue;
                            ++bitCount;
                        }
                        ContinousBits bits = new ContinousBits(acting, pos, placeStateID);
                        int bitsLeft = bitCount;
                        for (int i = 0; i < bitCount && bits.isValid(); ++i) {
                            if (!bits.useItem(1)) continue;
                            --bitsLeft;
                            ++placedBits;
                        }
                        missingBits += bitsLeft;
                        totalBits += bitCount;
                    }
                }
            }
            boolean needsExtra = false;
            ContinousBits bits = new ContinousBits(acting, player.func_180425_c(), placeStateID);
            if (!(missingBits != 0 || bits.isValid() && bits.useItem(1))) {
                needsExtra = true;
            }
            if (missingBits > 0 || needsExtra) {
                boolean sendPacket = false;
                boolean provide = false;
                IBlockState state = Block.func_176220_d((int)placeStateID);
                int meta = state.func_177230_c().func_176201_c(state);
                ItemStack required = new ItemStack(state.func_177230_c(), 1, meta);
                double blocks = (double)missingBits / 4096.0 + (double)(needsExtra ? 1 : 0);
                int rounded = (int)Math.ceil(blocks);
                NonNullList<ItemStack> bags = InventoryHelper.getBagsInInventory(player);
                for (ItemStack bag : bags) {
                    IBagModule chiselModule;
                    ItemStackHandler inv;
                    ItemStack chisel;
                    IBagCap cap;
                    if (bag.func_190926_b() || !(cap = CapHelper.getBagCap(bag)).hasModuleAndEnabled("buildersbag:chiselsandbits") || (chisel = (inv = (chiselModule = BagHelper.getModule("buildersbag:chiselsandbits", cap)).getInventory()).getStackInSlot(0)).func_190926_b()) continue;
                    NonNullList<ItemStack> provided = BagHelper.getOrProvideStackWithCount(required, rounded, cap, player, null);
                    rounded -= provided.size();
                    if (chisel.func_96631_a(provided.size() * 16 * 16 * 16, new Random(), (EntityPlayerMP)player)) {
                        chisel.func_190918_g(1);
                    }
                    ItemStack providedBits = ItemChiseledBit.createStack((int)placeStateID, (int)(provided.size() * 16 * 16 * 16 + (needsExtra ? 0 : placedBits - 64)), (boolean)true);
                    EntityItem entityBits = new EntityItem(world, player.field_70165_t, player.field_70163_u, player.field_70161_v, providedBits);
                    List bitBags = ItemBitBag.getBags((IInventory)player.field_71071_by);
                    for (ItemBitBag.BagPos i : bitBags) {
                        ItemStack remainder = i.inv.insertItem(entityBits.func_92059_d());
                        int changed = ModUtil.getStackSize((ItemStack)providedBits) - ModUtil.getStackSize((ItemStack)entityBits.func_92059_d());
                        entityBits.func_92058_a(remainder);
                    }
                    if (provided.size() > 0) {
                        sendPacket = true;
                        provide = true;
                    }
                    if (rounded > 0) continue;
                    break;
                }
                if (sendPacket) {
                    if (provide) {
                        ItemStack providedBits = ItemChiseledBit.createStack((int)placeStateID, (int)64, (boolean)true);
                        player.func_184611_a(hand, providedBits);
                        BuildersBag.network.sendTo((IMessage)new SetHeldItemClient(providedBits, hand), (EntityPlayerMP)player);
                    }
                    player.func_184211_a("chiselPacket");
                    NetworkRouter.instance.sendToServer((ModPacket)packet);
                }
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    private static ChiselIterator getIterator(VoxelRegionSrc vb, BlockPos pos, BitOperation place, ChiselMode mode, BitLocation from, BitLocation to, EnumFacing side) {
        if (mode == ChiselMode.DRAWN_REGION) {
            int bitX = pos.func_177958_n() == from.blockPos.func_177958_n() ? from.bitX : 0;
            int bitY = pos.func_177956_o() == from.blockPos.func_177956_o() ? from.bitY : 0;
            int bitZ = pos.func_177952_p() == from.blockPos.func_177952_p() ? from.bitZ : 0;
            int scaleX = (pos.func_177958_n() == to.blockPos.func_177958_n() ? to.bitX : 15) - bitX + 1;
            int scaleY = (pos.func_177956_o() == to.blockPos.func_177956_o() ? to.bitY : 15) - bitY + 1;
            int scaleZ = (pos.func_177952_p() == to.blockPos.func_177952_p() ? to.bitZ : 15) - bitZ + 1;
            return new ChiselTypeIterator(16, bitX, bitY, bitZ, scaleX, scaleY, scaleZ, side);
        }
        return ChiselTypeIterator.create((int)16, (int)from.bitX, (int)from.bitY, (int)from.bitZ, (IVoxelSrc)vb, (ChiselMode)mode, (EnumFacing)side, (boolean)place.usePlacementOffset());
    }

    @Override
    public NonNullList<ItemStack> createStackWithCount(ItemStack stack, int count, IBagCap bag, EntityPlayer player) {
        return NonNullList.func_191196_a();
    }

    static {
        fromF.setAccessible(true);
        toF.setAccessible(true);
        placeF.setAccessible(true);
        sideF.setAccessible(true);
        modeF.setAccessible(true);
        handF.setAccessible(true);
        serverEntityF.setAccessible(true);
    }
}

