/*
 * Decompiled with CFR 0.152.
 */
package tschipp.buildersbag.common.modules;

import java.util.HashMap;
import java.util.Map;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.init.Blocks;
import net.minecraft.item.ItemStack;
import net.minecraft.item.crafting.Ingredient;
import net.minecraft.util.NonNullList;
import net.minecraftforge.items.ItemStackHandler;
import tschipp.buildersbag.api.AbstractBagModule;
import tschipp.buildersbag.api.IBagCap;
import tschipp.buildersbag.api.ModulePriority;
import tschipp.buildersbag.common.crafting.CraftingHandler;
import tschipp.buildersbag.common.crafting.RecipeContainer;
import tschipp.buildersbag.common.crafting.RecipeRequirementList;
import tschipp.buildersbag.common.crafting.RecipeTreeNew;
import tschipp.buildersbag.common.data.Tuple;
import tschipp.buildersbag.common.helper.BagHelper;
import tschipp.buildersbag.common.helper.InventoryHelper;
import tschipp.buildersbag.common.helper.ItemHelper;

public class CraftingModule
extends AbstractBagModule {
    private static final ItemStack DISPLAY = new ItemStack(Blocks.field_150462_ai);

    public CraftingModule() {
        super("buildersbag:crafting");
    }

    @Override
    public NonNullList<ItemStack> getPossibleStacks(IBagCap bag, EntityPlayer player) {
        return CraftingHandler.getPossibleBlocks(InventoryHelper.getInventoryStacks(bag, player), true);
    }

    @Override
    public ItemStackHandler getInventory() {
        return null;
    }

    @Override
    public boolean doesntUseOwnInventory() {
        return true;
    }

    @Override
    public ItemStack getDisplayItem() {
        return DISPLAY;
    }

    public NonNullList<ItemStack> createStackWithRecipeTree(ItemStack stack, int count, IBagCap bag, EntityPlayer player, @Nullable RecipeTreeNew subTree, @Nonnull ItemStack root) {
        if (subTree == null) {
            subTree = CraftingHandler.getSubTree(InventoryHelper.getInventoryStacks(bag, player));
        }
        if (root.func_190926_b()) {
            root = stack;
        }
        BagHelper.updateTreeCache(subTree, root);
        NonNullList<ItemStack> possibleStacks = subTree.getPossibleStacks(false);
        boolean isPossible = false;
        for (ItemStack possible : possibleStacks) {
            if (!ItemStack.func_179545_c((ItemStack)possible, (ItemStack)stack)) continue;
            isPossible = true;
        }
        if (!isPossible) {
            return NonNullList.func_191196_a();
        }
        NonNullList list = NonNullList.func_191196_a();
        RecipeRequirementList recipeList = subTree.generateRequirementList(stack, null, player, bag);
        int attempt = 0;
        while (attempt < 10 && recipeList != null && list.size() < count) {
            ++attempt;
            RecipeRequirementList.CraftingOrderList craftingList = recipeList.generateCraftingOrderList(count, player, bag);
            NonNullList providedRecipeIngredients = NonNullList.func_191196_a();
            while (craftingList.hasNext()) {
                String[] split;
                Tuple<RecipeContainer, Integer> entry = craftingList.getNextRecipe();
                RecipeContainer recipe = entry.getFirst();
                int totalCraftAmount = entry.getSecond();
                HashMap<String, Integer> ingredientAmount = new HashMap<String, Integer>();
                for (Ingredient ing : recipe.getIngredients()) {
                    if (ing.func_193365_a().length == 0) continue;
                    String ingStr = CraftingHandler.getIngredientString(ing);
                    Integer i = (Integer)ingredientAmount.get(ingStr);
                    if (i == null) {
                        i = 0;
                    }
                    i = i + totalCraftAmount;
                    ingredientAmount.put(ingStr, i);
                }
                block4: for (Map.Entry ingEntry : ingredientAmount.entrySet()) {
                    int amountNeeded = (Integer)ingEntry.getValue();
                    for (String s : split = ((String)ingEntry.getKey()).split(";")) {
                        ItemStack providedStack;
                        ItemStack matchingStack = CraftingHandler.getItemFromString(s + ";");
                        if (matchingStack.func_190926_b()) continue;
                        if (amountNeeded <= 0) continue block4;
                        int x = amountNeeded;
                        NonNullList<ItemStack> providedCopy = ItemHelper.copy((NonNullList<ItemStack>)providedRecipeIngredients);
                        for (int i = 0; i < x && !(providedStack = ItemHelper.containsStack(matchingStack, providedCopy)).func_190926_b(); ++i) {
                            providedCopy.remove((Object)providedStack);
                            --amountNeeded;
                        }
                        if (amountNeeded <= 0) continue block4;
                        NonNullList<ItemStack> provided = BagHelper.getOrProvideStackWithTree(matchingStack, amountNeeded, bag, player, this, subTree, root);
                        amountNeeded -= provided.size();
                        providedRecipeIngredients.addAll(provided);
                    }
                }
                for (int i = 0; i < totalCraftAmount; ++i) {
                    boolean hasRecipeRequirements = true;
                    NonNullList removedIngredients = NonNullList.func_191196_a();
                    split = ingredientAmount.entrySet().iterator();
                    while (split.hasNext()) {
                        String[] split2;
                        Map.Entry ingEntry = (Map.Entry)split.next();
                        int amountNeeded = (Integer)ingEntry.getValue() / totalCraftAmount;
                        boolean hasIng = false;
                        block9: for (String s : split2 = ((String)ingEntry.getKey()).split(";")) {
                            ItemStack matchingStack = CraftingHandler.getItemFromString(s + ";");
                            if (matchingStack.func_190926_b()) continue;
                            int x = amountNeeded;
                            for (int j = 0; j < x; ++j) {
                                ItemStack provided = ItemHelper.containsStack(matchingStack, (NonNullList<ItemStack>)providedRecipeIngredients);
                                if (provided.func_190926_b()) continue;
                                providedRecipeIngredients.remove((Object)provided);
                                removedIngredients.add((Object)provided);
                                if (--amountNeeded > 0) continue;
                                hasIng = true;
                                break block9;
                            }
                        }
                        if (hasIng) continue;
                        hasRecipeRequirements = false;
                    }
                    if (hasRecipeRequirements) {
                        ItemStack out = recipe.getOutput();
                        int outcount = out.func_190916_E();
                        out.func_190920_e(1);
                        if (ItemStack.func_179545_c((ItemStack)recipe.getOutput(), (ItemStack)root)) {
                            list.addAll(ItemHelper.listOf(out, outcount));
                            continue;
                        }
                        providedRecipeIngredients.addAll(ItemHelper.listOf(out, outcount));
                        continue;
                    }
                    for (ItemStack s : removedIngredients) {
                        BagHelper.addStack(s, bag, player);
                    }
                    recipeList.blacklist(recipe);
                }
            }
            if (!providedRecipeIngredients.isEmpty()) {
                for (ItemStack s : providedRecipeIngredients) {
                    BagHelper.addStack(s, bag, player);
                }
            }
            recipeList = subTree.generateRequirementList(stack, null, player, bag);
        }
        while (list.size() > count) {
            BagHelper.addStack((ItemStack)list.remove(list.size() - 1), bag, player);
        }
        return list;
    }

    @Override
    public ModulePriority getPriority() {
        return ModulePriority.LOW;
    }

    @Override
    public NonNullList<ItemStack> createStackWithCount(ItemStack stack, int count, IBagCap bag, EntityPlayer player) {
        return this.createStackWithRecipeTree(stack, count, bag, player, null, ItemStack.field_190927_a);
    }
}

