/*
 * Decompiled with CFR 0.152.
 */
package tschipp.buildersbag.common.modules;

import com.creativemd.creativecore.common.utils.mc.BlockUtils;
import com.creativemd.creativecore.common.utils.type.HashMapList;
import com.creativemd.littletiles.LittleTiles;
import com.creativemd.littletiles.common.action.LittleAction;
import com.creativemd.littletiles.common.item.ItemBlockIngredient;
import com.creativemd.littletiles.common.util.grid.LittleGridContext;
import com.creativemd.littletiles.common.util.ingredient.BlockIngredient;
import com.creativemd.littletiles.common.util.ingredient.BlockIngredientEntry;
import com.creativemd.littletiles.common.util.ingredient.IngredientUtils;
import com.creativemd.littletiles.common.util.ingredient.LittleIngredient;
import com.creativemd.littletiles.common.util.ingredient.LittleIngredients;
import com.creativemd.littletiles.common.util.ingredient.LittleInventory;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;
import net.minecraft.block.Block;
import net.minecraft.block.state.IBlockState;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.entity.player.EntityPlayerMP;
import net.minecraft.item.Item;
import net.minecraft.item.ItemBlock;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.util.NonNullList;
import net.minecraft.util.text.translation.I18n;
import net.minecraftforge.fml.common.Optional;
import net.minecraftforge.fml.common.network.simpleimpl.IMessage;
import net.minecraftforge.items.IItemHandler;
import net.minecraftforge.items.ItemStackHandler;
import tschipp.buildersbag.BuildersBag;
import tschipp.buildersbag.api.AbstractBagModule;
import tschipp.buildersbag.api.IBagCap;
import tschipp.buildersbag.common.data.ItemContainer;
import tschipp.buildersbag.common.helper.BagHelper;
import tschipp.buildersbag.common.helper.CapHelper;
import tschipp.buildersbag.common.helper.InventoryHelper;
import tschipp.buildersbag.common.helper.ItemHelper;
import tschipp.buildersbag.compat.littletiles.NonModifiableLittleIngredients;
import tschipp.buildersbag.network.client.SyncBagCapInventoryClient;

public class LittleTilesModule
extends AbstractBagModule {
    private static final ItemStack DISPLAY = new ItemStack(Item.func_111206_d((String)"littletiles:chisel"));

    public LittleTilesModule() {
        super("buildersbag:littletiles");
    }

    @Override
    public NonNullList<ItemStack> getPossibleStacks(IBagCap bag, EntityPlayer player) {
        return NonNullList.func_191196_a();
    }

    @Override
    public boolean doesntUseOwnInventory() {
        return true;
    }

    @Override
    public ItemStackHandler getInventory() {
        return null;
    }

    @Override
    public ItemStack getDisplayItem() {
        return DISPLAY;
    }

    @Optional.Method(modid="littletiles")
    public static strictfp void provideLittleIngredients(ItemStack stack, LittleIngredients ingredients, LittleIngredients overflow, EntityPlayer player, LittleInventory inventory) {
        BlockIngredient overflowBlk = new BlockIngredient();
        IBagCap bag = CapHelper.getBagCap(stack);
        ArrayList<BlockIngredient> toSub = new ArrayList<BlockIngredient>();
        for (LittleIngredient ing : ingredients) {
            if (ing instanceof BlockIngredient) {
                BlockIngredient blockIng = (BlockIngredient)ing;
                block1: for (BlockIngredientEntry entry : blockIng) {
                    BlockIngredient subIng;
                    ItemStack blockStack = entry.getItemStack();
                    Block block = entry.block;
                    int meta = entry.meta;
                    int req = (int)Math.ceil(entry.value);
                    NonNullList<ItemStack> inv = InventoryHelper.getStacks((IItemHandler)bag.getBlockInventory());
                    for (ItemStack invStack : inv) {
                        BlockIngredientEntry invBlockIng;
                        if (!(invStack.func_77973_b() instanceof ItemBlockIngredient) || (invBlockIng = ItemBlockIngredient.loadIngredient((ItemStack)invStack)) == null || entry.block != invBlockIng.block || entry.meta != invBlockIng.meta) continue;
                        if (entry.value <= invBlockIng.value) {
                            BlockIngredient toSub1 = new BlockIngredient();
                            toSub1.add(entry);
                            toSub.add(toSub1);
                            if (!player.field_70170_p.field_72995_K && !inventory.isSimulation()) {
                                invBlockIng.value -= entry.value;
                                ItemBlockIngredient.saveIngredient((ItemStack)invStack, (BlockIngredientEntry)invBlockIng);
                            }
                            if (!(invBlockIng.value <= 0.0)) continue block1;
                            invStack.func_190918_g(1);
                            continue block1;
                        }
                        if (!player.field_70170_p.field_72995_K && !inventory.isSimulation()) {
                            blockIng.sub(invBlockIng);
                        }
                        invStack.func_190918_g(1);
                    }
                    NonNullList<ItemStack> providedBlocks = BagHelper.getOrProvideStackWithCount(blockStack, req, CapHelper.getBagCap(stack), player, null);
                    double leftover = entry.value - (double)providedBlocks.size();
                    if (leftover > 0.0) {
                        overflowBlk.add(IngredientUtils.getBlockIngredient((Block)block, (int)meta, (double)(entry.value - (double)providedBlocks.size())));
                        subIng = new BlockIngredient();
                        subIng.add(IngredientUtils.getBlockIngredient((Block)block, (int)meta, (double)providedBlocks.size()));
                        toSub.add(subIng);
                        continue;
                    }
                    if (leftover < 0.0) {
                        BlockIngredientEntry toAdd = IngredientUtils.getBlockIngredient((Block)block, (int)meta, (double)(1.0 - entry.value % 1.0));
                        LittleTilesModule.insertIngredientsIntoBag(stack, player, toAdd);
                    }
                    subIng = new BlockIngredient();
                    subIng.add(entry);
                    toSub.add(subIng);
                }
                continue;
            }
            overflow.add(ing);
        }
        for (LittleIngredient sub : toSub) {
            ingredients.sub(sub);
        }
        if (!overflowBlk.isEmpty()) {
            overflow.add((LittleIngredient)overflowBlk);
        }
    }

    public static LittleIngredients getAvailableIngredients(ItemStack bag) {
        NonModifiableLittleIngredients existingIng = new NonModifiableLittleIngredients();
        existingIng.setModifiable(true);
        NonNullList<ItemStack> allAvailable = BagHelper.getAllAvailableStacks(CapHelper.getBagCap(bag), null);
        BlockIngredient blIng = new BlockIngredient();
        for (ItemStack available : allAvailable) {
            LittleIngredients av;
            if (available.func_77973_b() instanceof ItemBlock) {
                if (!LittleAction.isBlockValid((IBlockState)BlockUtils.getState((ItemStack)available))) continue;
                blIng.add(IngredientUtils.getBlockIngredient((Block)Block.func_149634_a((Item)available.func_77973_b()), (int)available.func_77960_j(), (double)1.0));
                continue;
            }
            if (!(available.func_77973_b() instanceof ItemBlockIngredient) || (av = ((ItemBlockIngredient)available.func_77973_b()).getInventory(available)) == null) continue;
            av = av.copy();
            existingIng.add(av);
        }
        NonModifiableLittleIngredients ing = new NonModifiableLittleIngredients();
        ing.setModifiable(true);
        ing.add((LittleIngredient)blIng);
        ing.add(existingIng);
        Iterator iterator = ing.iterator();
        while (iterator.hasNext()) {
            LittleIngredient aving = (LittleIngredient)iterator.next();
            if (!(aving instanceof BlockIngredient)) continue;
            for (BlockIngredientEntry aventr : (BlockIngredient)aving) {
                aventr.value = LittleGridContext.get().pixelSize / 512.0;
            }
        }
        ing.setModifiable(false);
        return ing;
    }

    public static void setAvailableIngredients(HashMapList<String, ItemStack> list, ItemStack bag, IBagCap bagCap, EntityPlayer player) {
        NonNullList<ItemStack> allAvailable = BagHelper.getAllAvailableStacks(CapHelper.getBagCap(bag), player);
        HashMap<ItemContainer, Double> amounts = new HashMap<ItemContainer, Double>();
        for (ItemStack stack : allAvailable) {
            if (stack.func_77973_b() instanceof ItemBlockIngredient) {
                BlockIngredientEntry entry = ItemBlockIngredient.loadIngredient((ItemStack)stack);
                ItemContainer cont = ItemContainer.forStack(new ItemStack(entry.block, 1, entry.meta));
                Double amount = (Double)amounts.get(cont);
                if (amount == null) {
                    amount = 0.0;
                }
                amount = amount + entry.value;
                amounts.put(cont, amount);
                continue;
            }
            if (!LittleAction.isBlockValid((IBlockState)BlockUtils.getState((ItemStack)stack))) continue;
            ItemContainer cont = ItemContainer.forStack(stack);
            Double amount = (Double)amounts.get(cont);
            if (amount == null) {
                amount = 0.0;
            }
            amount = amount + (double)stack.func_190916_E();
            amounts.put(cont, amount);
        }
        for (Map.Entry entry : amounts.entrySet()) {
            ItemStack stack = ((ItemContainer)entry.getKey()).getItem();
            stack.func_190920_e(1);
            double amount = (Double)entry.getValue();
            if (amount == 1.0) {
                ItemHelper.addLore(stack, I18n.func_74838_a((String)"buildersbag.bagprovides"));
            } else {
                ItemHelper.addLore(stack, BlockIngredient.printVolume((double)amount, (boolean)false));
            }
            list.add((Object)I18n.func_74838_a((String)"buildersbag.name"), (Object)stack);
        }
    }

    public static strictfp void addIngredients(ItemStack stack, LittleIngredients ing, EntityPlayer player) {
        for (LittleIngredient i : ing) {
            if (!(i instanceof BlockIngredient)) continue;
            for (BlockIngredientEntry entry : (BlockIngredient)i) {
                if (!(entry.value >= LittleGridContext.get().pixelSize)) continue;
                entry.value = -(LittleGridContext.get().pixelSize / 512.0) + entry.value;
                LittleTilesModule.insertIngredientsIntoBag(stack, player, entry);
            }
        }
        if (!player.field_70170_p.field_72995_K) {
            BuildersBag.network.sendTo((IMessage)new SyncBagCapInventoryClient(stack, player), (EntityPlayerMP)player);
        }
    }

    private static void insertIngredientsIntoBag(ItemStack stack, EntityPlayer player, BlockIngredientEntry ing) {
        IBagCap bag = CapHelper.getBagCap(stack);
        NonNullList<ItemStack> inventory = InventoryHelper.getStacks((IItemHandler)bag.getBlockInventory());
        ItemStack tileItemStack = ItemStack.field_190927_a;
        boolean newStack = true;
        for (ItemStack invStack : inventory) {
            if (invStack.func_190926_b() || !(invStack.func_77973_b() instanceof ItemBlockIngredient)) continue;
            BlockIngredientEntry loadedIngredient = ItemBlockIngredient.loadIngredient((ItemStack)invStack);
            if (loadedIngredient.block != ing.block || loadedIngredient.meta != ing.meta) continue;
            tileItemStack = invStack;
            loadedIngredient.value += ing.value;
            ing = loadedIngredient;
            newStack = false;
            break;
        }
        if (tileItemStack.func_190926_b()) {
            tileItemStack = new ItemStack(LittleTiles.blockIngredient);
        }
        tileItemStack.func_77982_d(new NBTTagCompound());
        ItemBlockIngredient.saveIngredient((ItemStack)tileItemStack, (BlockIngredientEntry)ing);
        BlockIngredientEntry entry = ItemBlockIngredient.loadIngredient((ItemStack)tileItemStack);
        if (entry.value >= 1.0) {
            int fullblocks = (int)entry.value;
            BagHelper.addStack(new ItemStack(entry.block, fullblocks, entry.meta), bag, player);
            entry.value -= (double)fullblocks;
            if (entry.value <= 0.0) {
                tileItemStack.func_190918_g(1);
                newStack = false;
            } else {
                ItemBlockIngredient.saveIngredient((ItemStack)tileItemStack, (BlockIngredientEntry)entry);
            }
        }
        if (newStack) {
            BagHelper.addStack(tileItemStack, bag, player);
        }
    }

    @Override
    public NonNullList<ItemStack> getCompactedStacks(NonNullList<ItemStack> toCompact, EntityPlayer player) {
        if (!this.isEnabled()) {
            return toCompact;
        }
        NonNullList stacks = NonNullList.func_191196_a();
        BlockIngredient ing = new BlockIngredient();
        for (ItemStack s : toCompact) {
            if (s.func_77973_b() instanceof ItemBlockIngredient) {
                ing.add(ItemBlockIngredient.loadIngredient((ItemStack)s));
                continue;
            }
            stacks.add((Object)s);
        }
        for (BlockIngredientEntry entry : ing) {
            ItemStack ingStack = new ItemStack(LittleTiles.blockIngredient);
            ingStack.func_77982_d(new NBTTagCompound());
            ItemBlockIngredient.saveIngredient((ItemStack)ingStack, (BlockIngredientEntry)entry);
            stacks.add((Object)ingStack);
        }
        return stacks;
    }

    @Override
    public NonNullList<ItemStack> createStackWithCount(ItemStack stack, int count, IBagCap bag, EntityPlayer player) {
        return NonNullList.func_191196_a();
    }
}

