/*
 * Decompiled with CFR 0.152.
 */
package tschipp.buildersbag.compat.bbw;

import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.entity.player.EntityPlayerMP;
import net.minecraft.item.ItemStack;
import net.minecraft.util.NonNullList;
import net.minecraftforge.fml.common.network.simpleimpl.IMessage;
import portablejim.bbw.api.IContainerHandler;
import tschipp.buildersbag.BuildersBag;
import tschipp.buildersbag.api.IBagCap;
import tschipp.buildersbag.common.cache.BagCache;
import tschipp.buildersbag.common.helper.BagHelper;
import tschipp.buildersbag.common.helper.CapHelper;
import tschipp.buildersbag.common.helper.InventoryHelper;
import tschipp.buildersbag.common.item.BuildersBagItem;
import tschipp.buildersbag.network.client.SyncBagCapInventoryClient;

public class ContainerHandlerBuildersBag
implements IContainerHandler {
    private ItemStack lastFailureStack = ItemStack.field_190927_a;
    private boolean hasFailed = false;
    private long lastFailureTime = 0L;

    public int countItems(EntityPlayer player, ItemStack stack, ItemStack inventoryStack) {
        IBagCap bag = CapHelper.getBagCap(inventoryStack);
        NonNullList<ItemStack> provided = null;
        long time = System.currentTimeMillis();
        if (!player.field_70170_p.field_72995_K) {
            return 500;
        }
        BagCache.startSimulation(inventoryStack);
        provided = BagHelper.getOrProvideStackWithCount(stack, 500, bag, player, null);
        BagCache.stopSimulation(inventoryStack);
        return provided.size();
    }

    public boolean matches(EntityPlayer player, ItemStack stack, ItemStack inventoryStack) {
        IBagCap bag;
        return inventoryStack.func_77973_b() instanceof BuildersBagItem && (bag = CapHelper.getBagCap(inventoryStack)).hasModuleAndEnabled("buildersbag:supplier");
    }

    public int useItems(EntityPlayer player, ItemStack stack, ItemStack inventoryStack, int count) {
        if (this.hasFailed && System.currentTimeMillis() - this.lastFailureTime <= 1000L && ItemStack.func_179545_c((ItemStack)stack, (ItemStack)this.lastFailureStack)) {
            return count;
        }
        this.hasFailed = false;
        this.lastFailureTime = 0L;
        this.lastFailureStack = ItemStack.field_190927_a;
        IBagCap bag = CapHelper.getBagCap(inventoryStack);
        NonNullList<ItemStack> provided = BagHelper.getOrProvideStackWithCount(stack, count, bag, player, null);
        BuildersBag.network.sendTo((IMessage)new SyncBagCapInventoryClient(bag, InventoryHelper.getSlotForStack(player, inventoryStack)), (EntityPlayerMP)player);
        if (provided.size() == 0) {
            this.lastFailureStack = stack;
            this.lastFailureTime = System.currentTimeMillis();
            this.hasFailed = true;
        }
        return count - provided.size();
    }
}

