/*
 * Decompiled with CFR 0.152.
 */
package tschipp.buildersbag.compat.gamestages;

import java.lang.reflect.Method;
import net.minecraft.block.state.IBlockState;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.init.Blocks;
import net.minecraft.item.ItemStack;
import net.minecraft.util.Tuple;
import net.minecraftforge.fml.common.Loader;
import net.minecraftforge.fml.relauncher.ReflectionHelper;
import tschipp.buildersbag.compat.gamestages.ItemStageHelper;
import tschipp.buildersbag.compat.gamestages.OreStageHelper;

public class StageHelper {
    private static Class<?> gameStageHelper;
    private static Class<?> iStageHelper;
    private static Method getPlayerData;
    private static Method hasStage;
    private static boolean usesNewVersion;
    private static Class<?> playerDataHandler;
    private static Class<?> iStageData;
    private static Method getStageData;
    private static Method hasUnlockedStage;

    public static String getItemStage(ItemStack stack) {
        if (Loader.isModLoaded((String)"itemstages")) {
            return ItemStageHelper.getItemStage(stack);
        }
        return "";
    }

    public static Tuple<String, IBlockState> getOreStage(IBlockState block) {
        if (Loader.isModLoaded((String)"orestages")) {
            return OreStageHelper.getOreStage(block);
        }
        return new Tuple((Object)"", (Object)Blocks.field_150350_a.func_176223_P());
    }

    public static boolean hasStage(EntityPlayer player, String stage) {
        if (Loader.isModLoaded((String)"gamestages")) {
            if (stage.isEmpty()) {
                return true;
            }
            if (usesNewVersion) {
                try {
                    Object stageData = getPlayerData.invoke(null, player);
                    boolean has = (Boolean)hasStage.invoke(stageData, stage);
                    return has;
                }
                catch (Exception e) {
                    return true;
                }
            }
            try {
                Object stageData = getStageData.invoke(null, player);
                boolean has = (Boolean)hasUnlockedStage.invoke(stageData, stage);
                return has;
            }
            catch (Exception e) {
                return true;
            }
        }
        return true;
    }

    static {
        usesNewVersion = true;
        if (Loader.isModLoaded((String)"gamestages")) {
            try {
                gameStageHelper = Class.forName("net.darkhax.gamestages.GameStageHelper");
                iStageData = Class.forName("net.darkhax.gamestages.data.IStageData");
                getPlayerData = ReflectionHelper.findMethod(gameStageHelper, (String)"getPlayerData", null, (Class[])new Class[]{EntityPlayer.class});
                hasStage = ReflectionHelper.findMethod(iStageData, (String)"hasStage", null, (Class[])new Class[]{String.class});
            }
            catch (Exception e) {
                try {
                    playerDataHandler = Class.forName("net.darkhax.gamestages.capabilities.PlayerDataHandler");
                    iStageData = Class.forName("net.darkhax.gamestages.capabilities.PlayerDataHandler$IStageData");
                    getStageData = ReflectionHelper.findMethod(playerDataHandler, (String)"getStageData", null, (Class[])new Class[]{EntityPlayer.class});
                    hasUnlockedStage = ReflectionHelper.findMethod(iStageData, (String)"hasUnlockedStage", null, (Class[])new Class[]{String.class});
                    usesNewVersion = false;
                }
                catch (Exception exception) {
                    // empty catch block
                }
            }
        }
    }
}

