/*
 * Decompiled with CFR 0.152.
 */
package tschipp.buildersbag.compat.linear;

import java.util.Random;
import net.minecraft.block.Block;
import net.minecraft.block.state.IBlockState;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.entity.item.EntityArmorStand;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.entity.player.EntityPlayerMP;
import net.minecraft.item.Item;
import net.minecraft.item.ItemBlock;
import net.minecraft.item.ItemStack;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.EnumHand;
import net.minecraft.util.NonNullList;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.RayTraceResult;
import net.minecraft.world.IBlockAccess;
import net.minecraft.world.World;
import net.minecraft.world.WorldServer;
import net.minecraftforge.common.util.FakePlayer;
import net.minecraftforge.fml.common.Mod;
import net.minecraftforge.fml.common.Optional;
import net.minecraftforge.fml.common.eventhandler.EventPriority;
import net.minecraftforge.fml.common.eventhandler.SubscribeEvent;
import net.minecraftforge.fml.common.network.simpleimpl.IMessage;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;
import tschipp.buildersbag.BuildersBag;
import tschipp.buildersbag.api.IBagCap;
import tschipp.buildersbag.api.IBagModule;
import tschipp.buildersbag.client.rendering.BagItemStackRenderer;
import tschipp.buildersbag.common.cache.BagCache;
import tschipp.buildersbag.common.helper.BagHelper;
import tschipp.buildersbag.common.helper.CapHelper;
import tschipp.buildersbag.common.helper.InventoryHelper;
import tschipp.buildersbag.common.item.BuildersBagItem;
import tschipp.buildersbag.network.client.SyncBagCapClient;
import tschipp.buildersbag.network.client.SyncBagCapInventoryClient;
import tschipp.buildersbag.network.client.SyncEnderchestToClient;
import tschipp.linear.api.LinearBlockStateEvent;
import tschipp.linear.api.LinearPlaceBlockEvent;
import tschipp.linear.api.LinearRenderBlockStateEvent;
import tschipp.linear.api.LinearRequestEvent;
import tschipp.linear.common.helper.LinearHelper;

@Mod.EventBusSubscriber(modid="buildersbag")
public class LinearEvents {
    private static int lastCount = 0;
    private static int lastRequested = 0;
    private static ItemStack lastSelected = ItemStack.field_190927_a;
    private static Random rand = new Random();

    @Optional.Method(modid="linear")
    @SubscribeEvent(priority=EventPriority.LOW)
    public static void onLinearRequest(LinearRequestEvent event) {
        ItemStack stack = event.getItemStack();
        EntityPlayer player = event.getPlayer();
        int requested = event.getRequestedBlocks();
        requested -= event.getProvidedBlocks();
        NonNullList<ItemStack> bags = InventoryHelper.getBagsInInventory(player);
        int providedBlocks = 0;
        if (player.func_184812_l_()) {
            event.setProvidedBlocks(event.getProvidedBlocks() + providedBlocks);
            return;
        }
        for (ItemStack bag : bags) {
            if (requested <= 0) break;
            if (player.field_70170_p.field_72995_K) {
                BagCache.startSimulation(bag);
            }
            IBagCap bagCap = CapHelper.getBagCap(bag);
            if (stack.func_77973_b() instanceof ItemBlock && bagCap.hasModuleAndEnabled("buildersbag:supplier")) {
                NonNullList<ItemStack> provided = BagHelper.getOrProvideStackWithCount(stack, requested + (player.field_70170_p.field_72995_K ? 1 : 0), bagCap, player, null);
                if (!provided.isEmpty()) {
                    providedBlocks += provided.size() - (player.field_70170_p.field_72995_K ? 1 : 0);
                }
                requested -= provided.size();
                if (!player.field_70170_p.field_72995_K) {
                    for (ItemStack prov : provided) {
                        BagHelper.addStack(prov, bagCap, player);
                    }
                }
            }
            if (!player.field_70170_p.field_72995_K) continue;
            BagCache.stopSimulation(bag);
        }
        if (stack.func_77973_b() instanceof BuildersBagItem) {
            IBagCap bagCap = CapHelper.getBagCap(stack);
            ItemStack placementStack = ItemStack.field_190927_a;
            for (IBagModule module : BagHelper.getSortedModules(bagCap)) {
                if (!module.isEnabled() || !module.isDominating()) continue;
                placementStack = module.getBlock(bagCap, player);
                break;
            }
            if (placementStack.func_190926_b()) {
                placementStack = bagCap.getSelectedInventory().getStackInSlot(0).func_77946_l();
            }
            if (placementStack.func_190926_b() || !(placementStack.func_77973_b() instanceof ItemBlock)) {
                return;
            }
            if (player.field_70170_p.field_72995_K) {
                BagCache.startSimulation(stack);
            }
            NonNullList<ItemStack> provided = NonNullList.func_191196_a();
            int newlyProvided = 0;
            if (bagCap.hasModuleAndEnabled("buildersbag:random")) {
                if (player.field_70170_p.field_72995_K) {
                    providedBlocks += (newlyProvided += BagHelper.getAllAvailableStacksCount(bagCap, player));
                } else {
                    provided = BagHelper.getOrProvideStackWithCountDominating(requested, bagCap, player);
                }
            } else {
                provided = BagHelper.getOrProvideStackWithCount(placementStack, requested + (player.field_70170_p.field_72995_K ? 1 : 0), bagCap, player, null);
            }
            if (!provided.isEmpty()) {
                providedBlocks += provided.size() - (player.field_70170_p.field_72995_K ? 1 : 0);
            }
            if (!player.field_70170_p.field_72995_K) {
                for (ItemStack prov : provided) {
                    BagHelper.addStack(prov, bagCap, player);
                }
            }
            requested -= provided.size() + newlyProvided;
            if (player.field_70170_p.field_72995_K) {
                BagCache.stopSimulation(stack);
            }
        }
        event.setProvidedBlocks(event.getProvidedBlocks() + providedBlocks);
    }

    @Optional.Method(modid="linear")
    @SubscribeEvent(priority=EventPriority.HIGH)
    public static void onLinearPlace(LinearPlaceBlockEvent event) {
        EntityPlayer player = event.getPlayer();
        ItemStack stack = event.getItemStack();
        World world = event.getWorld();
        BlockPos pos = event.getPos();
        EnumHand hand = LinearHelper.getHand((EntityPlayer)player);
        EnumFacing facing = LinearHelper.getFacing((EntityPlayer)player);
        float[] hit = LinearHelper.getHitCoords((EntityPlayer)player);
        NonNullList<ItemStack> bags = InventoryHelper.getBagsInInventory(player);
        if (!world.field_72995_K) {
            if (stack.func_77973_b() instanceof ItemBlock && !player.func_184812_l_()) {
                for (ItemStack bagStack : bags) {
                    IBagCap bag = CapHelper.getBagCap(bagStack);
                    if (!bag.hasModuleAndEnabled("buildersbag:supplier")) continue;
                    ItemStack result = BagHelper.getOrProvideStack(stack, bag, player, null);
                    if (!result.func_190926_b()) {
                        stack.func_190917_f(1);
                    }
                    BuildersBag.network.sendTo((IMessage)new SyncBagCapInventoryClient(bag, InventoryHelper.getSlotForStack(player, bagStack)), (EntityPlayerMP)player);
                    BuildersBag.network.sendTo((IMessage)new SyncEnderchestToClient(player), (EntityPlayerMP)player);
                    return;
                }
            } else if (stack.func_77973_b() instanceof BuildersBagItem) {
                IBagCap bag = CapHelper.getBagCap(stack);
                boolean done = false;
                int i = 0;
                while (!done && i < 15) {
                    ItemStack result;
                    ItemStack placementStack = ItemStack.field_190927_a;
                    for (IBagModule module : BagHelper.getSortedModules(bag)) {
                        if (!module.isEnabled() || !module.isDominating()) continue;
                        placementStack = module.getBlock(bag, player);
                        break;
                    }
                    ++i;
                    if (placementStack.func_190926_b()) {
                        placementStack = bag.getSelectedInventory().getStackInSlot(0).func_77946_l();
                    }
                    if (placementStack.func_190926_b() || !(placementStack.func_77973_b() instanceof ItemBlock)) {
                        return;
                    }
                    Block block = Block.func_149634_a((Item)placementStack.func_77973_b());
                    boolean canPlace = world.func_190527_a(block, world.func_180495_p(pos).func_177230_c().func_176200_f((IBlockAccess)world, pos) ? pos : pos.func_177972_a(facing), false, facing, (Entity)player);
                    boolean canEdit = player.func_175151_a(pos, facing, placementStack);
                    if (!canEdit || !canPlace || (result = player.func_184812_l_() ? placementStack.func_77946_l() : BagHelper.getOrProvideStack(placementStack, bag, player, null)).func_190926_b()) continue;
                    done = true;
                    FakePlayer fake = new FakePlayer((WorldServer)world, player.func_146103_bH());
                    fake.field_70125_A = player.field_70125_A;
                    fake.field_70177_z = player.field_70177_z;
                    fake.func_70107_b(0.0, 0.0, 0.0);
                    fake.func_184611_a(hand, result.func_77946_l());
                    fake.func_70107_b(player.field_70165_t, player.field_70163_u, player.field_70161_v);
                    result.func_179546_a((EntityPlayer)fake, world, pos, hand, facing, hit[0], hit[1], hit[2]);
                    BuildersBag.network.sendTo((IMessage)new SyncBagCapClient(bag, hand), (EntityPlayerMP)player);
                }
            }
            BuildersBag.network.sendTo((IMessage)new SyncEnderchestToClient(player), (EntityPlayerMP)player);
        }
    }

    @Optional.Method(modid="linear")
    @SubscribeEvent(priority=EventPriority.HIGH)
    public static void onlinearRequestState(LinearBlockStateEvent event) {
        EntityPlayer player = event.getPlayer();
        ItemStack stack = event.getStack();
        World world = player.field_70170_p;
        if (stack.func_77973_b() instanceof BuildersBagItem) {
            Block block;
            IBagCap bag = CapHelper.getBagCap(stack);
            ItemStack placementStack = ItemStack.field_190927_a;
            for (int i = 0; i < 10; ++i) {
                for (IBagModule module : BagHelper.getSortedModules(bag)) {
                    if (!module.isEnabled() || !module.isDominating()) continue;
                    placementStack = module.getBlock(bag, player);
                    break;
                }
                if (placementStack.func_190926_b()) {
                    placementStack = bag.getSelectedInventory().getStackInSlot(0).func_77946_l();
                }
                if (!placementStack.func_190926_b() && placementStack.func_77973_b() instanceof ItemBlock) break;
            }
            if ((block = Block.func_149634_a((Item)placementStack.func_77973_b())) != null) {
                event.setState(block.func_176203_a(placementStack.func_77960_j()));
            }
        }
    }

    @SideOnly(value=Side.CLIENT)
    @Optional.Method(modid="linear")
    @SubscribeEvent(priority=EventPriority.HIGH)
    public static void onlinearRequestClientState(LinearRenderBlockStateEvent event) {
        EntityPlayer player = event.getPlayer();
        ItemStack stack = event.getStack();
        World world = player.field_70170_p;
        EnumHand hand = event.getHand();
        if (stack.func_77973_b() instanceof BuildersBagItem) {
            RayTraceResult ray;
            IBagCap bag = CapHelper.getBagCap(stack);
            ItemStack placementStack = ItemStack.field_190927_a;
            for (int i = 0; i < 10; ++i) {
                for (IBagModule module : BagHelper.getSortedModules(bag)) {
                    if (!module.isEnabled() || !module.isDominating()) continue;
                    if (module.getName().equals("buildersbag:random")) {
                        NonNullList<ItemStack> available = BagHelper.getAllAvailableStacks(bag, player);
                        if (available.isEmpty()) break;
                        placementStack = (ItemStack)available.get(BagItemStackRenderer.listIndex % available.size());
                        break;
                    }
                    placementStack = module.getBlock(bag, player);
                    break;
                }
                if (placementStack.func_190926_b()) {
                    placementStack = bag.getSelectedInventory().getStackInSlot(0).func_77946_l();
                }
                if (!placementStack.func_190926_b() && placementStack.func_77973_b() instanceof ItemBlock) break;
            }
            if ((ray = LinearHelper.getLookRay((EntityPlayer)player)) != null) {
                Block block = Block.func_149634_a((Item)placementStack.func_77973_b());
                EntityArmorStand stand = new EntityArmorStand(world);
                stand.func_184611_a(hand, placementStack.func_77946_l());
                stand.func_70107_b(player.field_70165_t, player.field_70163_u, player.field_70161_v);
                stand.field_70125_A = player.field_70125_A;
                stand.field_70177_z = player.field_70177_z;
                float[] hit = LinearHelper.getHitCoords((EntityPlayer)player);
                IBlockState state = block.getStateForPlacement(player.field_70170_p, LinearHelper.getLookPos((EntityPlayer)player, (boolean)LinearHelper.canPlaceInMidair((EntityPlayer)player)), ray.field_178784_b, hit[0], hit[1], hit[2], placementStack.func_77960_j(), (EntityLivingBase)stand, hand);
                if (state != null) {
                    event.setState(state);
                }
            }
        }
    }
}

