/*
 * Decompiled with CFR 0.152.
 */
package tschipp.buildersbag.network.client;

import baubles.api.BaublesApi;
import io.netty.buffer.ByteBuf;
import net.minecraft.client.Minecraft;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTBase;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraftforge.fml.common.Loader;
import net.minecraftforge.fml.common.network.ByteBufUtils;
import net.minecraftforge.fml.common.network.simpleimpl.IMessage;
import net.minecraftforge.fml.common.network.simpleimpl.IMessageHandler;
import net.minecraftforge.fml.common.network.simpleimpl.MessageContext;
import tschipp.buildersbag.BuildersBag;
import tschipp.buildersbag.api.IBagCap;
import tschipp.buildersbag.common.caps.BagCapProvider;
import tschipp.buildersbag.common.data.Tuple;
import tschipp.buildersbag.common.helper.CapHelper;
import tschipp.buildersbag.common.helper.InventoryHelper;

public class SyncBagCapInventoryClient
implements IMessage,
IMessageHandler<SyncBagCapInventoryClient, IMessage> {
    private IBagCap bagCap;
    public int slot;
    public NBTTagCompound readTag;
    public boolean isBauble;

    public SyncBagCapInventoryClient(ItemStack bag, EntityPlayer player) {
        this.bagCap = CapHelper.getBagCap(bag);
        Tuple<Boolean, Integer> tup = InventoryHelper.getSlotForStackWithBaubles(player, bag);
        this.slot = tup.getSecond();
        this.isBauble = tup.getFirst();
    }

    public SyncBagCapInventoryClient() {
    }

    public SyncBagCapInventoryClient(IBagCap bagCap, int slot) {
        this(bagCap, slot, false);
    }

    public SyncBagCapInventoryClient(IBagCap bagCap, int slot, boolean isBauble) {
        this.bagCap = bagCap;
        this.slot = slot;
        this.isBauble = isBauble;
    }

    public void fromBytes(ByteBuf buf) {
        this.readTag = ByteBufUtils.readTag((ByteBuf)buf);
        this.slot = buf.readInt();
        this.isBauble = buf.readBoolean();
    }

    public void toBytes(ByteBuf buf) {
        ByteBufUtils.writeTag((ByteBuf)buf, (NBTTagCompound)((NBTTagCompound)BagCapProvider.BAG_CAPABILITY.writeNBT((Object)this.bagCap, null)));
        buf.writeInt(this.slot);
        buf.writeBoolean(this.isBauble);
    }

    public IMessage onMessage(SyncBagCapInventoryClient message, MessageContext ctx) {
        Minecraft mainThread = Minecraft.func_71410_x();
        mainThread.func_152344_a(() -> {
            EntityPlayer player = BuildersBag.proxy.getPlayer();
            if (message.slot >= 0) {
                ItemStack stack = ItemStack.field_190927_a;
                if (message.isBauble) {
                    if (Loader.isModLoaded((String)"baubles")) {
                        stack = BaublesApi.getBaubles((EntityPlayer)player).func_70301_a(message.slot);
                    }
                } else {
                    stack = player.field_71071_by.func_70301_a(message.slot);
                }
                if (!stack.func_190926_b()) {
                    IBagCap oldCap = CapHelper.getBagCap(stack);
                    BagCapProvider.BAG_CAPABILITY.readNBT((Object)oldCap, null, (NBTBase)message.readTag);
                }
            }
        });
        return null;
    }
}

