/*
 * Decompiled with CFR 0.152.
 */
package tschipp.buildersbag.network.client;

import io.netty.buffer.ByteBuf;
import net.minecraft.entity.player.EntityPlayerMP;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTBase;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.util.EnumHand;
import net.minecraft.util.IThreadListener;
import net.minecraftforge.fml.common.network.ByteBufUtils;
import net.minecraftforge.fml.common.network.simpleimpl.IMessage;
import net.minecraftforge.fml.common.network.simpleimpl.IMessageHandler;
import net.minecraftforge.fml.common.network.simpleimpl.MessageContext;
import tschipp.buildersbag.api.IBagCap;
import tschipp.buildersbag.common.caps.BagCapProvider;
import tschipp.buildersbag.common.helper.CapHelper;

public class SyncBagCapServer
implements IMessage,
IMessageHandler<SyncBagCapServer, IMessage> {
    private IBagCap bagCap;
    public boolean right;
    public NBTTagCompound readTag;

    public SyncBagCapServer() {
    }

    public SyncBagCapServer(IBagCap bagCap, EnumHand hand) {
        this.bagCap = bagCap;
        this.right = hand == EnumHand.MAIN_HAND;
    }

    public void fromBytes(ByteBuf buf) {
        this.readTag = ByteBufUtils.readTag((ByteBuf)buf);
        this.right = buf.readBoolean();
    }

    public void toBytes(ByteBuf buf) {
        ByteBufUtils.writeTag((ByteBuf)buf, (NBTTagCompound)((NBTTagCompound)BagCapProvider.BAG_CAPABILITY.writeNBT((Object)this.bagCap, null)));
        buf.writeBoolean(this.right);
    }

    public IMessage onMessage(SyncBagCapServer message, MessageContext ctx) {
        IThreadListener mainThread = (IThreadListener)ctx.getServerHandler().field_147369_b.field_70170_p;
        mainThread.func_152344_a(() -> {
            EntityPlayerMP player = ctx.getServerHandler().field_147369_b;
            ItemStack stack = message.right ? player.func_184614_ca() : player.func_184592_cb();
            IBagCap oldCap = CapHelper.getBagCap(stack);
            BagCapProvider.BAG_CAPABILITY.readNBT((Object)oldCap, null, (NBTBase)message.readTag);
        });
        return null;
    }
}

