/*
 * Decompiled with CFR 0.152.
 */
package tschipp.buildersbag.network.client;

import baubles.api.BaublesApi;
import io.netty.buffer.ByteBuf;
import net.minecraft.client.Minecraft;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.item.ItemStack;
import net.minecraftforge.fml.common.Loader;
import net.minecraftforge.fml.common.network.ByteBufUtils;
import net.minecraftforge.fml.common.network.simpleimpl.IMessage;
import net.minecraftforge.fml.common.network.simpleimpl.IMessageHandler;
import net.minecraftforge.fml.common.network.simpleimpl.MessageContext;
import tschipp.buildersbag.BuildersBag;
import tschipp.buildersbag.common.cache.BagCache;

public class UpdateCacheClient
implements IMessage,
IMessageHandler<UpdateCacheClient, IMessage> {
    private int bagSlot;
    private boolean isBauble;
    private ItemStack forStack;
    private int amount;

    @Deprecated
    public UpdateCacheClient() {
    }

    public UpdateCacheClient(int bagSlot, boolean isBauble, ItemStack forStack, int amount) {
        this.bagSlot = bagSlot;
        this.isBauble = isBauble;
        this.forStack = forStack;
        this.amount = amount;
    }

    public void fromBytes(ByteBuf buf) {
        this.bagSlot = buf.readInt();
        this.isBauble = buf.readBoolean();
        this.forStack = ByteBufUtils.readItemStack((ByteBuf)buf);
        this.amount = buf.readInt();
    }

    public void toBytes(ByteBuf buf) {
        buf.writeInt(this.bagSlot);
        buf.writeBoolean(this.isBauble);
        ByteBufUtils.writeItemStack((ByteBuf)buf, (ItemStack)this.forStack);
        buf.writeInt(this.amount);
    }

    public IMessage onMessage(UpdateCacheClient message, MessageContext ctx) {
        Minecraft mainThread = Minecraft.func_71410_x();
        mainThread.func_152344_a(() -> {
            EntityPlayer player = BuildersBag.proxy.getPlayer();
            ItemStack bag = ItemStack.field_190927_a;
            if (message.isBauble) {
                if (Loader.isModLoaded((String)"baubles")) {
                    bag = BaublesApi.getBaubles((EntityPlayer)player).func_70301_a(message.bagSlot);
                }
            } else {
                bag = player.field_71071_by.func_70301_a(message.bagSlot);
            }
            BagCache.updateCachedBagStackWithAmount(bag, player, message.forStack, message.amount);
        });
        return null;
    }
}

