/*
 * Decompiled with CFR 0.152.
 */
package tschipp.buildersbag.network.server;

import baubles.api.BaublesApi;
import io.netty.buffer.ByteBuf;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.entity.player.EntityPlayerMP;
import net.minecraft.item.ItemStack;
import net.minecraft.util.IThreadListener;
import net.minecraftforge.fml.common.Loader;
import net.minecraftforge.fml.common.network.simpleimpl.IMessage;
import net.minecraftforge.fml.common.network.simpleimpl.IMessageHandler;
import net.minecraftforge.fml.common.network.simpleimpl.MessageContext;
import tschipp.buildersbag.BuildersBag;
import tschipp.buildersbag.api.IBagCap;
import tschipp.buildersbag.common.helper.BagHelper;
import tschipp.buildersbag.common.helper.CapHelper;
import tschipp.buildersbag.network.client.SyncBagCapInventoryClient;

public class CompactBagServer
implements IMessage,
IMessageHandler<CompactBagServer, IMessage> {
    public int slot;
    public boolean isBauble;

    public CompactBagServer() {
    }

    public CompactBagServer(int slot) {
        this(slot, false);
    }

    public CompactBagServer(int slot, boolean isBauble) {
        this.slot = slot;
        this.isBauble = isBauble;
    }

    public void fromBytes(ByteBuf buf) {
        this.slot = buf.readInt();
        this.isBauble = buf.readBoolean();
    }

    public void toBytes(ByteBuf buf) {
        buf.writeInt(this.slot);
        buf.writeBoolean(this.isBauble);
    }

    public IMessage onMessage(CompactBagServer message, MessageContext ctx) {
        IThreadListener mainThread = (IThreadListener)ctx.getServerHandler().field_147369_b.field_70170_p;
        mainThread.func_152344_a(() -> {
            EntityPlayerMP player = ctx.getServerHandler().field_147369_b;
            if (message.slot >= 0) {
                ItemStack stack = ItemStack.field_190927_a;
                if (message.isBauble) {
                    if (Loader.isModLoaded((String)"baubles")) {
                        stack = BaublesApi.getBaubles((EntityPlayer)player).func_70301_a(message.slot);
                    }
                } else {
                    stack = player.field_71071_by.func_70301_a(message.slot);
                }
                if (!stack.func_190926_b()) {
                    IBagCap oldCap = CapHelper.getBagCap(stack);
                    BagHelper.compactStacks(oldCap, (EntityPlayer)player);
                    BuildersBag.network.sendTo((IMessage)new SyncBagCapInventoryClient(oldCap, message.slot, message.isBauble), player);
                }
            }
        });
        return null;
    }
}

