/*
 * Decompiled with CFR 0.152.
 */
package tschipp.buildersbag.network.server;

import baubles.api.BaublesApi;
import io.netty.buffer.ByteBuf;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.entity.player.EntityPlayerMP;
import net.minecraft.item.ItemStack;
import net.minecraft.util.IThreadListener;
import net.minecraftforge.fml.common.Loader;
import net.minecraftforge.fml.common.network.ByteBufUtils;
import net.minecraftforge.fml.common.network.simpleimpl.IMessage;
import net.minecraftforge.fml.common.network.simpleimpl.IMessageHandler;
import net.minecraftforge.fml.common.network.simpleimpl.MessageContext;
import tschipp.buildersbag.common.cache.BagCache;
import tschipp.buildersbag.common.cache.CacheUpdaterThread;
import tschipp.buildersbag.common.item.BuildersBagItem;

public class RequestCacheUpdateServer
implements IMessage,
IMessageHandler<RequestCacheUpdateServer, IMessage> {
    private static final CacheUpdaterThread thread = new CacheUpdaterThread("BuildersBag-Cache-Thread");
    private int bagSlot;
    private boolean isBauble;
    private ItemStack forStack;
    private int preferred;

    @Deprecated
    public RequestCacheUpdateServer() {
    }

    public RequestCacheUpdateServer(int bagSlot, boolean isBauble, ItemStack forStack, int preferredAmount) {
        this.bagSlot = bagSlot;
        this.isBauble = isBauble;
        this.forStack = forStack;
        this.preferred = preferredAmount;
    }

    public void fromBytes(ByteBuf buf) {
        this.bagSlot = buf.readInt();
        this.isBauble = buf.readBoolean();
        this.forStack = ByteBufUtils.readItemStack((ByteBuf)buf);
        this.preferred = buf.readInt();
    }

    public void toBytes(ByteBuf buf) {
        buf.writeInt(this.bagSlot);
        buf.writeBoolean(this.isBauble);
        ByteBufUtils.writeItemStack((ByteBuf)buf, (ItemStack)this.forStack);
        buf.writeInt(this.preferred);
    }

    public IMessage onMessage(RequestCacheUpdateServer message, MessageContext ctx) {
        IThreadListener mainThread = (IThreadListener)ctx.getServerHandler().field_147369_b.field_70170_p;
        mainThread.func_152344_a(() -> thread.enqueueRunnable(() -> {
            EntityPlayerMP player = ctx.getServerHandler().field_147369_b;
            ItemStack bag = ItemStack.field_190927_a;
            if (message.bagSlot >= 0) {
                if (message.isBauble) {
                    if (Loader.isModLoaded((String)"baubles")) {
                        bag = BaublesApi.getBaubles((EntityPlayer)player).func_70301_a(message.bagSlot);
                    }
                } else {
                    bag = player.field_71071_by.func_70301_a(message.bagSlot);
                }
            }
            if (!bag.func_190926_b() && bag.func_77973_b() instanceof BuildersBagItem) {
                int n = BagCache.updateCachedBagStack(bag, (EntityPlayer)player, message.forStack, message.preferred);
            }
        }));
        return null;
    }

    static {
        thread.start();
    }
}

