/*
 * Decompiled with CFR 0.152.
 */
package net.doubledoordev.burningtorch.blocks;

import java.util.List;
import javax.annotation.Nullable;
import net.doubledoordev.burningtorch.BurningTorchConfig;
import net.doubledoordev.burningtorch.tileentities.PumpkinTorchTE;
import net.doubledoordev.burningtorch.tileentities.TorchTE;
import net.minecraft.block.AbstractBlock;
import net.minecraft.block.Block;
import net.minecraft.block.BlockState;
import net.minecraft.block.IWaterLoggable;
import net.minecraft.entity.player.PlayerEntity;
import net.minecraft.fluid.FluidState;
import net.minecraft.fluid.Fluids;
import net.minecraft.item.BlockItemUseContext;
import net.minecraft.item.Item;
import net.minecraft.state.BooleanProperty;
import net.minecraft.state.DirectionProperty;
import net.minecraft.state.IntegerProperty;
import net.minecraft.state.Property;
import net.minecraft.state.StateContainer;
import net.minecraft.state.properties.BlockStateProperties;
import net.minecraft.tags.ITag;
import net.minecraft.tags.ItemTags;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.ActionResultType;
import net.minecraft.util.Direction;
import net.minecraft.util.Hand;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.SoundCategory;
import net.minecraft.util.SoundEvents;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.BlockRayTraceResult;
import net.minecraft.util.text.ITextComponent;
import net.minecraft.util.text.TranslationTextComponent;
import net.minecraft.world.IBlockReader;
import net.minecraft.world.IWorld;
import net.minecraft.world.IWorldReader;
import net.minecraft.world.World;

public class BurningPumpkinBlock
extends Block
implements IWaterLoggable {
    public static final DirectionProperty FACING = BlockStateProperties.field_208155_H;
    public static final BooleanProperty LIT = BlockStateProperties.field_208190_q;
    public static final BooleanProperty WATERLOGGED = BlockStateProperties.field_208198_y;
    public static final IntegerProperty DECAY = IntegerProperty.func_177719_a((String)"decay", (int)0, (int)5);

    public BurningPumpkinBlock(AbstractBlock.Properties properties) {
        super(properties);
        this.func_180632_j((BlockState)((BlockState)((BlockState)((BlockState)((BlockState)this.field_176227_L.func_177621_b()).func_206870_a((Property)LIT, (Comparable)Boolean.valueOf(true))).func_206870_a((Property)DECAY, (Comparable)Integer.valueOf(5))).func_206870_a((Property)FACING, (Comparable)Direction.UP)).func_206870_a((Property)WATERLOGGED, (Comparable)Boolean.valueOf(false)));
    }

    public int getLightValue(BlockState state, IBlockReader world, BlockPos pos) {
        if (((Boolean)state.func_177229_b((Property)LIT)).booleanValue()) {
            switch ((Integer)state.func_177229_b((Property)DECAY)) {
                case 5: {
                    return (Integer)BurningTorchConfig.GENERAL.pumpkinlightLevel5.get();
                }
                case 4: {
                    return (Integer)BurningTorchConfig.GENERAL.pumpkinlightLevel4.get();
                }
                case 3: {
                    return (Integer)BurningTorchConfig.GENERAL.pumpkinlightLevel3.get();
                }
                case 2: {
                    return (Integer)BurningTorchConfig.GENERAL.pumpkinlightLevel2.get();
                }
                case 1: {
                    return (Integer)BurningTorchConfig.GENERAL.pumpkinlightLevel1.get();
                }
            }
        }
        return 0;
    }

    public boolean func_204509_a(IWorld worldIn, BlockPos pos, BlockState state, FluidState fluidStateIn) {
        if (!((Boolean)state.func_177229_b((Property)BlockStateProperties.field_208198_y)).booleanValue() && fluidStateIn.func_206886_c() == Fluids.field_204546_a) {
            boolean lit = (Boolean)state.func_177229_b((Property)LIT);
            if (lit) {
                worldIn.func_184133_a(null, pos, SoundEvents.field_187646_bt, SoundCategory.BLOCKS, 1.0f, 1.0f);
            }
            worldIn.func_180501_a(pos, (BlockState)((BlockState)state.func_206870_a((Property)WATERLOGGED, (Comparable)Boolean.valueOf(true))).func_206870_a((Property)LIT, (Comparable)Boolean.valueOf(false)), 3);
            worldIn.func_205219_F_().func_205360_a(pos, (Object)fluidStateIn.func_206886_c(), fluidStateIn.func_206886_c().func_205569_a((IWorldReader)worldIn));
            return true;
        }
        return false;
    }

    public ActionResultType func_225533_a_(BlockState state, World worldIn, BlockPos pos, PlayerEntity player, Hand handIn, BlockRayTraceResult hit) {
        TorchTE torchTE = (TorchTE)worldIn.func_175625_s(pos);
        ITag extinguishTag = ItemTags.func_199903_a().func_241834_b(new ResourceLocation("burningtorch", "extinguish_items"));
        ITag relightTag = ItemTags.func_199903_a().func_241834_b(new ResourceLocation("burningtorch", "relight_items"));
        ITag cuttingTag = ItemTags.func_199903_a().func_241834_b(new ResourceLocation("burningtorch", "cutting_items"));
        Item mainHandItem = player.func_184614_ca().func_77973_b();
        Item offHandItem = player.func_184592_cb().func_77973_b();
        if (extinguishTag.func_230235_a_((Object)mainHandItem) || extinguishTag.func_230235_a_((Object)offHandItem)) {
            worldIn.func_184133_a(null, pos, SoundEvents.field_187745_eA, SoundCategory.BLOCKS, 0.3f, 0.8f);
            worldIn.func_175656_a(pos, (BlockState)worldIn.func_180495_p(pos).func_206870_a((Property)LIT, (Comparable)Boolean.valueOf(false)));
            return ActionResultType.SUCCESS;
        }
        if (relightTag.func_230235_a_((Object)mainHandItem) || relightTag.func_230235_a_((Object)offHandItem)) {
            worldIn.func_184133_a(null, pos, SoundEvents.field_187649_bu, SoundCategory.BLOCKS, 0.3f, 0.8f);
            worldIn.func_175656_a(pos, (BlockState)worldIn.func_180495_p(pos).func_206870_a((Property)LIT, (Comparable)Boolean.valueOf(true)));
            return ActionResultType.SUCCESS;
        }
        if (cuttingTag.func_230235_a_((Object)mainHandItem) || cuttingTag.func_230235_a_((Object)offHandItem)) {
            if ((Integer)state.func_177229_b((Property)DECAY) > 1) {
                worldIn.func_184133_a(null, pos, SoundEvents.field_187763_eJ, SoundCategory.BLOCKS, 0.2f, 0.8f);
                torchTE.setDecayLevel((Integer)state.func_177229_b((Property)DECAY) - 1);
                return ActionResultType.SUCCESS;
            }
            player.func_146105_b((ITextComponent)new TranslationTextComponent("burningtorch.interact.shears.low"), true);
        }
        for (String itemValue : (List)BurningTorchConfig.GENERAL.extendingItems.get()) {
            String[] splitTagFromValue = itemValue.split(",");
            ITag fuelTag = ItemTags.func_199903_a().func_241834_b(new ResourceLocation(splitTagFromValue[0]));
            int fuelValue = Integer.parseInt(splitTagFromValue[1]);
            if (!fuelTag.func_230235_a_((Object)mainHandItem) && (!fuelTag.func_230235_a_((Object)offHandItem) || torchTE.getDecayLevel() >= 5)) continue;
            if ((Integer)worldIn.func_180495_p(pos).func_177229_b((Property)DECAY) + fuelValue > 5) {
                worldIn.func_184133_a(null, pos, SoundEvents.field_187745_eA, SoundCategory.BLOCKS, 0.3f, 0.8f);
                torchTE.setDecayLevel(5);
                if (!player.func_184812_l_()) {
                    player.func_184614_ca().func_190920_e(player.func_184614_ca().func_190916_E() - 1);
                }
                return ActionResultType.SUCCESS;
            }
            torchTE.setDecayLevel((Integer)worldIn.func_180495_p(pos).func_177229_b((Property)DECAY) + fuelValue);
            if (!player.func_184812_l_()) {
                player.func_184614_ca().func_190920_e(player.func_184614_ca().func_190916_E() - 1);
            }
            return ActionResultType.SUCCESS;
        }
        return ActionResultType.FAIL;
    }

    public BlockState func_196258_a(BlockItemUseContext context) {
        if (((Boolean)BurningTorchConfig.GENERAL.placeLitPumpkins.get()).booleanValue()) {
            return (BlockState)((BlockState)this.func_176223_P().func_206870_a((Property)FACING, (Comparable)context.func_195992_f().func_176734_d())).func_206870_a((Property)LIT, (Comparable)Boolean.valueOf(true));
        }
        return (BlockState)((BlockState)this.func_176223_P().func_206870_a((Property)FACING, (Comparable)context.func_195992_f().func_176734_d())).func_206870_a((Property)LIT, (Comparable)Boolean.valueOf(false));
    }

    public FluidState func_204507_t(BlockState state) {
        return (Boolean)state.func_177229_b((Property)WATERLOGGED) != false ? Fluids.field_204546_a.func_207204_a(false) : super.func_204507_t(state);
    }

    protected void func_206840_a(StateContainer.Builder<Block, BlockState> builder) {
        builder.func_206894_a(new Property[]{LIT, DECAY, WATERLOGGED, FACING});
    }

    public boolean hasTileEntity(BlockState state) {
        return true;
    }

    @Nullable
    public TileEntity createTileEntity(BlockState state, IBlockReader world) {
        return new PumpkinTorchTE();
    }
}

