/*
 * Decompiled with CFR 0.152.
 */
package net.doubledoordev.burningtorch.blocks;

import java.util.List;
import java.util.Random;
import javax.annotation.Nullable;
import net.doubledoordev.burningtorch.BurningTorchConfig;
import net.doubledoordev.burningtorch.tileentities.TorchTE;
import net.minecraft.block.AbstractBlock;
import net.minecraft.block.Block;
import net.minecraft.block.BlockState;
import net.minecraft.block.Blocks;
import net.minecraft.entity.Entity;
import net.minecraft.entity.player.PlayerEntity;
import net.minecraft.item.BlockItemUseContext;
import net.minecraft.item.Item;
import net.minecraft.particles.IParticleData;
import net.minecraft.particles.ParticleTypes;
import net.minecraft.state.BooleanProperty;
import net.minecraft.state.DirectionProperty;
import net.minecraft.state.IntegerProperty;
import net.minecraft.state.Property;
import net.minecraft.state.StateContainer;
import net.minecraft.state.properties.BlockStateProperties;
import net.minecraft.tags.ITag;
import net.minecraft.tags.ItemTags;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.ActionResultType;
import net.minecraft.util.Direction;
import net.minecraft.util.Hand;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.SoundCategory;
import net.minecraft.util.SoundEvents;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.BlockRayTraceResult;
import net.minecraft.util.math.shapes.ISelectionContext;
import net.minecraft.util.math.shapes.VoxelShape;
import net.minecraft.util.text.ITextComponent;
import net.minecraft.util.text.TranslationTextComponent;
import net.minecraft.world.IBlockReader;
import net.minecraft.world.IWorld;
import net.minecraft.world.IWorldReader;
import net.minecraft.world.World;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;

public class BurningTorchBlock
extends Block {
    public static final DirectionProperty FACING = BlockStateProperties.field_208155_H;
    public static final BooleanProperty LIT = BlockStateProperties.field_208190_q;
    public static final IntegerProperty DECAY = IntegerProperty.func_177719_a((String)"decay", (int)0, (int)5);
    private static final VoxelShape STANDING = Block.func_208617_a((double)6.0, (double)0.0, (double)6.0, (double)10.0, (double)13.0, (double)10.0);
    private static final VoxelShape TORCH_NORTH = Block.func_208617_a((double)10.0, (double)3.0, (double)10.0, (double)6.0, (double)16.0, (double)16.0);
    private static final VoxelShape TORCH_EAST = Block.func_208617_a((double)0.0, (double)3.0, (double)10.0, (double)6.0, (double)16.0, (double)6.0);
    private static final VoxelShape TORCH_SOUTH = Block.func_208617_a((double)6.0, (double)3.0, (double)0.0, (double)10.0, (double)16.0, (double)6.0);
    private static final VoxelShape TORCH_WEST = Block.func_208617_a((double)16.0, (double)3.0, (double)6.0, (double)10.0, (double)16.0, (double)10.0);

    public BurningTorchBlock(AbstractBlock.Properties properties) {
        super(properties);
        this.func_180632_j((BlockState)((BlockState)((BlockState)((BlockState)this.field_176227_L.func_177621_b()).func_206870_a((Property)LIT, (Comparable)Boolean.valueOf(true))).func_206870_a((Property)DECAY, (Comparable)Integer.valueOf(5))).func_206870_a((Property)FACING, (Comparable)Direction.UP));
    }

    public int getLightValue(BlockState state, IBlockReader world, BlockPos pos) {
        if (((Boolean)state.func_177229_b((Property)LIT)).booleanValue()) {
            switch ((Integer)state.func_177229_b((Property)DECAY)) {
                case 5: {
                    return (Integer)BurningTorchConfig.GENERAL.torchlightLevel5.get();
                }
                case 4: {
                    return (Integer)BurningTorchConfig.GENERAL.torchlightLevel4.get();
                }
                case 3: {
                    return (Integer)BurningTorchConfig.GENERAL.torchlightLevel3.get();
                }
                case 2: {
                    return (Integer)BurningTorchConfig.GENERAL.torchlightLevel2.get();
                }
                case 1: {
                    return (Integer)BurningTorchConfig.GENERAL.torchlightLevel1.get();
                }
            }
        }
        return 0;
    }

    public BlockState func_196271_a(BlockState stateIn, Direction facing, BlockState facingState, IWorld worldIn, BlockPos currentPos, BlockPos facingPos) {
        if (stateIn.func_177229_b((Property)FACING) == Direction.UP) {
            return facing == Direction.DOWN && !this.func_196260_a(stateIn, (IWorldReader)worldIn, currentPos) ? Blocks.field_150350_a.func_176223_P() : super.func_196271_a(stateIn, facing, facingState, worldIn, currentPos, facingPos);
        }
        return facing.func_176734_d() == stateIn.func_177229_b((Property)FACING) && !stateIn.func_196955_c((IWorldReader)worldIn, currentPos) ? Blocks.field_150350_a.func_176223_P() : stateIn;
    }

    public VoxelShape func_220053_a(BlockState state, IBlockReader worldIn, BlockPos pos, ISelectionContext context) {
        switch ((Direction)state.func_177229_b((Property)FACING)) {
            case EAST: {
                return TORCH_EAST;
            }
            case WEST: {
                return TORCH_WEST;
            }
            case SOUTH: {
                return TORCH_SOUTH;
            }
            case NORTH: {
                return TORCH_NORTH;
            }
        }
        return STANDING;
    }

    @OnlyIn(value=Dist.CLIENT)
    public void func_180655_c(BlockState stateIn, World worldIn, BlockPos pos, Random rand) {
        TorchTE torchTE = (TorchTE)worldIn.func_175625_s(pos);
        boolean lit = (Boolean)stateIn.func_177229_b((Property)LIT);
        Direction facing = (Direction)stateIn.func_177229_b((Property)FACING);
        int decay = torchTE.getDecayLevel();
        double random = Math.random();
        double d0 = (double)pos.func_177958_n() + 0.5;
        double d1 = (double)pos.func_177956_o() + 0.9;
        double d2 = (double)pos.func_177952_p() + 0.5;
        switch (decay) {
            case 5: {
                d1 = (double)pos.func_177956_o() + 0.9;
                break;
            }
            case 4: {
                d1 = (double)pos.func_177956_o() + 0.85;
                break;
            }
            case 3: {
                d1 = (double)pos.func_177956_o() + 0.75;
                break;
            }
            case 2: {
                d1 = (double)pos.func_177956_o() + 0.62;
                break;
            }
            case 1: {
                d1 = (double)pos.func_177956_o() + 0.44;
                break;
            }
            case 0: {
                d1 = (double)pos.func_177956_o() + 0.35;
            }
        }
        if (lit) {
            if (facing.func_176740_k().func_176722_c()) {
                switch (decay) {
                    case 5: {
                        worldIn.func_195594_a((IParticleData)ParticleTypes.field_197601_L, d0 + 0.2 * (double)facing.func_176734_d().func_82601_c(), d1 + 0.2, d2 + 0.2 * (double)facing.func_176734_d().func_82599_e(), 0.0, 0.0, 0.0);
                        worldIn.func_195594_a((IParticleData)ParticleTypes.field_197631_x, d0 + 0.2 * (double)facing.func_176734_d().func_82601_c(), d1 + 0.2, d2 + 0.2 * (double)facing.func_176734_d().func_82599_e(), 0.0, 0.0, 0.0);
                        break;
                    }
                    case 4: {
                        worldIn.func_195594_a((IParticleData)ParticleTypes.field_197601_L, d0 + 0.22 * (double)facing.func_176734_d().func_82601_c(), d1 + 0.16, d2 + 0.3 * (double)facing.func_176734_d().func_82599_e(), 0.0, 0.0, 0.0);
                        worldIn.func_195594_a((IParticleData)ParticleTypes.field_197631_x, d0 + 0.22 * (double)facing.func_176734_d().func_82601_c(), d1 + 0.16, d2 + 0.3 * (double)facing.func_176734_d().func_82599_e(), 0.0, 0.0, 0.0);
                        break;
                    }
                    case 3: {
                        worldIn.func_195594_a((IParticleData)ParticleTypes.field_197601_L, d0 + 0.24 * (double)facing.func_176734_d().func_82601_c(), d1 + 0.15, d2 + 0.3 * (double)facing.func_176734_d().func_82599_e(), 0.0, 0.0, 0.0);
                        worldIn.func_195594_a((IParticleData)ParticleTypes.field_197631_x, d0 + 0.24 * (double)facing.func_176734_d().func_82601_c(), d1 + 0.15, d2 + 0.3 * (double)facing.func_176734_d().func_82599_e(), 0.0, 0.0, 0.0);
                        break;
                    }
                    case 2: {
                        worldIn.func_195594_a((IParticleData)ParticleTypes.field_197601_L, d0 + 0.3 * (double)facing.func_176734_d().func_82601_c(), d1 + 0.16, d2 + 0.3 * (double)facing.func_176734_d().func_82599_e(), 0.0, 0.0, 0.0);
                        worldIn.func_195594_a((IParticleData)ParticleTypes.field_197631_x, d0 + 0.3 * (double)facing.func_176734_d().func_82601_c(), d1 + 0.16, d2 + 0.3 * (double)facing.func_176734_d().func_82599_e(), 0.0, 0.0, 0.0);
                        break;
                    }
                    case 1: {
                        if (random > 0.5) {
                            worldIn.func_195594_a((IParticleData)ParticleTypes.field_197601_L, d0 + 0.35 * (double)facing.func_176734_d().func_82601_c(), d1 + 0.28, d2 + 0.3 * (double)facing.func_176734_d().func_82599_e(), 0.0, 0.0, 0.0);
                            worldIn.func_195594_a((IParticleData)ParticleTypes.field_197631_x, d0 + 0.35 * (double)facing.func_176734_d().func_82601_c(), d1 + 0.28, d2 + 0.3 * (double)facing.func_176734_d().func_82599_e(), 0.0, 0.0, 0.0);
                            break;
                        }
                        worldIn.func_195594_a((IParticleData)ParticleTypes.field_197594_E, d0 + 0.35 * (double)facing.func_176734_d().func_82601_c(), d1 + 0.28, d2 + 0.3 * (double)facing.func_176734_d().func_82599_e(), 0.0, 0.0, 0.0);
                        break;
                    }
                    case 0: {
                        worldIn.func_195594_a((IParticleData)ParticleTypes.field_197601_L, d0 + 0.1 * (double)facing.func_176734_d().func_82601_c(), d1 + 0.09, d2 + 0.3 * (double)facing.func_176734_d().func_82599_e(), 0.0, 0.0, 0.0);
                        worldIn.func_195594_a((IParticleData)ParticleTypes.field_197631_x, d0 + 0.1 * (double)facing.func_176734_d().func_82601_c(), d1 + 0.09, d2 + 0.3 * (double)facing.func_176734_d().func_82599_e(), 0.0, 0.0, 0.0);
                    }
                }
            } else {
                switch (decay) {
                    case 0: 
                    case 2: 
                    case 3: 
                    case 4: 
                    case 5: {
                        worldIn.func_195594_a((IParticleData)ParticleTypes.field_197601_L, d0, d1, d2, 0.0, 0.0, 0.0);
                        worldIn.func_195594_a((IParticleData)ParticleTypes.field_197631_x, d0, d1, d2, 0.0, 0.0, 0.0);
                        break;
                    }
                    case 1: {
                        if (random > 0.5) {
                            worldIn.func_195594_a((IParticleData)ParticleTypes.field_197601_L, d0, d1, d2, 0.0, 0.0, 0.0);
                            worldIn.func_195594_a((IParticleData)ParticleTypes.field_197631_x, d0, d1, d2, 0.0, 0.0, 0.0);
                            break;
                        }
                        worldIn.func_195594_a((IParticleData)ParticleTypes.field_197594_E, d0, d1, d2, 0.0, 0.0, 0.0);
                    }
                }
            }
        }
    }

    public boolean func_196260_a(BlockState state, IWorldReader level, BlockPos pos) {
        Direction direction = (Direction)state.func_177229_b((Property)FACING);
        BlockPos blockpos = pos.func_177972_a(direction.func_176734_d());
        BlockState blockstate = level.func_180495_p(blockpos);
        return blockstate.func_224755_d((IBlockReader)level, blockpos, direction);
    }

    public ActionResultType func_225533_a_(BlockState state, World worldIn, BlockPos pos, PlayerEntity player, Hand handIn, BlockRayTraceResult hit) {
        TorchTE torchTE = (TorchTE)worldIn.func_175625_s(pos);
        ITag extinguishTag = ItemTags.func_199903_a().func_241834_b(new ResourceLocation("burningtorch", "extinguish_items"));
        ITag relightTag = ItemTags.func_199903_a().func_241834_b(new ResourceLocation("burningtorch", "relight_items"));
        ITag cuttingTag = ItemTags.func_199903_a().func_241834_b(new ResourceLocation("burningtorch", "cutting_items"));
        Item mainHandItem = player.func_184614_ca().func_77973_b();
        Item offHandItem = player.func_184592_cb().func_77973_b();
        if (extinguishTag.func_230235_a_((Object)mainHandItem) || extinguishTag.func_230235_a_((Object)offHandItem)) {
            worldIn.func_184133_a(null, pos, SoundEvents.field_187745_eA, SoundCategory.BLOCKS, 0.3f, 0.8f);
            worldIn.func_175656_a(pos, (BlockState)worldIn.func_180495_p(pos).func_206870_a((Property)LIT, (Comparable)Boolean.valueOf(false)));
            return ActionResultType.SUCCESS;
        }
        if (relightTag.func_230235_a_((Object)mainHandItem) || relightTag.func_230235_a_((Object)offHandItem)) {
            worldIn.func_184133_a(null, pos, SoundEvents.field_187649_bu, SoundCategory.BLOCKS, 0.3f, 0.8f);
            worldIn.func_175656_a(pos, (BlockState)worldIn.func_180495_p(pos).func_206870_a((Property)LIT, (Comparable)Boolean.valueOf(true)));
            return ActionResultType.SUCCESS;
        }
        if (cuttingTag.func_230235_a_((Object)mainHandItem) || cuttingTag.func_230235_a_((Object)offHandItem)) {
            if ((Integer)state.func_177229_b((Property)DECAY) > 1) {
                worldIn.func_184133_a(null, pos, SoundEvents.field_187763_eJ, SoundCategory.BLOCKS, 0.2f, 0.8f);
                torchTE.setDecayLevel((Integer)state.func_177229_b((Property)DECAY) - 1);
                return ActionResultType.SUCCESS;
            }
            player.func_146105_b((ITextComponent)new TranslationTextComponent("burningtorch.interact.shears.low"), true);
        }
        for (String itemValue : (List)BurningTorchConfig.GENERAL.extendingItems.get()) {
            String[] splitTagFromValue = itemValue.split(",");
            ITag fuelTag = ItemTags.func_199903_a().func_241834_b(new ResourceLocation(splitTagFromValue[0]));
            int fuelValue = Integer.parseInt(splitTagFromValue[1]);
            if (!fuelTag.func_230235_a_((Object)mainHandItem) && (!fuelTag.func_230235_a_((Object)offHandItem) || torchTE.getDecayLevel() >= 5)) continue;
            if ((Integer)worldIn.func_180495_p(pos).func_177229_b((Property)DECAY) + fuelValue > 5) {
                worldIn.func_184133_a(null, pos, SoundEvents.field_187745_eA, SoundCategory.BLOCKS, 0.3f, 0.8f);
                torchTE.setDecayLevel(5);
            } else {
                torchTE.setDecayLevel((Integer)worldIn.func_180495_p(pos).func_177229_b((Property)DECAY) + fuelValue);
            }
            if (!player.func_184812_l_()) {
                player.func_184614_ca().func_190920_e(player.func_184614_ca().func_190916_E() - 1);
            }
            return ActionResultType.SUCCESS;
        }
        return ActionResultType.FAIL;
    }

    @Nullable
    public BlockState func_196258_a(BlockItemUseContext context) {
        Direction[] adirection;
        BlockState blockstate = this.func_176223_P();
        World iworldreader = context.func_195991_k();
        BlockPos blockpos = context.func_195995_a();
        for (Direction direction : adirection = context.func_196009_e()) {
            if (direction.func_176740_k().func_176722_c()) {
                Direction direction1 = direction.func_176734_d();
                if (!(blockstate = (BlockState)blockstate.func_206870_a((Property)FACING, (Comparable)direction1)).func_196955_c((IWorldReader)iworldreader, blockpos)) continue;
                if (((Boolean)BurningTorchConfig.GENERAL.placeLitTorches.get()).booleanValue()) {
                    return (BlockState)blockstate.func_206870_a((Property)LIT, (Comparable)Boolean.valueOf(true));
                }
                return blockstate;
            }
            if (((Boolean)BurningTorchConfig.GENERAL.placeLitTorches.get()).booleanValue()) {
                return (BlockState)blockstate.func_206870_a((Property)LIT, (Comparable)Boolean.valueOf(true));
            }
            return blockstate;
        }
        return null;
    }

    public void func_196262_a(BlockState state, World worldIn, BlockPos pos, Entity entityIn) {
        if (!worldIn.func_201670_d() && entityIn.func_70027_ad() && !((Boolean)state.func_177229_b((Property)LIT)).booleanValue()) {
            worldIn.func_175656_a(pos, (BlockState)state.func_206870_a((Property)BlockStateProperties.field_208190_q, (Comparable)Boolean.valueOf(true)));
        }
    }

    protected void func_206840_a(StateContainer.Builder<Block, BlockState> builder) {
        builder.func_206894_a(new Property[]{LIT, DECAY, FACING});
    }

    public boolean isBurning(BlockState state, IBlockReader world, BlockPos pos) {
        if (((Boolean)BurningTorchConfig.GENERAL.torchesBurnEntities.get()).booleanValue()) {
            return (Boolean)world.func_180495_p(pos).func_177229_b((Property)LIT);
        }
        return false;
    }

    public boolean hasTileEntity(BlockState state) {
        return true;
    }

    @Nullable
    public TileEntity createTileEntity(BlockState state, IBlockReader world) {
        return new TorchTE();
    }
}

