/*
 * Decompiled with CFR 0.152.
 */
package net.doubledoordev.burningtorch.tileentities;

import java.util.Random;
import javax.annotation.Nullable;
import net.doubledoordev.burningtorch.BurningTorchConfig;
import net.doubledoordev.burningtorch.blocks.BlockHolder;
import net.doubledoordev.burningtorch.blocks.BurningTorchBlock;
import net.doubledoordev.burningtorch.tileentities.TEHolder;
import net.doubledoordev.burningtorch.util.UtilMethods;
import net.minecraft.block.AbstractFireBlock;
import net.minecraft.block.BlockState;
import net.minecraft.nbt.CompoundNBT;
import net.minecraft.network.NetworkManager;
import net.minecraft.network.play.server.SUpdateTileEntityPacket;
import net.minecraft.state.Property;
import net.minecraft.tileentity.ITickableTileEntity;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.tileentity.TileEntityType;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.GameRules;
import net.minecraft.world.IBlockReader;
import net.minecraft.world.IWorldReader;
import net.minecraft.world.World;

public class TorchTE
extends TileEntity
implements ITickableTileEntity {
    int decayLevel;
    int rainTimer;
    int decayTimer;
    int tickCounter;

    private TorchTE(TileEntityType<?> p_i49963_1_) {
        super(p_i49963_1_);
        this.decayLevel = (Integer)BurningTorchConfig.GENERAL.torchStartingDecayLevel.get();
    }

    public TorchTE() {
        this(TEHolder.torchte);
    }

    public void func_230337_a_(BlockState state, CompoundNBT compound) {
        super.func_230337_a_(state, compound);
        this.decayLevel = compound.func_74762_e("decaylevel");
        this.decayTimer = compound.func_74762_e("decayTimer");
    }

    public CompoundNBT func_189515_b(CompoundNBT compound) {
        compound.func_74768_a("decaylevel", this.decayLevel);
        compound.func_74768_a("decayTimer", this.decayTimer);
        return super.func_189515_b(compound);
    }

    @Nullable
    public SUpdateTileEntityPacket func_189518_D_() {
        return new SUpdateTileEntityPacket(this.field_174879_c, 3, this.func_189517_E_());
    }

    public CompoundNBT func_189517_E_() {
        return this.func_189515_b(new CompoundNBT());
    }

    public int getDecayLevel() {
        return this.decayLevel;
    }

    public void setDecayLevel(int decayLevel) {
        this.decayLevel = decayLevel;
        this.field_145850_b.func_175656_a(this.field_174879_c, (BlockState)this.field_145850_b.func_180495_p(this.field_174879_c).func_206870_a((Property)BurningTorchBlock.DECAY, (Comparable)Integer.valueOf(decayLevel)));
    }

    public void func_73660_a() {
        World world = this.field_145850_b;
        if (world.func_180495_p(this.field_174879_c).func_177230_c() == BlockHolder.burningtorch.getBlock()) {
            if (this.decayLevel > 0 && ((Boolean)world.func_180495_p(this.field_174879_c).func_177229_b((Property)BurningTorchBlock.LIT)).booleanValue()) {
                ++this.rainTimer;
                ++this.decayTimer;
                if (this.rainTimer > (Integer)BurningTorchConfig.GENERAL.rainUpdateRate.get() && ((Boolean)BurningTorchConfig.GENERAL.shouldRainExtinguish.get()).booleanValue() && world.func_72896_J() && world.func_226660_f_(this.field_174879_c)) {
                    world.func_175656_a(this.field_174879_c, (BlockState)world.func_180495_p(this.field_174879_c).func_206870_a((Property)BurningTorchBlock.LIT, (Comparable)Boolean.valueOf(false)));
                    this.updateBlock();
                    this.rainTimer = 0;
                }
                if (this.decayTimer > (Integer)BurningTorchConfig.GENERAL.decayRate.get() && this.decayLevel > 0) {
                    --this.decayLevel;
                    world.func_175656_a(this.field_174879_c, (BlockState)world.func_180495_p(this.field_174879_c).func_206870_a((Property)BurningTorchBlock.DECAY, (Comparable)Integer.valueOf(this.decayLevel)));
                    this.updateBlock();
                    this.decayTimer = 0;
                }
            } else if (this.decayLevel == 0) {
                world.func_175713_t(this.field_174879_c);
                world.func_217377_a(this.field_174879_c, false);
                this.decayTimer = 0;
            }
        } else {
            world.func_175713_t(this.field_174879_c);
        }
        Random random = new Random();
        BlockPos firePos = this.field_174879_c;
        if (world.func_82736_K().func_223586_b(GameRules.field_223598_a) && world.func_180495_p(this.field_174879_c).func_177230_c() == BlockHolder.burningtorch.getBlock()) {
            if (!world.isAreaLoaded(firePos, 2) && ((Boolean)world.func_180495_p(this.field_174879_c).func_177229_b((Property)BurningTorchBlock.LIT)).booleanValue() && ((Boolean)BurningTorchConfig.GENERAL.torchesStartFireWhenLit.get()).booleanValue()) {
                return;
            }
            int randomInt = random.nextInt(101);
            ++this.tickCounter;
            if (randomInt < (Integer)BurningTorchConfig.GENERAL.percentToStartFire.get() && this.tickCounter == (Integer)BurningTorchConfig.GENERAL.delayBetweenFire.get()) {
                firePos = firePos.func_177982_a(random.nextInt(3) - 1, random.nextInt(1), random.nextInt(3) - 1);
                BlockState fireState = AbstractFireBlock.func_235326_a_((IBlockReader)world, (BlockPos)this.field_174879_c);
                if (firePos.func_177956_o() >= 0 && firePos.func_177956_o() < world.func_234938_ad_() && UtilMethods.isSurroundingBlockFlammable(world, firePos) && fireState.func_196955_c((IWorldReader)world, firePos)) {
                    world.func_180501_a(firePos, fireState, 11);
                }
                this.tickCounter = 0;
            }
        }
    }

    public void onDataPacket(NetworkManager net, SUpdateTileEntityPacket pkt) {
        this.deserializeNBT(pkt.func_148857_g());
        this.updateBlock();
    }

    private void updateBlock() {
        this.func_70296_d();
    }
}

