/*
 * Decompiled with CFR 0.152.
 */
package io.github.tehstoneman.cashcraft.common.item;

import io.github.tehstoneman.cashcraft.api.CashCraftAPI;
import io.github.tehstoneman.cashcraft.common.inventory.ContainerMoneyPouch;
import io.github.tehstoneman.cashcraft.common.item.CashCraftItems;
import io.github.tehstoneman.cashcraft.common.item.ItemCashCraft;
import java.util.List;
import javax.annotation.Nullable;
import net.minecraft.client.util.ITooltipFlag;
import net.minecraft.entity.player.PlayerEntity;
import net.minecraft.entity.player.PlayerInventory;
import net.minecraft.entity.player.ServerPlayerEntity;
import net.minecraft.inventory.container.Container;
import net.minecraft.inventory.container.INamedContainerProvider;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.CompoundNBT;
import net.minecraft.util.ActionResult;
import net.minecraft.util.ActionResultType;
import net.minecraft.util.Direction;
import net.minecraft.util.Hand;
import net.minecraft.util.text.ITextComponent;
import net.minecraft.util.text.TranslationTextComponent;
import net.minecraft.world.World;
import net.minecraftforge.common.capabilities.Capability;
import net.minecraftforge.common.capabilities.ICapabilityProvider;
import net.minecraftforge.common.capabilities.ICapabilitySerializable;
import net.minecraftforge.common.util.LazyOptional;
import net.minecraftforge.fml.network.NetworkHooks;
import net.minecraftforge.items.CapabilityItemHandler;
import net.minecraftforge.items.IItemHandler;
import net.minecraftforge.items.ItemStackHandler;

public class ItemMoneyPouch
extends ItemCashCraft
implements INamedContainerProvider {
    public Container createMenu(int windowID, PlayerInventory playerInventory, PlayerEntity player) {
        ItemStack itemStack = player.func_184614_ca();
        int index = player.field_71071_by.field_70461_c;
        return new ContainerMoneyPouch(windowID, playerInventory, itemStack, index);
    }

    public ITextComponent func_145748_c_() {
        return new TranslationTextComponent("container.cashcraft.money_pouch");
    }

    public ICapabilityProvider initCapabilities(ItemStack stack, @Nullable CompoundNBT nbt) {
        return new MoneyPouchProvider(stack);
    }

    public ActionResult<ItemStack> func_77659_a(World worldIn, PlayerEntity playerIn, Hand hand) {
        if (!worldIn.field_72995_K && hand == playerIn.func_184600_cs()) {
            NetworkHooks.openGui((ServerPlayerEntity)((ServerPlayerEntity)playerIn), (INamedContainerProvider)CashCraftItems.MONEY_POUCH, buf -> buf.func_150788_a(playerIn.func_184586_b(hand)).writeInt(playerIn.field_71071_by.field_70461_c));
        }
        return new ActionResult(ActionResultType.SUCCESS, (Object)playerIn.func_184586_b(hand));
    }

    public void func_77624_a(ItemStack stack, @Nullable World worldIn, List<ITextComponent> tooltip, ITooltipFlag flagIn) {
        super.func_77624_a(stack, worldIn, tooltip, flagIn);
        CompoundNBT CompoundNBT2 = stack.func_77978_p();
        if (CompoundNBT2 != null && CompoundNBT2.func_74764_b("Value")) {
            String v = CashCraftAPI.economy.toString(CompoundNBT2.func_74762_e("Value"), false);
            tooltip.add((ITextComponent)new TranslationTextComponent("tooltip.cashcraft.contains", new Object[]{v}));
        } else {
            tooltip.add((ITextComponent)new TranslationTextComponent("tooltip.cashcraft.empty"));
        }
        tooltip.add((ITextComponent)new TranslationTextComponent("tooltip.cashcraft.money_pouch"));
    }

    private static class MoneyPouchProvider
    implements ICapabilitySerializable<CompoundNBT> {
        private final ItemStack invItem;
        private ItemStackHandler inventory;
        private final LazyOptional<IItemHandler> inventoryHandler = LazyOptional.of(() -> this.inventory);

        private MoneyPouchProvider(ItemStack stack) {
            this.invItem = stack;
            int size = this.getSizeContents();
            this.inventory = size > 0 ? new ItemStackHandler(size){

                protected void onContentsChanged(int slot) {
                }
            } : null;
        }

        public <T> LazyOptional<T> getCapability(Capability<T> capability, Direction facing) {
            if (capability == CapabilityItemHandler.ITEM_HANDLER_CAPABILITY) {
                return CapabilityItemHandler.ITEM_HANDLER_CAPABILITY.orEmpty(capability, this.inventoryHandler);
            }
            return LazyOptional.empty();
        }

        private int getSizeContents() {
            return 15;
        }

        private void markDirty() {
            int count = 0;
            for (int i = 0; i < this.inventory.getSlots(); ++i) {
                if (this.inventory.getStackInSlot(i).func_190926_b()) continue;
                ++count;
            }
        }

        public CompoundNBT serializeNBT() {
            CompoundNBT compound = new CompoundNBT();
            if (this.invItem.func_77942_o()) {
                compound = this.invItem.func_77978_p();
            }
            compound.func_74772_a("Value", this.getValue());
            this.invItem.func_77982_d(compound);
            return this.inventory.serializeNBT();
        }

        public void deserializeNBT(CompoundNBT compound) {
            this.inventory.deserializeNBT(compound);
        }

        public long getValue() {
            long value = 0L;
            for (int i = 0; i < this.inventory.getSlots(); ++i) {
                if (this.inventory.getStackInSlot(i).func_190926_b()) continue;
                value += CashCraftAPI.economy.getValue(this.inventory.getStackInSlot(i));
            }
            return value;
        }
    }
}

