/*
 * Decompiled with CFR 0.152.
 */
package io.github.tehstoneman.cashcraft.client;

import io.github.tehstoneman.cashcraft.CashCraft;
import io.github.tehstoneman.cashcraft.common.item.ItemCash;
import io.github.tehstoneman.cashcraft.common.item.ItemCashCraft;
import java.util.Map;
import net.minecraft.block.Block;
import net.minecraft.block.state.IBlockState;
import net.minecraft.client.renderer.ItemMeshDefinition;
import net.minecraft.client.renderer.block.model.ModelBakery;
import net.minecraft.client.renderer.block.model.ModelResourceLocation;
import net.minecraft.client.renderer.block.statemap.StateMapperBase;
import net.minecraft.init.Items;
import net.minecraft.item.Item;
import net.minecraft.util.ResourceLocation;
import net.minecraftforge.client.event.ModelRegistryEvent;
import net.minecraftforge.client.model.ModelLoader;
import net.minecraftforge.fml.common.eventhandler.SubscribeEvent;

public class ClientEvents {
    private final StateMapperBase propertyStringMapper = new StateMapperBase(){

        protected ModelResourceLocation func_178132_a(IBlockState state) {
            return new ModelResourceLocation("minecraft:air");
        }
    };

    @SubscribeEvent
    public void onRegisterModels(ModelRegistryEvent event) {
        for (ItemCash.EnumCoinValue value : ItemCash.EnumCoinValue.values()) {
            this.registerItemModel((Item)ItemCashCraft.COIN, value.getMetadata(), CashCraft.modAsset(value.getTextureName()));
        }
        this.registerItemModel(ItemCashCraft.MONEY_POUCH);
    }

    private void registerBlockItemModelForMeta(IBlockState state, int metadata) {
        Item item = Item.func_150898_a((Block)state.func_177230_c());
        if (item != Items.field_190931_a) {
            this.registerItemModel(item, metadata, this.propertyStringMapper.func_178131_a((Map)state.func_177228_b()));
        }
    }

    private void registerItemModel(Block block) {
        Item item = Item.func_150898_a((Block)block);
        if (item != Items.field_190931_a) {
            this.registerItemModel(item);
        }
    }

    private void registerItemModel(Block block, int metadata, String modelLocation) {
        Item item = Item.func_150898_a((Block)block);
        if (item != Items.field_190931_a) {
            this.registerItemModel(item, metadata, modelLocation);
        }
    }

    private void registerItemModel(Item item) {
        ResourceLocation registryName = item.getRegistryName();
        this.registerItemModel(item, registryName.toString());
    }

    private void registerItemModel(Item item, String modelLocation) {
        ModelResourceLocation fullModelLocation = new ModelResourceLocation(modelLocation, "inventory");
        this.registerItemModel(item, fullModelLocation);
    }

    private void registerItemModel(Item item, int meta, String modelLocation) {
        ModelResourceLocation fullModelLocation = new ModelResourceLocation(modelLocation, "inventory");
        this.registerItemModel(item, meta, fullModelLocation);
    }

    private void registerItemModel(Item item, ModelResourceLocation fullModelLocation) {
        ModelBakery.registerItemVariants((Item)item, (ResourceLocation[])new ResourceLocation[]{fullModelLocation});
        this.registerItemModel(item, stack -> fullModelLocation);
    }

    private void registerItemModel(Item item, ItemMeshDefinition meshDefinition) {
        ModelLoader.setCustomMeshDefinition((Item)item, (ItemMeshDefinition)meshDefinition);
    }

    private void registerItemModel(Item item, int metadata, ModelResourceLocation modelResourceLocation) {
        ModelLoader.setCustomModelResourceLocation((Item)item, (int)metadata, (ModelResourceLocation)modelResourceLocation);
    }
}

