/*
 * Decompiled with CFR 0.152.
 */
package io.github.tehstoneman.cashcraft.common.item;

import io.github.tehstoneman.cashcraft.CashCraft;
import io.github.tehstoneman.cashcraft.api.CashCraftAPI;
import io.github.tehstoneman.cashcraft.common.item.ItemCashCraft;
import java.util.List;
import javax.annotation.Nullable;
import net.minecraft.client.util.ITooltipFlag;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.util.ActionResult;
import net.minecraft.util.EnumActionResult;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.EnumHand;
import net.minecraft.world.World;
import net.minecraftforge.common.capabilities.Capability;
import net.minecraftforge.common.capabilities.ICapabilityProvider;
import net.minecraftforge.common.capabilities.ICapabilitySerializable;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;
import net.minecraftforge.items.CapabilityItemHandler;
import net.minecraftforge.items.ItemStackHandler;

public class ItemMoneyPouch
extends ItemCashCraft {
    public ItemMoneyPouch() {
        super("moneypouch");
        this.func_77656_e(0);
        this.func_77625_d(1);
    }

    public ICapabilityProvider initCapabilities(ItemStack stack, @Nullable NBTTagCompound nbt) {
        return new MoneyPouchProvider(stack);
    }

    public ActionResult<ItemStack> func_77659_a(World worldIn, EntityPlayer playerIn, EnumHand hand) {
        if (!worldIn.field_72995_K && hand == EnumHand.MAIN_HAND) {
            playerIn.openGui((Object)CashCraft.instance, 0, worldIn, 0, 0, 0);
        }
        return new ActionResult(EnumActionResult.SUCCESS, (Object)playerIn.func_184586_b(hand));
    }

    @SideOnly(value=Side.CLIENT)
    public void func_77624_a(ItemStack stack, @Nullable World worldIn, List<String> tooltip, ITooltipFlag flagIn) {
        NBTTagCompound nbtTagCompound = stack.func_77978_p();
        if (nbtTagCompound != null && nbtTagCompound.func_74764_b("Value")) {
            String v = CashCraftAPI.economy.toString(nbtTagCompound.func_74762_e("Value"), false);
            String s = CashCraft.proxy.localize("tooltip.cashcraft.contains", v);
            tooltip.add(s);
        } else {
            tooltip.add(CashCraft.proxy.localize("tooltip.cashcraft.empty", new Object[0]));
        }
        tooltip.add(CashCraft.proxy.localize("tooltip.cashcraft.moneypouch", new Object[0]));
    }

    private static class MoneyPouchProvider
    implements ICapabilitySerializable<NBTTagCompound> {
        private final ItemStack invItem;
        private ItemStackHandler inventory;

        private MoneyPouchProvider(ItemStack stack) {
            this.invItem = stack;
            int size = this.getSizeContents();
            this.inventory = size > 0 ? new ItemStackHandler(size){

                protected void onContentsChanged(int slot) {
                }
            } : null;
        }

        public boolean hasCapability(Capability<?> capability, EnumFacing facing) {
            return capability == CapabilityItemHandler.ITEM_HANDLER_CAPABILITY;
        }

        public <T> T getCapability(Capability<T> capability, EnumFacing facing) {
            return (T)(capability == CapabilityItemHandler.ITEM_HANDLER_CAPABILITY ? CapabilityItemHandler.ITEM_HANDLER_CAPABILITY.cast((Object)this.inventory) : null);
        }

        private int getSizeContents() {
            return 15;
        }

        private void markDirty() {
            int count = 0;
            for (int i = 0; i < this.inventory.getSlots(); ++i) {
                if (this.inventory.getStackInSlot(i).func_190926_b()) continue;
                ++count;
            }
            this.invItem.func_77964_b((int)this.getValue());
        }

        public NBTTagCompound serializeNBT() {
            NBTTagCompound compound = new NBTTagCompound();
            if (this.invItem.func_77942_o()) {
                compound = this.invItem.func_77978_p();
            }
            compound.func_74772_a("Value", this.getValue());
            this.invItem.func_77982_d(compound);
            return this.inventory.serializeNBT();
        }

        public void deserializeNBT(NBTTagCompound compound) {
            this.inventory.deserializeNBT(compound);
        }

        public long getValue() {
            long value = 0L;
            for (int i = 0; i < this.inventory.getSlots(); ++i) {
                if (this.inventory.getStackInSlot(i).func_190926_b()) continue;
                value += CashCraftAPI.economy.getValue(this.inventory.getStackInSlot(i));
            }
            return value;
        }
    }
}

