/*
 * Decompiled with CFR 0.152.
 */
package io.github.tehstoneman.cashcraft.config;

import java.io.File;
import net.minecraftforge.common.config.Configuration;
import net.minecraftforge.common.config.Property;

public class CashCraftConfig {
    private final Configuration config;
    public static final String CATEGORY_DISPLAY = "display";
    public static final String CATEGORY_ECONOMY = "economy";
    public static boolean useEconomy;
    public static boolean showAsCoins;
    public static boolean useCustomName;
    public static String cashSingular;
    public static String cashPlural;
    public static boolean useTrade;

    public CashCraftConfig(File file) {
        this.config = new Configuration(file);
    }

    public Configuration getConfig() {
        return this.config;
    }

    public void syncFromFile() {
        this.syncConfig(true, true);
    }

    public void syncFromGUI() {
        this.syncConfig(false, true);
    }

    public void syncFromFields() {
        this.syncConfig(false, false);
    }

    public void syncConfig(boolean loadConfigFromFile, boolean readFieldsFromConfig) {
        if (loadConfigFromFile) {
            this.config.load();
        }
        Property propUseEconomy = this.config.get("general", "useEconomy", true).setLanguageKey("config.cashcraft.use_economy").setRequiresMcRestart(true);
        Property propShowAsCoins = this.config.get(CATEGORY_DISPLAY, "showAsCoins", false).setLanguageKey("config.cashcraft.show_as_coins").setRequiresMcRestart(false);
        Property propUseCustomName = this.config.get(CATEGORY_DISPLAY, "useCustomName", false).setLanguageKey("config.cashcraft.use_custom_name").setRequiresMcRestart(false);
        Property propCashSingular = this.config.get(CATEGORY_DISPLAY, "cashSingular", "%s cash").setLanguageKey("config.cashcraft.cash_singular").setRequiresMcRestart(false);
        Property propCashPlural = this.config.get(CATEGORY_DISPLAY, "cashPlural", "%s cash").setLanguageKey("config.cashcraft.cash_plural").setRequiresMcRestart(false);
        Property propUseTrade = this.config.get(CATEGORY_ECONOMY, "useTrade", true).setLanguageKey("config.cashcraft.use_trade").setRequiresMcRestart(false);
        if (readFieldsFromConfig) {
            useEconomy = propUseEconomy.getBoolean();
            showAsCoins = propShowAsCoins.getBoolean();
            useCustomName = propUseCustomName.getBoolean();
            cashSingular = propCashSingular.getString();
            cashPlural = propCashPlural.getString();
            useEconomy = propUseEconomy.getBoolean();
        }
        propUseEconomy.set(useEconomy);
        propShowAsCoins.set(showAsCoins);
        propUseCustomName.set(useCustomName);
        propCashSingular.set(cashSingular);
        propCashPlural.set(cashPlural);
        propUseEconomy.set(useEconomy);
        if (this.config.hasChanged()) {
            this.config.save();
        }
    }
}

