/*
 * Decompiled with CFR 0.152.
 */
package io.github.tehstoneman.cashcraft.economy;

import io.github.tehstoneman.cashcraft.api.IEcomomy;
import io.github.tehstoneman.cashcraft.common.item.ItemCash;
import io.github.tehstoneman.cashcraft.common.item.ItemCashCraft;
import io.github.tehstoneman.cashcraft.config.CashCraftConfig;
import io.github.tehstoneman.cashcraft.economy.PlayerWallet;
import net.minecraft.client.resources.I18n;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;

public class Economy
implements IEcomomy {
    @Override
    public Boolean isEnabled() {
        return CashCraftConfig.useEconomy;
    }

    @Override
    public PlayerWallet getWallet(EntityPlayer player) {
        if (player != null) {
            return new PlayerWallet(player);
        }
        return null;
    }

    @Override
    public String getCurrencyName(boolean plural, boolean longFormat) {
        if (plural) {
            if (!CashCraftConfig.useCustomName) {
                if (longFormat) {
                    if (CashCraftConfig.showAsCoins) {
                        return "economy.cashcraft.coinplural.long";
                    }
                    return "economy.cashcraft.cashplural.long";
                }
                if (CashCraftConfig.showAsCoins) {
                    return "economy.cashcraft.coinplural.short";
                }
                return "economy.cashcraft.cashplural.short";
            }
            return CashCraftConfig.cashPlural;
        }
        if (!CashCraftConfig.useCustomName) {
            if (longFormat) {
                if (CashCraftConfig.showAsCoins) {
                    return "economy.cashcraft.coinsingular.long";
                }
                return "economy.cashcraft.cashsingular.long";
            }
            if (CashCraftConfig.showAsCoins) {
                return "economy.cashcraft.coinsingular.short";
            }
            return "economy.cashcraft.cashsingular.short";
        }
        return CashCraftConfig.cashSingular;
    }

    @Override
    public ItemStack getCash(long amount) {
        int i = ItemCash.EnumCoinValue.values().length - 1;
        while ((long)ItemCash.EnumCoinValue.byMetadata(i).getValue() > amount) {
            --i;
        }
        int count = (int)(amount / (long)ItemCash.EnumCoinValue.byMetadata(i).getValue());
        return new ItemStack((Item)ItemCashCraft.COIN, count, i);
    }

    @Override
    public long getValue(ItemStack itemStack) {
        int count = itemStack.func_190916_E();
        int value = ItemCash.EnumCoinValue.byMetadata(itemStack.func_77952_i()).getValue();
        return count * value;
    }

    @Override
    public String toString(long amount) {
        return this.toString(amount, false);
    }

    @Override
    public String toString(long amount, boolean longFormat) {
        if (CashCraftConfig.showAsCoins) {
            return I18n.func_135052_a((String)this.getCurrencyName(amount != 1L, longFormat), (Object[])new Object[]{String.format("%d", amount)});
        }
        long numerator = amount / 100L;
        long demoninator = amount % 100L;
        return I18n.func_135052_a((String)this.getCurrencyName(numerator != 1L, longFormat), (Object[])new Object[]{String.format("%d.%02d", numerator, demoninator)});
    }
}

